package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomDBEngineVersionAMI(
    imageId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CustomDBEngineVersionAMI = {
    import CustomDBEngineVersionAMI.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CustomDBEngineVersionAMI
      .builder()
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CustomDBEngineVersionAMI.ReadOnly =
    zio.aws.rds.model.CustomDBEngineVersionAMI.wrap(buildAwsValue())
}
object CustomDBEngineVersionAMI {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CustomDBEngineVersionAMI
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CustomDBEngineVersionAMI =
      zio.aws.rds.model.CustomDBEngineVersionAMI(
        imageId.map(value => value),
        status.map(value => value)
      )
    def imageId: Optional[String]
    def status: Optional[String]
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CustomDBEngineVersionAMI
  ) extends zio.aws.rds.model.CustomDBEngineVersionAMI.ReadOnly {
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CustomDBEngineVersionAMI
  ): zio.aws.rds.model.CustomDBEngineVersionAMI.ReadOnly = new Wrapper(impl)
}
