package zio.aws.rds.model
import zio.aws.rds.model.primitives.{IntegrationName, Arn, SourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateIntegrationRequest(
    sourceArn: SourceArn,
    targetArn: Arn,
    integrationName: IntegrationName,
    kmsKeyId: Optional[String] = Optional.Absent,
    additionalEncryptionContext: Optional[Map[String, String]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateIntegrationRequest = {
    import CreateIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateIntegrationRequest
      .builder()
      .sourceArn(SourceArn.unwrap(sourceArn): java.lang.String)
      .targetArn(Arn.unwrap(targetArn): java.lang.String)
      .integrationName(
        IntegrationName.unwrap(integrationName): java.lang.String
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        additionalEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalEncryptionContext)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateIntegrationRequest.ReadOnly =
    zio.aws.rds.model.CreateIntegrationRequest.wrap(buildAwsValue())
}
object CreateIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateIntegrationRequest =
      zio.aws.rds.model.CreateIntegrationRequest(
        sourceArn,
        targetArn,
        integrationName,
        kmsKeyId.map(value => value),
        additionalEncryptionContext.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceArn: SourceArn
    def targetArn: Arn
    def integrationName: IntegrationName
    def kmsKeyId: Optional[String]
    def additionalEncryptionContext: Optional[Map[String, String]]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getSourceArn: ZIO[Any, Nothing, SourceArn] = ZIO.succeed(sourceArn)
    def getTargetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(targetArn)
    def getIntegrationName: ZIO[Any, Nothing, IntegrationName] =
      ZIO.succeed(integrationName)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getAdditionalEncryptionContext
        : ZIO[Any, AwsError, Map[String, String]] = AwsError.unwrapOptionField(
      "additionalEncryptionContext",
      additionalEncryptionContext
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateIntegrationRequest
  ) extends zio.aws.rds.model.CreateIntegrationRequest.ReadOnly {
    override val sourceArn: SourceArn =
      zio.aws.rds.model.primitives.SourceArn(impl.sourceArn())
    override val targetArn: Arn =
      zio.aws.rds.model.primitives.Arn(impl.targetArn())
    override val integrationName: IntegrationName =
      zio.aws.rds.model.primitives.IntegrationName(impl.integrationName())
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val additionalEncryptionContext: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalEncryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateIntegrationRequest
  ): zio.aws.rds.model.CreateIntegrationRequest.ReadOnly = new Wrapper(impl)
}
