package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBlueGreenDeploymentResponse(
    blueGreenDeployment: Optional[zio.aws.rds.model.BlueGreenDeployment] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse = {
    import CreateBlueGreenDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse
      .builder()
      .optionallyWith(blueGreenDeployment.map(value => value.buildAwsValue()))(
        _.blueGreenDeployment
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateBlueGreenDeploymentResponse.ReadOnly =
    zio.aws.rds.model.CreateBlueGreenDeploymentResponse.wrap(buildAwsValue())
}
object CreateBlueGreenDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateBlueGreenDeploymentResponse =
      zio.aws.rds.model.CreateBlueGreenDeploymentResponse(
        blueGreenDeployment.map(value => value.asEditable)
      )
    def blueGreenDeployment
        : Optional[zio.aws.rds.model.BlueGreenDeployment.ReadOnly]
    def getBlueGreenDeployment
        : ZIO[Any, AwsError, zio.aws.rds.model.BlueGreenDeployment.ReadOnly] =
      AwsError.unwrapOptionField("blueGreenDeployment", blueGreenDeployment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse
  ) extends zio.aws.rds.model.CreateBlueGreenDeploymentResponse.ReadOnly {
    override val blueGreenDeployment
        : Optional[zio.aws.rds.model.BlueGreenDeployment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blueGreenDeployment())
        .map(value => zio.aws.rds.model.BlueGreenDeployment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse
  ): zio.aws.rds.model.CreateBlueGreenDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
