package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  TargetDBClusterParameterGroupName,
  BooleanOptional,
  TargetEngineVersion,
  TargetDBInstanceClass,
  TargetDBParameterGroupName,
  DatabaseArn,
  BlueGreenDeploymentName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBlueGreenDeploymentRequest(
    blueGreenDeploymentName: BlueGreenDeploymentName,
    source: DatabaseArn,
    targetEngineVersion: Optional[TargetEngineVersion] = Optional.Absent,
    targetDBParameterGroupName: Optional[TargetDBParameterGroupName] =
      Optional.Absent,
    targetDBClusterParameterGroupName: Optional[
      TargetDBClusterParameterGroupName
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    targetDBInstanceClass: Optional[TargetDBInstanceClass] = Optional.Absent,
    upgradeTargetStorageConfig: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest = {
    import CreateBlueGreenDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest
      .builder()
      .blueGreenDeploymentName(
        BlueGreenDeploymentName.unwrap(
          blueGreenDeploymentName
        ): java.lang.String
      )
      .source(DatabaseArn.unwrap(source): java.lang.String)
      .optionallyWith(
        targetEngineVersion.map(value =>
          TargetEngineVersion.unwrap(value): java.lang.String
        )
      )(_.targetEngineVersion)
      .optionallyWith(
        targetDBParameterGroupName.map(value =>
          TargetDBParameterGroupName.unwrap(value): java.lang.String
        )
      )(_.targetDBParameterGroupName)
      .optionallyWith(
        targetDBClusterParameterGroupName.map(value =>
          TargetDBClusterParameterGroupName.unwrap(value): java.lang.String
        )
      )(_.targetDBClusterParameterGroupName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        targetDBInstanceClass.map(value =>
          TargetDBInstanceClass.unwrap(value): java.lang.String
        )
      )(_.targetDBInstanceClass)
      .optionallyWith(
        upgradeTargetStorageConfig.map(value => value: java.lang.Boolean)
      )(_.upgradeTargetStorageConfig)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateBlueGreenDeploymentRequest.ReadOnly =
    zio.aws.rds.model.CreateBlueGreenDeploymentRequest.wrap(buildAwsValue())
}
object CreateBlueGreenDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateBlueGreenDeploymentRequest =
      zio.aws.rds.model.CreateBlueGreenDeploymentRequest(
        blueGreenDeploymentName,
        source,
        targetEngineVersion.map(value => value),
        targetDBParameterGroupName.map(value => value),
        targetDBClusterParameterGroupName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetDBInstanceClass.map(value => value),
        upgradeTargetStorageConfig.map(value => value)
      )
    def blueGreenDeploymentName: BlueGreenDeploymentName
    def source: DatabaseArn
    def targetEngineVersion: Optional[TargetEngineVersion]
    def targetDBParameterGroupName: Optional[TargetDBParameterGroupName]
    def targetDBClusterParameterGroupName
        : Optional[TargetDBClusterParameterGroupName]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def targetDBInstanceClass: Optional[TargetDBInstanceClass]
    def upgradeTargetStorageConfig: Optional[BooleanOptional]
    def getBlueGreenDeploymentName: ZIO[Any, Nothing, BlueGreenDeploymentName] =
      ZIO.succeed(blueGreenDeploymentName)
    def getSource: ZIO[Any, Nothing, DatabaseArn] = ZIO.succeed(source)
    def getTargetEngineVersion: ZIO[Any, AwsError, TargetEngineVersion] =
      AwsError.unwrapOptionField("targetEngineVersion", targetEngineVersion)
    def getTargetDBParameterGroupName
        : ZIO[Any, AwsError, TargetDBParameterGroupName] =
      AwsError.unwrapOptionField(
        "targetDBParameterGroupName",
        targetDBParameterGroupName
      )
    def getTargetDBClusterParameterGroupName
        : ZIO[Any, AwsError, TargetDBClusterParameterGroupName] =
      AwsError.unwrapOptionField(
        "targetDBClusterParameterGroupName",
        targetDBClusterParameterGroupName
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTargetDBInstanceClass: ZIO[Any, AwsError, TargetDBInstanceClass] =
      AwsError.unwrapOptionField("targetDBInstanceClass", targetDBInstanceClass)
    def getUpgradeTargetStorageConfig: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "upgradeTargetStorageConfig",
        upgradeTargetStorageConfig
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest
  ) extends zio.aws.rds.model.CreateBlueGreenDeploymentRequest.ReadOnly {
    override val blueGreenDeploymentName: BlueGreenDeploymentName =
      zio.aws.rds.model.primitives
        .BlueGreenDeploymentName(impl.blueGreenDeploymentName())
    override val source: DatabaseArn =
      zio.aws.rds.model.primitives.DatabaseArn(impl.source())
    override val targetEngineVersion: Optional[TargetEngineVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetEngineVersion())
        .map(value => zio.aws.rds.model.primitives.TargetEngineVersion(value))
    override val targetDBParameterGroupName
        : Optional[TargetDBParameterGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.targetDBParameterGroupName())
      .map(value =>
        zio.aws.rds.model.primitives.TargetDBParameterGroupName(value)
      )
    override val targetDBClusterParameterGroupName
        : Optional[TargetDBClusterParameterGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.targetDBClusterParameterGroupName())
      .map(value =>
        zio.aws.rds.model.primitives.TargetDBClusterParameterGroupName(value)
      )
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val targetDBInstanceClass: Optional[TargetDBInstanceClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetDBInstanceClass())
        .map(value => zio.aws.rds.model.primitives.TargetDBInstanceClass(value))
    override val upgradeTargetStorageConfig: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeTargetStorageConfig())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest
  ): zio.aws.rds.model.CreateBlueGreenDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
