package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{IntegerOptional, BooleanOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ClusterPendingModifiedValues(
    pendingCloudwatchLogsExports: Optional[
      zio.aws.rds.model.PendingCloudwatchLogsExports
    ] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    rdsCustomClusterConfiguration: Optional[
      zio.aws.rds.model.RdsCustomClusterConfiguration
    ] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues = {
    import ClusterPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues
      .builder()
      .optionallyWith(
        pendingCloudwatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudwatchLogsExports)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        rdsCustomClusterConfiguration.map(value => value.buildAwsValue())
      )(_.rdsCustomClusterConfiguration)
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly =
    zio.aws.rds.model.ClusterPendingModifiedValues.wrap(buildAwsValue())
}
object ClusterPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ClusterPendingModifiedValues =
      zio.aws.rds.model.ClusterPendingModifiedValues(
        pendingCloudwatchLogsExports.map(value => value.asEditable),
        dbClusterIdentifier.map(value => value),
        masterUserPassword.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        engineVersion.map(value => value),
        backupRetentionPeriod.map(value => value),
        allocatedStorage.map(value => value),
        rdsCustomClusterConfiguration.map(value => value.asEditable),
        iops.map(value => value),
        storageType.map(value => value)
      )
    def pendingCloudwatchLogsExports
        : Optional[zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly]
    def dbClusterIdentifier: Optional[String]
    def masterUserPassword: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def allocatedStorage: Optional[IntegerOptional]
    def rdsCustomClusterConfiguration
        : Optional[zio.aws.rds.model.RdsCustomClusterConfiguration.ReadOnly]
    def iops: Optional[IntegerOptional]
    def storageType: Optional[String]
    def getPendingCloudwatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudwatchLogsExports",
      pendingCloudwatchLogsExports
    )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getIamDatabaseAuthenticationEnabled
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "iamDatabaseAuthenticationEnabled",
      iamDatabaseAuthenticationEnabled
    )
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getRdsCustomClusterConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.RdsCustomClusterConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rdsCustomClusterConfiguration",
      rdsCustomClusterConfiguration
    )
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues
  ) extends zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly {
    override val pendingCloudwatchLogsExports
        : Optional[zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingCloudwatchLogsExports())
        .map(value =>
          zio.aws.rds.model.PendingCloudwatchLogsExports.wrap(value)
        )
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val rdsCustomClusterConfiguration
        : Optional[zio.aws.rds.model.RdsCustomClusterConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rdsCustomClusterConfiguration())
        .map(value =>
          zio.aws.rds.model.RdsCustomClusterConfiguration.wrap(value)
        )
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues
  ): zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly = new Wrapper(impl)
}
