package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class CertificateDetails(
    caIdentifier: Optional[String] = Optional.Absent,
    validTill: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CertificateDetails = {
    import CertificateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CertificateDetails
      .builder()
      .optionallyWith(caIdentifier.map(value => value: java.lang.String))(
        _.caIdentifier
      )
      .optionallyWith(validTill.map(value => TStamp.unwrap(value): Instant))(
        _.validTill
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CertificateDetails.ReadOnly =
    zio.aws.rds.model.CertificateDetails.wrap(buildAwsValue())
}
object CertificateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CertificateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CertificateDetails =
      zio.aws.rds.model.CertificateDetails(
        caIdentifier.map(value => value),
        validTill.map(value => value)
      )
    def caIdentifier: Optional[String]
    def validTill: Optional[TStamp]
    def getCaIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("caIdentifier", caIdentifier)
    def getValidTill: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validTill", validTill)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CertificateDetails
  ) extends zio.aws.rds.model.CertificateDetails.ReadOnly {
    override val caIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.caIdentifier())
      .map(value => value: String)
    override val validTill: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.validTill())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CertificateDetails
  ): zio.aws.rds.model.CertificateDetails.ReadOnly = new Wrapper(impl)
}
