package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  BlueGreenDeploymentIdentifier,
  BlueGreenDeploymentStatus,
  TStamp,
  BlueGreenDeploymentStatusDetails,
  DatabaseArn,
  BlueGreenDeploymentName
}
import scala.jdk.CollectionConverters.*
final case class BlueGreenDeployment(
    blueGreenDeploymentIdentifier: Optional[BlueGreenDeploymentIdentifier] =
      Optional.Absent,
    blueGreenDeploymentName: Optional[BlueGreenDeploymentName] =
      Optional.Absent,
    source: Optional[DatabaseArn] = Optional.Absent,
    target: Optional[DatabaseArn] = Optional.Absent,
    switchoverDetails: Optional[Iterable[zio.aws.rds.model.SwitchoverDetail]] =
      Optional.Absent,
    tasks: Optional[Iterable[zio.aws.rds.model.BlueGreenDeploymentTask]] =
      Optional.Absent,
    status: Optional[BlueGreenDeploymentStatus] = Optional.Absent,
    statusDetails: Optional[BlueGreenDeploymentStatusDetails] = Optional.Absent,
    createTime: Optional[TStamp] = Optional.Absent,
    deleteTime: Optional[TStamp] = Optional.Absent,
    tagList: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.BlueGreenDeployment = {
    import BlueGreenDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.BlueGreenDeployment
      .builder()
      .optionallyWith(
        blueGreenDeploymentIdentifier.map(value =>
          BlueGreenDeploymentIdentifier.unwrap(value): java.lang.String
        )
      )(_.blueGreenDeploymentIdentifier)
      .optionallyWith(
        blueGreenDeploymentName.map(value =>
          BlueGreenDeploymentName.unwrap(value): java.lang.String
        )
      )(_.blueGreenDeploymentName)
      .optionallyWith(
        source.map(value => DatabaseArn.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        target.map(value => DatabaseArn.unwrap(value): java.lang.String)
      )(_.target)
      .optionallyWith(
        switchoverDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.switchoverDetails)
      .optionallyWith(
        tasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tasks)
      .optionallyWith(
        status.map(value =>
          BlueGreenDeploymentStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          BlueGreenDeploymentStatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(createTime.map(value => TStamp.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(deleteTime.map(value => TStamp.unwrap(value): Instant))(
        _.deleteTime
      )
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.BlueGreenDeployment.ReadOnly =
    zio.aws.rds.model.BlueGreenDeployment.wrap(buildAwsValue())
}
object BlueGreenDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.BlueGreenDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.BlueGreenDeployment =
      zio.aws.rds.model.BlueGreenDeployment(
        blueGreenDeploymentIdentifier.map(value => value),
        blueGreenDeploymentName.map(value => value),
        source.map(value => value),
        target.map(value => value),
        switchoverDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        statusDetails.map(value => value),
        createTime.map(value => value),
        deleteTime.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def blueGreenDeploymentIdentifier: Optional[BlueGreenDeploymentIdentifier]
    def blueGreenDeploymentName: Optional[BlueGreenDeploymentName]
    def source: Optional[DatabaseArn]
    def target: Optional[DatabaseArn]
    def switchoverDetails
        : Optional[List[zio.aws.rds.model.SwitchoverDetail.ReadOnly]]
    def tasks
        : Optional[List[zio.aws.rds.model.BlueGreenDeploymentTask.ReadOnly]]
    def status: Optional[BlueGreenDeploymentStatus]
    def statusDetails: Optional[BlueGreenDeploymentStatusDetails]
    def createTime: Optional[TStamp]
    def deleteTime: Optional[TStamp]
    def tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getBlueGreenDeploymentIdentifier
        : ZIO[Any, AwsError, BlueGreenDeploymentIdentifier] =
      AwsError.unwrapOptionField(
        "blueGreenDeploymentIdentifier",
        blueGreenDeploymentIdentifier
      )
    def getBlueGreenDeploymentName
        : ZIO[Any, AwsError, BlueGreenDeploymentName] = AwsError
      .unwrapOptionField("blueGreenDeploymentName", blueGreenDeploymentName)
    def getSource: ZIO[Any, AwsError, DatabaseArn] =
      AwsError.unwrapOptionField("source", source)
    def getTarget: ZIO[Any, AwsError, DatabaseArn] =
      AwsError.unwrapOptionField("target", target)
    def getSwitchoverDetails: ZIO[Any, AwsError, List[
      zio.aws.rds.model.SwitchoverDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("switchoverDetails", switchoverDetails)
    def getTasks: ZIO[Any, AwsError, List[
      zio.aws.rds.model.BlueGreenDeploymentTask.ReadOnly
    ]] = AwsError.unwrapOptionField("tasks", tasks)
    def getStatus: ZIO[Any, AwsError, BlueGreenDeploymentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, BlueGreenDeploymentStatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getDeleteTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("deleteTime", deleteTime)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.BlueGreenDeployment
  ) extends zio.aws.rds.model.BlueGreenDeployment.ReadOnly {
    override val blueGreenDeploymentIdentifier
        : Optional[BlueGreenDeploymentIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.blueGreenDeploymentIdentifier())
      .map(value =>
        zio.aws.rds.model.primitives.BlueGreenDeploymentIdentifier(value)
      )
    override val blueGreenDeploymentName: Optional[BlueGreenDeploymentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blueGreenDeploymentName())
        .map(value =>
          zio.aws.rds.model.primitives.BlueGreenDeploymentName(value)
        )
    override val source: Optional[DatabaseArn] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.rds.model.primitives.DatabaseArn(value))
    override val target: Optional[DatabaseArn] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value => zio.aws.rds.model.primitives.DatabaseArn(value))
    override val switchoverDetails
        : Optional[List[zio.aws.rds.model.SwitchoverDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.switchoverDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.SwitchoverDetail.wrap(item)
          }.toList
        )
    override val tasks
        : Optional[List[zio.aws.rds.model.BlueGreenDeploymentTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.BlueGreenDeploymentTask.wrap(item)
          }.toList
        )
    override val status: Optional[BlueGreenDeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.rds.model.primitives.BlueGreenDeploymentStatus(value)
        )
    override val statusDetails: Optional[BlueGreenDeploymentStatusDetails] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value =>
          zio.aws.rds.model.primitives.BlueGreenDeploymentStatusDetails(value)
        )
    override val createTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val deleteTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.BlueGreenDeployment
  ): zio.aws.rds.model.BlueGreenDeployment.ReadOnly = new Wrapper(impl)
}
