package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SwitchoverReadReplicaResponse(
    dbInstance: Optional[zio.aws.rds.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse = {
    import SwitchoverReadReplicaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.SwitchoverReadReplicaResponse.ReadOnly =
    zio.aws.rds.model.SwitchoverReadReplicaResponse.wrap(buildAwsValue())
}
object SwitchoverReadReplicaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.SwitchoverReadReplicaResponse =
      zio.aws.rds.model.SwitchoverReadReplicaResponse(
        dbInstance.map(value => value.asEditable)
      )
    def dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse
  ) extends zio.aws.rds.model.SwitchoverReadReplicaResponse.ReadOnly {
    override val dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse
  ): zio.aws.rds.model.SwitchoverReadReplicaResponse.ReadOnly = new Wrapper(
    impl
  )
}
