package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  SwitchoverTimeout,
  BlueGreenDeploymentIdentifier
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SwitchoverBlueGreenDeploymentRequest(
    blueGreenDeploymentIdentifier: BlueGreenDeploymentIdentifier,
    switchoverTimeout: Optional[SwitchoverTimeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest = {
    import SwitchoverBlueGreenDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest
      .builder()
      .blueGreenDeploymentIdentifier(
        BlueGreenDeploymentIdentifier.unwrap(
          blueGreenDeploymentIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        switchoverTimeout.map(value => SwitchoverTimeout.unwrap(value): Integer)
      )(_.switchoverTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest.ReadOnly =
    zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest.wrap(buildAwsValue())
}
object SwitchoverBlueGreenDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest =
      zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest(
        blueGreenDeploymentIdentifier,
        switchoverTimeout.map(value => value)
      )
    def blueGreenDeploymentIdentifier: BlueGreenDeploymentIdentifier
    def switchoverTimeout: Optional[SwitchoverTimeout]
    def getBlueGreenDeploymentIdentifier
        : ZIO[Any, Nothing, BlueGreenDeploymentIdentifier] =
      ZIO.succeed(blueGreenDeploymentIdentifier)
    def getSwitchoverTimeout: ZIO[Any, AwsError, SwitchoverTimeout] =
      AwsError.unwrapOptionField("switchoverTimeout", switchoverTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest
  ) extends zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest.ReadOnly {
    override val blueGreenDeploymentIdentifier: BlueGreenDeploymentIdentifier =
      zio.aws.rds.model.primitives
        .BlueGreenDeploymentIdentifier(impl.blueGreenDeploymentIdentifier())
    override val switchoverTimeout: Optional[SwitchoverTimeout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.switchoverTimeout())
        .map(value => zio.aws.rds.model.primitives.SwitchoverTimeout(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest
  ): zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest.ReadOnly =
    new Wrapper(impl)
}
