package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartDbInstanceAutomatedBackupsReplicationRequest(
    sourceDBInstanceArn: String,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    preSignedUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest = {
    import StartDbInstanceAutomatedBackupsReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
      .builder()
      .sourceDBInstanceArn(sourceDBInstanceArn: java.lang.String)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest.ReadOnly =
    zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
      .wrap(buildAwsValue())
}
object StartDbInstanceAutomatedBackupsReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest =
      zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest(
        sourceDBInstanceArn,
        backupRetentionPeriod.map(value => value),
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value)
      )
    def sourceDBInstanceArn: String
    def backupRetentionPeriod: Optional[IntegerOptional]
    def kmsKeyId: Optional[String]
    def preSignedUrl: Optional[String]
    def getSourceDBInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBInstanceArn)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
  ) extends zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest.ReadOnly {
    override val sourceDBInstanceArn: String =
      impl.sourceDBInstanceArn(): String
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val preSignedUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preSignedUrl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
  ): zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest.ReadOnly =
    new Wrapper(impl)
}
