package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RestoreDbClusterFromS3Request(
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    characterSetName: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    dbClusterIdentifier: String,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    engine: String,
    engineVersion: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    masterUsername: String,
    masterUserPassword: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    storageEncrypted: Optional[BooleanOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    sourceEngine: String,
    sourceEngineVersion: String,
    s3BucketName: String,
    s3Prefix: Optional[String] = Optional.Absent,
    s3IngestionRoleArn: String,
    backtrackWindow: Optional[LongOptional] = Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfiguration
    ] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent,
    manageMasterUserPassword: Optional[BooleanOptional] = Optional.Absent,
    masterUserSecretKmsKeyId: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request = {
    import RestoreDbClusterFromS3Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .masterUsername(masterUsername: java.lang.String)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .sourceEngine(sourceEngine: java.lang.String)
      .sourceEngineVersion(sourceEngineVersion: java.lang.String)
      .s3BucketName(s3BucketName: java.lang.String)
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .s3IngestionRoleArn(s3IngestionRoleArn: java.lang.String)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(
        serverlessV2ScalingConfiguration.map(value => value.buildAwsValue())
      )(_.serverlessV2ScalingConfiguration)
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .optionallyWith(
        manageMasterUserPassword.map(value => value: java.lang.Boolean)
      )(_.manageMasterUserPassword)
      .optionallyWith(
        masterUserSecretKmsKeyId.map(value => value: java.lang.String)
      )(_.masterUserSecretKmsKeyId)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RestoreDbClusterFromS3Request.ReadOnly =
    zio.aws.rds.model.RestoreDbClusterFromS3Request.wrap(buildAwsValue())
}
object RestoreDbClusterFromS3Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreDbClusterFromS3Request =
      zio.aws.rds.model.RestoreDbClusterFromS3Request(
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        characterSetName.map(value => value),
        databaseName.map(value => value),
        dbClusterIdentifier,
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        dbSubnetGroupName.map(value => value),
        engine,
        engineVersion.map(value => value),
        port.map(value => value),
        masterUsername,
        masterUserPassword.map(value => value),
        optionGroupName.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        sourceEngine,
        sourceEngineVersion,
        s3BucketName,
        s3Prefix.map(value => value),
        s3IngestionRoleArn,
        backtrackWindow.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value),
        copyTagsToSnapshot.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        serverlessV2ScalingConfiguration.map(value => value.asEditable),
        networkType.map(value => value),
        manageMasterUserPassword.map(value => value),
        masterUserSecretKmsKeyId.map(value => value),
        storageType.map(value => value)
      )
    def availabilityZones: Optional[List[String]]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def characterSetName: Optional[String]
    def databaseName: Optional[String]
    def dbClusterIdentifier: String
    def dbClusterParameterGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def dbSubnetGroupName: Optional[String]
    def engine: String
    def engineVersion: Optional[String]
    def port: Optional[IntegerOptional]
    def masterUsername: String
    def masterUserPassword: Optional[String]
    def optionGroupName: Optional[String]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def storageEncrypted: Optional[BooleanOptional]
    def kmsKeyId: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def sourceEngine: String
    def sourceEngineVersion: String
    def s3BucketName: String
    def s3Prefix: Optional[String]
    def s3IngestionRoleArn: String
    def backtrackWindow: Optional[LongOptional]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def deletionProtection: Optional[BooleanOptional]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def domain: Optional[String]
    def domainIAMRoleName: Optional[String]
    def serverlessV2ScalingConfiguration
        : Optional[zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly]
    def networkType: Optional[String]
    def manageMasterUserPassword: Optional[BooleanOptional]
    def masterUserSecretKmsKeyId: Optional[String]
    def storageType: Optional[String]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUsername)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getSourceEngine: ZIO[Any, Nothing, String] = ZIO.succeed(sourceEngine)
    def getSourceEngineVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceEngineVersion)
    def getS3BucketName: ZIO[Any, Nothing, String] = ZIO.succeed(s3BucketName)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getS3IngestionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(s3IngestionRoleArn)
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getServerlessV2ScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverlessV2ScalingConfiguration",
      serverlessV2ScalingConfiguration
    )
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getManageMasterUserPassword: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "manageMasterUserPassword",
        manageMasterUserPassword
      )
    def getMasterUserSecretKmsKeyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("masterUserSecretKmsKeyId", masterUserSecretKmsKeyId)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request
  ) extends zio.aws.rds.model.RestoreDbClusterFromS3Request.ReadOnly {
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val characterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.characterSetName())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val engine: String = impl.engine(): String
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val masterUsername: String = impl.masterUsername(): String
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val storageEncrypted: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEncrypted())
        .map(value => value: BooleanOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val sourceEngine: String = impl.sourceEngine(): String
    override val sourceEngineVersion: String =
      impl.sourceEngineVersion(): String
    override val s3BucketName: String = impl.s3BucketName(): String
    override val s3Prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => value: String)
    override val s3IngestionRoleArn: String = impl.s3IngestionRoleArn(): String
    override val backtrackWindow: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackWindow())
      .map(value => value: LongOptional)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessV2ScalingConfiguration())
      .map(value =>
        zio.aws.rds.model.ServerlessV2ScalingConfiguration.wrap(value)
      )
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
    override val manageMasterUserPassword: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manageMasterUserPassword())
        .map(value => value: BooleanOptional)
    override val masterUserSecretKmsKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserSecretKmsKeyId())
        .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request
  ): zio.aws.rds.model.RestoreDbClusterFromS3Request.ReadOnly = new Wrapper(
    impl
  )
}
