package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class OptionGroup(
    optionGroupName: Optional[String] = Optional.Absent,
    optionGroupDescription: Optional[String] = Optional.Absent,
    engineName: Optional[String] = Optional.Absent,
    majorEngineVersion: Optional[String] = Optional.Absent,
    options: Optional[Iterable[zio.aws.rds.model.Option]] = Optional.Absent,
    allowsVpcAndNonVpcInstanceMemberships: Optional[Boolean] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    optionGroupArn: Optional[String] = Optional.Absent,
    sourceOptionGroup: Optional[String] = Optional.Absent,
    sourceAccountId: Optional[String] = Optional.Absent,
    copyTimestamp: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.OptionGroup = {
    import OptionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionGroup
      .builder()
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        optionGroupDescription.map(value => value: java.lang.String)
      )(_.optionGroupDescription)
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(
        _.majorEngineVersion
      )
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.options)
      .optionallyWith(
        allowsVpcAndNonVpcInstanceMemberships.map(value =>
          value: java.lang.Boolean
        )
      )(_.allowsVpcAndNonVpcInstanceMemberships)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(optionGroupArn.map(value => value: java.lang.String))(
        _.optionGroupArn
      )
      .optionallyWith(sourceOptionGroup.map(value => value: java.lang.String))(
        _.sourceOptionGroup
      )
      .optionallyWith(sourceAccountId.map(value => value: java.lang.String))(
        _.sourceAccountId
      )
      .optionallyWith(
        copyTimestamp.map(value => TStamp.unwrap(value): Instant)
      )(_.copyTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionGroup.ReadOnly =
    zio.aws.rds.model.OptionGroup.wrap(buildAwsValue())
}
object OptionGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.OptionGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionGroup =
      zio.aws.rds.model.OptionGroup(
        optionGroupName.map(value => value),
        optionGroupDescription.map(value => value),
        engineName.map(value => value),
        majorEngineVersion.map(value => value),
        options.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        allowsVpcAndNonVpcInstanceMemberships.map(value => value),
        vpcId.map(value => value),
        optionGroupArn.map(value => value),
        sourceOptionGroup.map(value => value),
        sourceAccountId.map(value => value),
        copyTimestamp.map(value => value)
      )
    def optionGroupName: Optional[String]
    def optionGroupDescription: Optional[String]
    def engineName: Optional[String]
    def majorEngineVersion: Optional[String]
    def options: Optional[List[zio.aws.rds.model.Option.ReadOnly]]
    def allowsVpcAndNonVpcInstanceMemberships: Optional[Boolean]
    def vpcId: Optional[String]
    def optionGroupArn: Optional[String]
    def sourceOptionGroup: Optional[String]
    def sourceAccountId: Optional[String]
    def copyTimestamp: Optional[TStamp]
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getOptionGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("optionGroupDescription", optionGroupDescription)
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getMajorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersion)
    def getOptions
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Option.ReadOnly]] =
      AwsError.unwrapOptionField("options", options)
    def getAllowsVpcAndNonVpcInstanceMemberships: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "allowsVpcAndNonVpcInstanceMemberships",
        allowsVpcAndNonVpcInstanceMemberships
      )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOptionGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupArn", optionGroupArn)
    def getSourceOptionGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceOptionGroup", sourceOptionGroup)
    def getSourceAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceAccountId", sourceAccountId)
    def getCopyTimestamp: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("copyTimestamp", copyTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionGroup
  ) extends zio.aws.rds.model.OptionGroup.ReadOnly {
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val optionGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionGroupDescription())
        .map(value => value: String)
    override val engineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineName())
      .map(value => value: String)
    override val majorEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.majorEngineVersion())
      .map(value => value: String)
    override val options: Optional[List[zio.aws.rds.model.Option.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Option.wrap(item)
          }.toList
        )
    override val allowsVpcAndNonVpcInstanceMemberships: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsVpcAndNonVpcInstanceMemberships())
        .map(value => value: Boolean)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val optionGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupArn())
      .map(value => value: String)
    override val sourceOptionGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceOptionGroup())
      .map(value => value: String)
    override val sourceAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAccountId())
      .map(value => value: String)
    override val copyTimestamp: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTimestamp())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionGroup
  ): zio.aws.rds.model.OptionGroup.ReadOnly = new Wrapper(impl)
}
