package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyActivityStreamResponse(
    kmsKeyId: Optional[String] = Optional.Absent,
    kinesisStreamName: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.rds.model.ActivityStreamStatus] = Optional.Absent,
    mode: Optional[zio.aws.rds.model.ActivityStreamMode] = Optional.Absent,
    engineNativeAuditFieldsIncluded: Optional[BooleanOptional] =
      Optional.Absent,
    policyStatus: Optional[zio.aws.rds.model.ActivityStreamPolicyStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse = {
    import ModifyActivityStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(kinesisStreamName.map(value => value: java.lang.String))(
        _.kinesisStreamName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        engineNativeAuditFieldsIncluded.map(value => value: java.lang.Boolean)
      )(_.engineNativeAuditFieldsIncluded)
      .optionallyWith(policyStatus.map(value => value.unwrap))(_.policyStatus)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyActivityStreamResponse.ReadOnly =
    zio.aws.rds.model.ModifyActivityStreamResponse.wrap(buildAwsValue())
}
object ModifyActivityStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyActivityStreamResponse =
      zio.aws.rds.model.ModifyActivityStreamResponse(
        kmsKeyId.map(value => value),
        kinesisStreamName.map(value => value),
        status.map(value => value),
        mode.map(value => value),
        engineNativeAuditFieldsIncluded.map(value => value),
        policyStatus.map(value => value)
      )
    def kmsKeyId: Optional[String]
    def kinesisStreamName: Optional[String]
    def status: Optional[zio.aws.rds.model.ActivityStreamStatus]
    def mode: Optional[zio.aws.rds.model.ActivityStreamMode]
    def engineNativeAuditFieldsIncluded: Optional[BooleanOptional]
    def policyStatus: Optional[zio.aws.rds.model.ActivityStreamPolicyStatus]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kinesisStreamName", kinesisStreamName)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMode: ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getEngineNativeAuditFieldsIncluded
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "engineNativeAuditFieldsIncluded",
      engineNativeAuditFieldsIncluded
    )
    def getPolicyStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamPolicyStatus] =
      AwsError.unwrapOptionField("policyStatus", policyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse
  ) extends zio.aws.rds.model.ModifyActivityStreamResponse.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val kinesisStreamName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisStreamName())
      .map(value => value: String)
    override val status: Optional[zio.aws.rds.model.ActivityStreamStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
    override val mode: Optional[zio.aws.rds.model.ActivityStreamMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.rds.model.ActivityStreamMode.wrap(value))
    override val engineNativeAuditFieldsIncluded: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineNativeAuditFieldsIncluded())
        .map(value => value: BooleanOptional)
    override val policyStatus
        : Optional[zio.aws.rds.model.ActivityStreamPolicyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyStatus())
        .map(value => zio.aws.rds.model.ActivityStreamPolicyStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse
  ): zio.aws.rds.model.ModifyActivityStreamResponse.ReadOnly = new Wrapper(impl)
}
