package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MasterUserSecret(
    secretArn: Optional[String] = Optional.Absent,
    secretStatus: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.MasterUserSecret = {
    import MasterUserSecret.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.MasterUserSecret
      .builder()
      .optionallyWith(secretArn.map(value => value: java.lang.String))(
        _.secretArn
      )
      .optionallyWith(secretStatus.map(value => value: java.lang.String))(
        _.secretStatus
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.MasterUserSecret.ReadOnly =
    zio.aws.rds.model.MasterUserSecret.wrap(buildAwsValue())
}
object MasterUserSecret {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.MasterUserSecret
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.MasterUserSecret =
      zio.aws.rds.model.MasterUserSecret(
        secretArn.map(value => value),
        secretStatus.map(value => value),
        kmsKeyId.map(value => value)
      )
    def secretArn: Optional[String]
    def secretStatus: Optional[String]
    def kmsKeyId: Optional[String]
    def getSecretArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getSecretStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("secretStatus", secretStatus)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.MasterUserSecret
  ) extends zio.aws.rds.model.MasterUserSecret.ReadOnly {
    override val secretArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => value: String)
    override val secretStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.secretStatus())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.MasterUserSecret
  ): zio.aws.rds.model.MasterUserSecret.ReadOnly = new Wrapper(impl)
}
