package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.MaxRecords
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeExportTasksRequest(
    exportTaskIdentifier: Optional[String] = Optional.Absent,
    sourceArn: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxRecords: Optional[MaxRecords] = Optional.Absent,
    sourceType: Optional[zio.aws.rds.model.ExportSourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest = {
    import DescribeExportTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest
      .builder()
      .optionallyWith(
        exportTaskIdentifier.map(value => value: java.lang.String)
      )(_.exportTaskIdentifier)
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeExportTasksRequest.ReadOnly =
    zio.aws.rds.model.DescribeExportTasksRequest.wrap(buildAwsValue())
}
object DescribeExportTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeExportTasksRequest =
      zio.aws.rds.model.DescribeExportTasksRequest(
        exportTaskIdentifier.map(value => value),
        sourceArn.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value),
        sourceType.map(value => value)
      )
    def exportTaskIdentifier: Optional[String]
    def sourceArn: Optional[String]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def marker: Optional[String]
    def maxRecords: Optional[MaxRecords]
    def sourceType: Optional[zio.aws.rds.model.ExportSourceType]
    def getExportTaskIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exportTaskIdentifier", exportTaskIdentifier)
    def getSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getSourceType: ZIO[Any, AwsError, zio.aws.rds.model.ExportSourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest
  ) extends zio.aws.rds.model.DescribeExportTasksRequest.ReadOnly {
    override val exportTaskIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.exportTaskIdentifier())
      .map(value => value: String)
    override val sourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxRecords: Optional[MaxRecords] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.MaxRecords(value))
    override val sourceType: Optional[zio.aws.rds.model.ExportSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.rds.model.ExportSourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest
  ): zio.aws.rds.model.DescribeExportTasksRequest.ReadOnly = new Wrapper(impl)
}
