package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.MaxRecords
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDbProxiesRequest(
    dbProxyName: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxRecords: Optional[MaxRecords] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest = {
    import DescribeDbProxiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest
      .builder()
      .optionallyWith(dbProxyName.map(value => value: java.lang.String))(
        _.dbProxyName
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbProxiesRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbProxiesRequest.wrap(buildAwsValue())
}
object DescribeDbProxiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbProxiesRequest =
      zio.aws.rds.model.DescribeDbProxiesRequest(
        dbProxyName.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def dbProxyName: Optional[String]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def marker: Optional[String]
    def maxRecords: Optional[MaxRecords]
    def getDbProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyName", dbProxyName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest
  ) extends zio.aws.rds.model.DescribeDbProxiesRequest.ReadOnly {
    override val dbProxyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbProxyName())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxRecords: Optional[MaxRecords] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => zio.aws.rds.model.primitives.MaxRecords(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest
  ): zio.aws.rds.model.DescribeDbProxiesRequest.ReadOnly = new Wrapper(impl)
}
