package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteOptionGroupRequest(optionGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest = {
    import DeleteOptionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest
      .builder()
      .optionGroupName(optionGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteOptionGroupRequest.ReadOnly =
    zio.aws.rds.model.DeleteOptionGroupRequest.wrap(buildAwsValue())
}
object DeleteOptionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteOptionGroupRequest =
      zio.aws.rds.model.DeleteOptionGroupRequest(optionGroupName)
    def optionGroupName: String
    def getOptionGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(optionGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest
  ) extends zio.aws.rds.model.DeleteOptionGroupRequest.ReadOnly {
    override val optionGroupName: String = impl.optionGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest
  ): zio.aws.rds.model.DeleteOptionGroupRequest.ReadOnly = new Wrapper(impl)
}
