package zio.aws.rds.model
import scala.jdk.CollectionConverters.*
sealed trait DBProxyStatus {
  def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus
}
object DBProxyStatus {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.DBProxyStatus
  ): zio.aws.rds.model.DBProxyStatus = value match {
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.INCOMPATIBLE_NETWORK =>
      val r = `incompatible-network`
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.INSUFFICIENT_RESOURCE_LIMITS =>
      val r = `insufficient-resource-limits`
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.SUSPENDED =>
      val r = suspended
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.SUSPENDING =>
      val r = suspending
      r
    case software.amazon.awssdk.services.rds.model.DBProxyStatus.REACTIVATING =>
      val r = reactivating
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object available extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.AVAILABLE
  }
  case object modifying extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.MODIFYING
  }
  case object `incompatible-network` extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.INCOMPATIBLE_NETWORK
  }
  case object `insufficient-resource-limits`
      extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.INSUFFICIENT_RESOURCE_LIMITS
  }
  case object creating extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.CREATING
  }
  case object deleting extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.DELETING
  }
  case object suspended extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.SUSPENDED
  }
  case object suspending extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.SUSPENDING
  }
  case object reactivating extends zio.aws.rds.model.DBProxyStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.DBProxyStatus =
      software.amazon.awssdk.services.rds.model.DBProxyStatus.REACTIVATING
  }
}
