package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{
  LongOptional,
  BooleanOptional,
  TStamp,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DBCluster(
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    characterSetName: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    dbClusterParameterGroup: Optional[String] = Optional.Absent,
    dbSubnetGroup: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    automaticRestartTime: Optional[TStamp] = Optional.Absent,
    percentProgress: Optional[String] = Optional.Absent,
    earliestRestorableTime: Optional[TStamp] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    readerEndpoint: Optional[String] = Optional.Absent,
    customEndpoints: Optional[Iterable[String]] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    latestRestorableTime: Optional[TStamp] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    dbClusterOptionGroupMemberships: Optional[
      Iterable[zio.aws.rds.model.DBClusterOptionGroupStatus]
    ] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    replicationSourceIdentifier: Optional[String] = Optional.Absent,
    readReplicaIdentifiers: Optional[Iterable[String]] = Optional.Absent,
    dbClusterMembers: Optional[Iterable[zio.aws.rds.model.DBClusterMember]] =
      Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.rds.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    hostedZoneId: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    dbClusterResourceId: Optional[String] = Optional.Absent,
    dbClusterArn: Optional[String] = Optional.Absent,
    associatedRoles: Optional[Iterable[zio.aws.rds.model.DBClusterRole]] =
      Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      Optional.Absent,
    cloneGroupId: Optional[String] = Optional.Absent,
    clusterCreateTime: Optional[TStamp] = Optional.Absent,
    earliestBacktrackTime: Optional[TStamp] = Optional.Absent,
    backtrackWindow: Optional[LongOptional] = Optional.Absent,
    backtrackConsumedChangeRecords: Optional[LongOptional] = Optional.Absent,
    enabledCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    capacity: Optional[IntegerOptional] = Optional.Absent,
    engineMode: Optional[String] = Optional.Absent,
    scalingConfigurationInfo: Optional[
      zio.aws.rds.model.ScalingConfigurationInfo
    ] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    httpEndpointEnabled: Optional[BooleanOptional] = Optional.Absent,
    activityStreamMode: Optional[zio.aws.rds.model.ActivityStreamMode] =
      Optional.Absent,
    activityStreamStatus: Optional[zio.aws.rds.model.ActivityStreamStatus] =
      Optional.Absent,
    activityStreamKmsKeyId: Optional[String] = Optional.Absent,
    activityStreamKinesisStreamName: Optional[String] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    crossAccountClone: Optional[BooleanOptional] = Optional.Absent,
    domainMemberships: Optional[Iterable[zio.aws.rds.model.DomainMembership]] =
      Optional.Absent,
    tagList: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    globalWriteForwardingStatus: Optional[
      zio.aws.rds.model.WriteForwardingStatus
    ] = Optional.Absent,
    globalWriteForwardingRequested: Optional[BooleanOptional] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.rds.model.ClusterPendingModifiedValues
    ] = Optional.Absent,
    dbClusterInstanceClass: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    monitoringInterval: Optional[IntegerOptional] = Optional.Absent,
    monitoringRoleArn: Optional[String] = Optional.Absent,
    performanceInsightsEnabled: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent,
    performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfigurationInfo
    ] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent,
    dbSystemId: Optional[String] = Optional.Absent,
    masterUserSecret: Optional[zio.aws.rds.model.MasterUserSecret] =
      Optional.Absent,
    ioOptimizedNextAllowedModificationTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBCluster = {
    import DBCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBCluster
      .builder()
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterParameterGroup.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroup)
      .optionallyWith(dbSubnetGroup.map(value => value: java.lang.String))(
        _.dbSubnetGroup
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        automaticRestartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.automaticRestartTime)
      .optionallyWith(percentProgress.map(value => value: java.lang.String))(
        _.percentProgress
      )
      .optionallyWith(
        earliestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.earliestRestorableTime)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(readerEndpoint.map(value => value: java.lang.String))(
        _.readerEndpoint
      )
      .optionallyWith(
        customEndpoints.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.customEndpoints)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(
        dbClusterOptionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterOptionGroupMemberships)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        replicationSourceIdentifier.map(value => value: java.lang.String)
      )(_.replicationSourceIdentifier)
      .optionallyWith(
        readReplicaIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaIdentifiers)
      .optionallyWith(
        dbClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterMembers)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        dbClusterResourceId.map(value => value: java.lang.String)
      )(_.dbClusterResourceId)
      .optionallyWith(dbClusterArn.map(value => value: java.lang.String))(
        _.dbClusterArn
      )
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(cloneGroupId.map(value => value: java.lang.String))(
        _.cloneGroupId
      )
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(
        earliestBacktrackTime.map(value => TStamp.unwrap(value): Instant)
      )(_.earliestBacktrackTime)
      .optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(
        _.backtrackWindow
      )
      .optionallyWith(
        backtrackConsumedChangeRecords.map(value => value: java.lang.Long)
      )(_.backtrackConsumedChangeRecords)
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .optionallyWith(capacity.map(value => value: Integer))(_.capacity)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(
        scalingConfigurationInfo.map(value => value.buildAwsValue())
      )(_.scalingConfigurationInfo)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        httpEndpointEnabled.map(value => value: java.lang.Boolean)
      )(_.httpEndpointEnabled)
      .optionallyWith(activityStreamMode.map(value => value.unwrap))(
        _.activityStreamMode
      )
      .optionallyWith(activityStreamStatus.map(value => value.unwrap))(
        _.activityStreamStatus
      )
      .optionallyWith(
        activityStreamKmsKeyId.map(value => value: java.lang.String)
      )(_.activityStreamKmsKeyId)
      .optionallyWith(
        activityStreamKinesisStreamName.map(value => value: java.lang.String)
      )(_.activityStreamKinesisStreamName)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(crossAccountClone.map(value => value: java.lang.Boolean))(
        _.crossAccountClone
      )
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(globalWriteForwardingStatus.map(value => value.unwrap))(
        _.globalWriteForwardingStatus
      )
      .optionallyWith(
        globalWriteForwardingRequested.map(value => value: java.lang.Boolean)
      )(_.globalWriteForwardingRequested)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        dbClusterInstanceClass.map(value => value: java.lang.String)
      )(_.dbClusterInstanceClass)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(
        performanceInsightsEnabled.map(value => value: java.lang.Boolean)
      )(_.performanceInsightsEnabled)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        serverlessV2ScalingConfiguration.map(value => value.buildAwsValue())
      )(_.serverlessV2ScalingConfiguration)
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .optionallyWith(dbSystemId.map(value => value: java.lang.String))(
        _.dbSystemId
      )
      .optionallyWith(masterUserSecret.map(value => value.buildAwsValue()))(
        _.masterUserSecret
      )
      .optionallyWith(
        ioOptimizedNextAllowedModificationTime.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.ioOptimizedNextAllowedModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBCluster.ReadOnly =
    zio.aws.rds.model.DBCluster.wrap(buildAwsValue())
}
object DBCluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.DBCluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBCluster = zio.aws.rds.model.DBCluster(
      allocatedStorage.map(value => value),
      availabilityZones.map(value => value),
      backupRetentionPeriod.map(value => value),
      characterSetName.map(value => value),
      databaseName.map(value => value),
      dbClusterIdentifier.map(value => value),
      dbClusterParameterGroup.map(value => value),
      dbSubnetGroup.map(value => value),
      status.map(value => value),
      automaticRestartTime.map(value => value),
      percentProgress.map(value => value),
      earliestRestorableTime.map(value => value),
      endpoint.map(value => value),
      readerEndpoint.map(value => value),
      customEndpoints.map(value => value),
      multiAZ.map(value => value),
      engine.map(value => value),
      engineVersion.map(value => value),
      latestRestorableTime.map(value => value),
      port.map(value => value),
      masterUsername.map(value => value),
      dbClusterOptionGroupMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      preferredBackupWindow.map(value => value),
      preferredMaintenanceWindow.map(value => value),
      replicationSourceIdentifier.map(value => value),
      readReplicaIdentifiers.map(value => value),
      dbClusterMembers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcSecurityGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      hostedZoneId.map(value => value),
      storageEncrypted.map(value => value),
      kmsKeyId.map(value => value),
      dbClusterResourceId.map(value => value),
      dbClusterArn.map(value => value),
      associatedRoles.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      iamDatabaseAuthenticationEnabled.map(value => value),
      cloneGroupId.map(value => value),
      clusterCreateTime.map(value => value),
      earliestBacktrackTime.map(value => value),
      backtrackWindow.map(value => value),
      backtrackConsumedChangeRecords.map(value => value),
      enabledCloudwatchLogsExports.map(value => value),
      capacity.map(value => value),
      engineMode.map(value => value),
      scalingConfigurationInfo.map(value => value.asEditable),
      deletionProtection.map(value => value),
      httpEndpointEnabled.map(value => value),
      activityStreamMode.map(value => value),
      activityStreamStatus.map(value => value),
      activityStreamKmsKeyId.map(value => value),
      activityStreamKinesisStreamName.map(value => value),
      copyTagsToSnapshot.map(value => value),
      crossAccountClone.map(value => value),
      domainMemberships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tagList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      globalWriteForwardingStatus.map(value => value),
      globalWriteForwardingRequested.map(value => value),
      pendingModifiedValues.map(value => value.asEditable),
      dbClusterInstanceClass.map(value => value),
      storageType.map(value => value),
      iops.map(value => value),
      publiclyAccessible.map(value => value),
      autoMinorVersionUpgrade.map(value => value),
      monitoringInterval.map(value => value),
      monitoringRoleArn.map(value => value),
      performanceInsightsEnabled.map(value => value),
      performanceInsightsKMSKeyId.map(value => value),
      performanceInsightsRetentionPeriod.map(value => value),
      serverlessV2ScalingConfiguration.map(value => value.asEditable),
      networkType.map(value => value),
      dbSystemId.map(value => value),
      masterUserSecret.map(value => value.asEditable),
      ioOptimizedNextAllowedModificationTime.map(value => value)
    )
    def allocatedStorage: Optional[IntegerOptional]
    def availabilityZones: Optional[List[String]]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def characterSetName: Optional[String]
    def databaseName: Optional[String]
    def dbClusterIdentifier: Optional[String]
    def dbClusterParameterGroup: Optional[String]
    def dbSubnetGroup: Optional[String]
    def status: Optional[String]
    def automaticRestartTime: Optional[TStamp]
    def percentProgress: Optional[String]
    def earliestRestorableTime: Optional[TStamp]
    def endpoint: Optional[String]
    def readerEndpoint: Optional[String]
    def customEndpoints: Optional[List[String]]
    def multiAZ: Optional[BooleanOptional]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def latestRestorableTime: Optional[TStamp]
    def port: Optional[IntegerOptional]
    def masterUsername: Optional[String]
    def dbClusterOptionGroupMemberships
        : Optional[List[zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly]]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def replicationSourceIdentifier: Optional[String]
    def readReplicaIdentifiers: Optional[List[String]]
    def dbClusterMembers
        : Optional[List[zio.aws.rds.model.DBClusterMember.ReadOnly]]
    def vpcSecurityGroups
        : Optional[List[zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly]]
    def hostedZoneId: Optional[String]
    def storageEncrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def dbClusterResourceId: Optional[String]
    def dbClusterArn: Optional[String]
    def associatedRoles
        : Optional[List[zio.aws.rds.model.DBClusterRole.ReadOnly]]
    def iamDatabaseAuthenticationEnabled: Optional[BooleanOptional]
    def cloneGroupId: Optional[String]
    def clusterCreateTime: Optional[TStamp]
    def earliestBacktrackTime: Optional[TStamp]
    def backtrackWindow: Optional[LongOptional]
    def backtrackConsumedChangeRecords: Optional[LongOptional]
    def enabledCloudwatchLogsExports: Optional[List[String]]
    def capacity: Optional[IntegerOptional]
    def engineMode: Optional[String]
    def scalingConfigurationInfo
        : Optional[zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly]
    def deletionProtection: Optional[BooleanOptional]
    def httpEndpointEnabled: Optional[BooleanOptional]
    def activityStreamMode: Optional[zio.aws.rds.model.ActivityStreamMode]
    def activityStreamStatus: Optional[zio.aws.rds.model.ActivityStreamStatus]
    def activityStreamKmsKeyId: Optional[String]
    def activityStreamKinesisStreamName: Optional[String]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def crossAccountClone: Optional[BooleanOptional]
    def domainMemberships
        : Optional[List[zio.aws.rds.model.DomainMembership.ReadOnly]]
    def tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def globalWriteForwardingStatus
        : Optional[zio.aws.rds.model.WriteForwardingStatus]
    def globalWriteForwardingRequested: Optional[BooleanOptional]
    def pendingModifiedValues
        : Optional[zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly]
    def dbClusterInstanceClass: Optional[String]
    def storageType: Optional[String]
    def iops: Optional[IntegerOptional]
    def publiclyAccessible: Optional[BooleanOptional]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def monitoringInterval: Optional[IntegerOptional]
    def monitoringRoleArn: Optional[String]
    def performanceInsightsEnabled: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def performanceInsightsRetentionPeriod: Optional[IntegerOptional]
    def serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfigurationInfo.ReadOnly
    ]
    def networkType: Optional[String]
    def dbSystemId: Optional[String]
    def masterUserSecret: Optional[zio.aws.rds.model.MasterUserSecret.ReadOnly]
    def ioOptimizedNextAllowedModificationTime: Optional[TStamp]
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterParameterGroup: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterParameterGroup", dbClusterParameterGroup)
    def getDbSubnetGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getAutomaticRestartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("automaticRestartTime", automaticRestartTime)
    def getPercentProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getEarliestRestorableTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("earliestRestorableTime", earliestRestorableTime)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getReaderEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("readerEndpoint", readerEndpoint)
    def getCustomEndpoints: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("customEndpoints", customEndpoints)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbClusterOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterOptionGroupMemberships",
      dbClusterOptionGroupMemberships
    )
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReplicationSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSourceIdentifier",
        replicationSourceIdentifier
      )
    def getReadReplicaIdentifiers: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("readReplicaIdentifiers", readReplicaIdentifiers)
    def getDbClusterMembers
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBClusterMember.ReadOnly]] =
      AwsError.unwrapOptionField("dbClusterMembers", dbClusterMembers)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceId)
    def getDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterArn", dbClusterArn)
    def getAssociatedRoles
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBClusterRole.ReadOnly]] =
      AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getIamDatabaseAuthenticationEnabled
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "iamDatabaseAuthenticationEnabled",
      iamDatabaseAuthenticationEnabled
    )
    def getCloneGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloneGroupId", cloneGroupId)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getEarliestBacktrackTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("earliestBacktrackTime", earliestBacktrackTime)
    def getBacktrackWindow: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("backtrackWindow", backtrackWindow)
    def getBacktrackConsumedChangeRecords: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField(
        "backtrackConsumedChangeRecords",
        backtrackConsumedChangeRecords
      )
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
    def getCapacity: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getScalingConfigurationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scalingConfigurationInfo",
      scalingConfigurationInfo
    )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getHttpEndpointEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("httpEndpointEnabled", httpEndpointEnabled)
    def getActivityStreamMode
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamMode] =
      AwsError.unwrapOptionField("activityStreamMode", activityStreamMode)
    def getActivityStreamStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("activityStreamStatus", activityStreamStatus)
    def getActivityStreamKmsKeyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("activityStreamKmsKeyId", activityStreamKmsKeyId)
    def getActivityStreamKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "activityStreamKinesisStreamName",
        activityStreamKinesisStreamName
      )
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getCrossAccountClone: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("crossAccountClone", crossAccountClone)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getGlobalWriteForwardingStatus
        : ZIO[Any, AwsError, zio.aws.rds.model.WriteForwardingStatus] =
      AwsError.unwrapOptionField(
        "globalWriteForwardingStatus",
        globalWriteForwardingStatus
      )
    def getGlobalWriteForwardingRequested: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "globalWriteForwardingRequested",
        globalWriteForwardingRequested
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getDbClusterInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterInstanceClass", dbClusterInstanceClass)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getPerformanceInsightsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "performanceInsightsEnabled",
        performanceInsightsEnabled
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getServerlessV2ScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ServerlessV2ScalingConfigurationInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverlessV2ScalingConfiguration",
      serverlessV2ScalingConfiguration
    )
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getDbSystemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSystemId", dbSystemId)
    def getMasterUserSecret
        : ZIO[Any, AwsError, zio.aws.rds.model.MasterUserSecret.ReadOnly] =
      AwsError.unwrapOptionField("masterUserSecret", masterUserSecret)
    def getIoOptimizedNextAllowedModificationTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "ioOptimizedNextAllowedModificationTime",
        ioOptimizedNextAllowedModificationTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBCluster
  ) extends zio.aws.rds.model.DBCluster.ReadOnly {
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val characterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.characterSetName())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val dbClusterParameterGroup: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroup())
        .map(value => value: String)
    override val dbSubnetGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroup())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val automaticRestartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticRestartTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val percentProgress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.percentProgress())
      .map(value => value: String)
    override val earliestRestorableTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.earliestRestorableTime())
        .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val readerEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.readerEndpoint())
      .map(value => value: String)
    override val customEndpoints: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.customEndpoints())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val latestRestorableTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRestorableTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val dbClusterOptionGroupMemberships: Optional[
      List[zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterOptionGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.DBClusterOptionGroupStatus.wrap(item)
        }.toList
      )
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val replicationSourceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSourceIdentifier())
        .map(value => value: String)
    override val readReplicaIdentifiers: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbClusterMembers
        : Optional[List[zio.aws.rds.model.DBClusterMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterMembers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBClusterMember.wrap(item)
          }.toList
        )
    override val vpcSecurityGroups: Optional[
      List[zio.aws.rds.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val hostedZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => value: String)
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val dbClusterResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterResourceId())
      .map(value => value: String)
    override val dbClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterArn())
      .map(value => value: String)
    override val associatedRoles
        : Optional[List[zio.aws.rds.model.DBClusterRole.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedRoles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBClusterRole.wrap(item)
          }.toList
        )
    override val iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: BooleanOptional)
    override val cloneGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cloneGroupId())
      .map(value => value: String)
    override val clusterCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val earliestBacktrackTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.earliestBacktrackTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val backtrackWindow: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackWindow())
      .map(value => value: LongOptional)
    override val backtrackConsumedChangeRecords: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backtrackConsumedChangeRecords())
        .map(value => value: LongOptional)
    override val enabledCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val capacity: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => value: IntegerOptional)
    override val engineMode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineMode())
      .map(value => value: String)
    override val scalingConfigurationInfo
        : Optional[zio.aws.rds.model.ScalingConfigurationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfigurationInfo())
        .map(value => zio.aws.rds.model.ScalingConfigurationInfo.wrap(value))
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val httpEndpointEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpEndpointEnabled())
        .map(value => value: BooleanOptional)
    override val activityStreamMode
        : Optional[zio.aws.rds.model.ActivityStreamMode] = zio.aws.core.internal
      .optionalFromNullable(impl.activityStreamMode())
      .map(value => zio.aws.rds.model.ActivityStreamMode.wrap(value))
    override val activityStreamStatus
        : Optional[zio.aws.rds.model.ActivityStreamStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStreamStatus())
        .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
    override val activityStreamKmsKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStreamKmsKeyId())
        .map(value => value: String)
    override val activityStreamKinesisStreamName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityStreamKinesisStreamName())
        .map(value => value: String)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val crossAccountClone: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossAccountClone())
        .map(value => value: BooleanOptional)
    override val domainMemberships
        : Optional[List[zio.aws.rds.model.DomainMembership.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DomainMembership.wrap(item)
          }.toList
        )
    override val tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val globalWriteForwardingStatus
        : Optional[zio.aws.rds.model.WriteForwardingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalWriteForwardingStatus())
        .map(value => zio.aws.rds.model.WriteForwardingStatus.wrap(value))
    override val globalWriteForwardingRequested: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalWriteForwardingRequested())
        .map(value => value: BooleanOptional)
    override val pendingModifiedValues
        : Optional[zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingModifiedValues())
        .map(value =>
          zio.aws.rds.model.ClusterPendingModifiedValues.wrap(value)
        )
    override val dbClusterInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterInstanceClass())
        .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val monitoringInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringInterval())
        .map(value => value: IntegerOptional)
    override val monitoringRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringRoleArn())
      .map(value => value: String)
    override val performanceInsightsEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsEnabled())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
    override val performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val serverlessV2ScalingConfiguration: Optional[
      zio.aws.rds.model.ServerlessV2ScalingConfigurationInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessV2ScalingConfiguration())
      .map(value =>
        zio.aws.rds.model.ServerlessV2ScalingConfigurationInfo.wrap(value)
      )
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
    override val dbSystemId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSystemId())
      .map(value => value: String)
    override val masterUserSecret
        : Optional[zio.aws.rds.model.MasterUserSecret.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserSecret())
        .map(value => zio.aws.rds.model.MasterUserSecret.wrap(value))
    override val ioOptimizedNextAllowedModificationTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ioOptimizedNextAllowedModificationTime())
        .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBCluster
  ): zio.aws.rds.model.DBCluster.ReadOnly = new Wrapper(impl)
}
