package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDbInstanceRequest(
    dbName: Optional[String] = Optional.Absent,
    dbInstanceIdentifier: String,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    dbInstanceClass: String,
    engine: String,
    masterUsername: Optional[String] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    dbSecurityGroups: Optional[Iterable[String]] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    dbParameterGroupName: Optional[String] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    characterSetName: Optional[String] = Optional.Absent,
    ncharCharacterSetName: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    tdeCredentialArn: Optional[String] = Optional.Absent,
    tdeCredentialPassword: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[BooleanOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    domainFqdn: Optional[String] = Optional.Absent,
    domainOu: Optional[String] = Optional.Absent,
    domainAuthSecretArn: Optional[String] = Optional.Absent,
    domainDnsIps: Optional[Iterable[String]] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    monitoringInterval: Optional[IntegerOptional] = Optional.Absent,
    monitoringRoleArn: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    promotionTier: Optional[IntegerOptional] = Optional.Absent,
    timezone: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    enablePerformanceInsights: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent,
    performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    processorFeatures: Optional[Iterable[zio.aws.rds.model.ProcessorFeature]] =
      Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    maxAllocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    enableCustomerOwnedIp: Optional[BooleanOptional] = Optional.Absent,
    customIamInstanceProfile: Optional[String] = Optional.Absent,
    backupTarget: Optional[String] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent,
    storageThroughput: Optional[IntegerOptional] = Optional.Absent,
    manageMasterUserPassword: Optional[BooleanOptional] = Optional.Absent,
    masterUserSecretKmsKeyId: Optional[String] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest = {
    import CreateDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest
      .builder()
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .dbInstanceClass(dbInstanceClass: java.lang.String)
      .engine(engine: java.lang.String)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(
        ncharCharacterSetName.map(value => value: java.lang.String)
      )(_.ncharCharacterSetName)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(
        tdeCredentialPassword.map(value => value: java.lang.String)
      )(_.tdeCredentialPassword)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainFqdn.map(value => value: java.lang.String))(
        _.domainFqdn
      )
      .optionallyWith(domainOu.map(value => value: java.lang.String))(
        _.domainOu
      )
      .optionallyWith(
        domainAuthSecretArn.map(value => value: java.lang.String)
      )(_.domainAuthSecretArn)
      .optionallyWith(
        domainDnsIps.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.domainDnsIps)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(maxAllocatedStorage.map(value => value: Integer))(
        _.maxAllocatedStorage
      )
      .optionallyWith(
        enableCustomerOwnedIp.map(value => value: java.lang.Boolean)
      )(_.enableCustomerOwnedIp)
      .optionallyWith(
        customIamInstanceProfile.map(value => value: java.lang.String)
      )(_.customIamInstanceProfile)
      .optionallyWith(backupTarget.map(value => value: java.lang.String))(
        _.backupTarget
      )
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .optionallyWith(storageThroughput.map(value => value: Integer))(
        _.storageThroughput
      )
      .optionallyWith(
        manageMasterUserPassword.map(value => value: java.lang.Boolean)
      )(_.manageMasterUserPassword)
      .optionallyWith(
        masterUserSecretKmsKeyId.map(value => value: java.lang.String)
      )(_.masterUserSecretKmsKeyId)
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbInstanceRequest.ReadOnly =
    zio.aws.rds.model.CreateDbInstanceRequest.wrap(buildAwsValue())
}
object CreateDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbInstanceRequest =
      zio.aws.rds.model.CreateDbInstanceRequest(
        dbName.map(value => value),
        dbInstanceIdentifier,
        allocatedStorage.map(value => value),
        dbInstanceClass,
        engine,
        masterUsername.map(value => value),
        masterUserPassword.map(value => value),
        dbSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        availabilityZone.map(value => value),
        dbSubnetGroupName.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        dbParameterGroupName.map(value => value),
        backupRetentionPeriod.map(value => value),
        preferredBackupWindow.map(value => value),
        port.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        characterSetName.map(value => value),
        ncharCharacterSetName.map(value => value),
        publiclyAccessible.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterIdentifier.map(value => value),
        storageType.map(value => value),
        tdeCredentialArn.map(value => value),
        tdeCredentialPassword.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        domain.map(value => value),
        domainFqdn.map(value => value),
        domainOu.map(value => value),
        domainAuthSecretArn.map(value => value),
        domainDnsIps.map(value => value),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        domainIAMRoleName.map(value => value),
        promotionTier.map(value => value),
        timezone.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deletionProtection.map(value => value),
        maxAllocatedStorage.map(value => value),
        enableCustomerOwnedIp.map(value => value),
        customIamInstanceProfile.map(value => value),
        backupTarget.map(value => value),
        networkType.map(value => value),
        storageThroughput.map(value => value),
        manageMasterUserPassword.map(value => value),
        masterUserSecretKmsKeyId.map(value => value),
        caCertificateIdentifier.map(value => value)
      )
    def dbName: Optional[String]
    def dbInstanceIdentifier: String
    def allocatedStorage: Optional[IntegerOptional]
    def dbInstanceClass: String
    def engine: String
    def masterUsername: Optional[String]
    def masterUserPassword: Optional[String]
    def dbSecurityGroups: Optional[List[String]]
    def vpcSecurityGroupIds: Optional[List[String]]
    def availabilityZone: Optional[String]
    def dbSubnetGroupName: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def dbParameterGroupName: Optional[String]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def preferredBackupWindow: Optional[String]
    def port: Optional[IntegerOptional]
    def multiAZ: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def licenseModel: Optional[String]
    def iops: Optional[IntegerOptional]
    def optionGroupName: Optional[String]
    def characterSetName: Optional[String]
    def ncharCharacterSetName: Optional[String]
    def publiclyAccessible: Optional[BooleanOptional]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def dbClusterIdentifier: Optional[String]
    def storageType: Optional[String]
    def tdeCredentialArn: Optional[String]
    def tdeCredentialPassword: Optional[String]
    def storageEncrypted: Optional[BooleanOptional]
    def kmsKeyId: Optional[String]
    def domain: Optional[String]
    def domainFqdn: Optional[String]
    def domainOu: Optional[String]
    def domainAuthSecretArn: Optional[String]
    def domainDnsIps: Optional[List[String]]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def monitoringInterval: Optional[IntegerOptional]
    def monitoringRoleArn: Optional[String]
    def domainIAMRoleName: Optional[String]
    def promotionTier: Optional[IntegerOptional]
    def timezone: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def enablePerformanceInsights: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def performanceInsightsRetentionPeriod: Optional[IntegerOptional]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def deletionProtection: Optional[BooleanOptional]
    def maxAllocatedStorage: Optional[IntegerOptional]
    def enableCustomerOwnedIp: Optional[BooleanOptional]
    def customIamInstanceProfile: Optional[String]
    def backupTarget: Optional[String]
    def networkType: Optional[String]
    def storageThroughput: Optional[IntegerOptional]
    def manageMasterUserPassword: Optional[BooleanOptional]
    def masterUserSecretKmsKeyId: Optional[String]
    def caCertificateIdentifier: Optional[String]
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getDbInstanceClass: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceClass)
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getNcharCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ncharCharacterSetName", ncharCharacterSetName)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getTdeCredentialPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialPassword", tdeCredentialPassword)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainFqdn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainFqdn", domainFqdn)
    def getDomainOu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainOu", domainOu)
    def getDomainAuthSecretArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainAuthSecretArn", domainAuthSecretArn)
    def getDomainDnsIps: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("domainDnsIps", domainDnsIps)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getEnableCustomerOwnedIp: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableCustomerOwnedIp", enableCustomerOwnedIp)
    def getCustomIamInstanceProfile: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customIamInstanceProfile", customIamInstanceProfile)
    def getBackupTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupTarget", backupTarget)
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getStorageThroughput: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageThroughput", storageThroughput)
    def getManageMasterUserPassword: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "manageMasterUserPassword",
        manageMasterUserPassword
      )
    def getMasterUserSecretKmsKeyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("masterUserSecretKmsKeyId", masterUserSecretKmsKeyId)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest
  ) extends zio.aws.rds.model.CreateDbInstanceRequest.ReadOnly {
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val dbInstanceClass: String = impl.dbInstanceClass(): String
    override val engine: String = impl.engine(): String
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val dbSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val dbParameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupName())
      .map(value => value: String)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val characterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.characterSetName())
      .map(value => value: String)
    override val ncharCharacterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ncharCharacterSetName())
      .map(value => value: String)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val tdeCredentialArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialArn())
      .map(value => value: String)
    override val tdeCredentialPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialPassword())
      .map(value => value: String)
    override val storageEncrypted: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEncrypted())
        .map(value => value: BooleanOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val domainFqdn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainFqdn())
      .map(value => value: String)
    override val domainOu: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOu())
      .map(value => value: String)
    override val domainAuthSecretArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainAuthSecretArn())
      .map(value => value: String)
    override val domainDnsIps: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.domainDnsIps())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val monitoringInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringInterval())
        .map(value => value: IntegerOptional)
    override val monitoringRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringRoleArn())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val promotionTier: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promotionTier())
        .map(value => value: IntegerOptional)
    override val timezone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val enablePerformanceInsights: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
    override val performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val maxAllocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAllocatedStorage())
        .map(value => value: IntegerOptional)
    override val enableCustomerOwnedIp: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCustomerOwnedIp())
        .map(value => value: BooleanOptional)
    override val customIamInstanceProfile: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customIamInstanceProfile())
        .map(value => value: String)
    override val backupTarget: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupTarget())
      .map(value => value: String)
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
    override val storageThroughput: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageThroughput())
        .map(value => value: IntegerOptional)
    override val manageMasterUserPassword: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manageMasterUserPassword())
        .map(value => value: BooleanOptional)
    override val masterUserSecretKmsKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserSecretKmsKeyId())
        .map(value => value: String)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest
  ): zio.aws.rds.model.CreateDbInstanceRequest.ReadOnly = new Wrapper(impl)
}
