package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelExportTaskRequest(exportTaskIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CancelExportTaskRequest = {
    import CancelExportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CancelExportTaskRequest
      .builder()
      .exportTaskIdentifier(exportTaskIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CancelExportTaskRequest.ReadOnly =
    zio.aws.rds.model.CancelExportTaskRequest.wrap(buildAwsValue())
}
object CancelExportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CancelExportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CancelExportTaskRequest =
      zio.aws.rds.model.CancelExportTaskRequest(exportTaskIdentifier)
    def exportTaskIdentifier: String
    def getExportTaskIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(exportTaskIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CancelExportTaskRequest
  ) extends zio.aws.rds.model.CancelExportTaskRequest.ReadOnly {
    override val exportTaskIdentifier: String =
      impl.exportTaskIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CancelExportTaskRequest
  ): zio.aws.rds.model.CancelExportTaskRequest.ReadOnly = new Wrapper(impl)
}
