package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  BlueGreenDeploymentTaskStatus,
  BlueGreenDeploymentTaskName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BlueGreenDeploymentTask(
    name: Optional[BlueGreenDeploymentTaskName] = Optional.Absent,
    status: Optional[BlueGreenDeploymentTaskStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask = {
    import BlueGreenDeploymentTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask
      .builder()
      .optionallyWith(
        name.map(value =>
          BlueGreenDeploymentTaskName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        status.map(value =>
          BlueGreenDeploymentTaskStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.BlueGreenDeploymentTask.ReadOnly =
    zio.aws.rds.model.BlueGreenDeploymentTask.wrap(buildAwsValue())
}
object BlueGreenDeploymentTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.BlueGreenDeploymentTask =
      zio.aws.rds.model.BlueGreenDeploymentTask(
        name.map(value => value),
        status.map(value => value)
      )
    def name: Optional[BlueGreenDeploymentTaskName]
    def status: Optional[BlueGreenDeploymentTaskStatus]
    def getName: ZIO[Any, AwsError, BlueGreenDeploymentTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, BlueGreenDeploymentTaskStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask
  ) extends zio.aws.rds.model.BlueGreenDeploymentTask.ReadOnly {
    override val name: Optional[BlueGreenDeploymentTaskName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.rds.model.primitives.BlueGreenDeploymentTaskName(value)
        )
    override val status: Optional[BlueGreenDeploymentTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.rds.model.primitives.BlueGreenDeploymentTaskStatus(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask
  ): zio.aws.rds.model.BlueGreenDeploymentTask.ReadOnly = new Wrapper(impl)
}
