package zio.aws.rds
import zio.aws.rds.model.RestoreDbInstanceFromS3Response.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.rds.model.{
  DescribeEventCategoriesRequest,
  ResetDbParameterGroupRequest,
  DeleteDbInstanceResponse,
  ReservedDBInstancesOffering,
  OptionGroup,
  DescribeOptionGroupOptionsRequest,
  DBProxyEndpoint,
  RebootDbClusterResponse,
  DescribeDbLogFilesResponse,
  DescribeDbClusterSnapshotsRequest,
  DescribeExportTasksRequest,
  AuthorizeDbSecurityGroupIngressRequest,
  ModifyDbSnapshotResponse,
  DescribeDbParametersResponse,
  PromoteReadReplicaDbClusterRequest,
  StopDbClusterResponse,
  PromoteReadReplicaDbClusterResponse,
  DescribeDbParameterGroupsResponse,
  DescribeEventsResponse,
  DescribeEngineDefaultClusterParametersResponse,
  DBClusterBacktrack,
  CreateBlueGreenDeploymentRequest,
  DescribeDbSnapshotAttributesRequest,
  RegisterDbProxyTargetsRequest,
  EventSubscription,
  DescribeDbSnapshotAttributesResponse,
  StartExportTaskRequest,
  ModifyEventSubscriptionRequest,
  FailoverGlobalClusterResponse,
  CreateCustomDbEngineVersionRequest,
  ModifyCertificatesRequest,
  DBClusterParameterGroup,
  DescribeOptionGroupsRequest,
  PromoteReadReplicaRequest,
  AddRoleToDbClusterRequest,
  Certificate,
  ModifyDbProxyTargetGroupRequest,
  DeleteDbSubnetGroupRequest,
  BlueGreenDeployment,
  DescribeDbClusterEndpointsRequest,
  DeleteDbInstanceAutomatedBackupResponse,
  DescribeReservedDbInstancesResponse,
  DescribeDbClusterSnapshotsResponse,
  DescribeDbProxyTargetGroupsRequest,
  ModifyDbClusterSnapshotAttributeRequest,
  StartActivityStreamRequest,
  DeleteDbProxyRequest,
  CreateOptionGroupRequest,
  DescribeEngineDefaultParametersRequest,
  ModifyGlobalClusterRequest,
  DeleteDbParameterGroupResponse,
  RemoveFromGlobalClusterResponse,
  DescribeDbClustersResponse,
  StartDbInstanceAutomatedBackupsReplicationResponse,
  DBProxyTargetGroup,
  DescribeDbLogFilesRequest,
  DescribeDbProxyTargetsResponse,
  DBCluster,
  DescribeDbInstancesResponse,
  ModifyCertificatesResponse,
  CreateDbInstanceReadReplicaResponse,
  DescribeDbClusterEndpointsResponse,
  CreateDbSubnetGroupResponse,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  DBProxyTarget,
  CreateDbClusterEndpointRequest,
  CopyDbSnapshotResponse,
  DeleteDbClusterRequest,
  StartDbInstanceAutomatedBackupsReplicationRequest,
  DescribeValidDbInstanceModificationsRequest,
  DescribeDbProxyEndpointsResponse,
  DescribeEventCategoriesResponse,
  RemoveTagsFromResourceResponse,
  CreateDbParameterGroupResponse,
  RestoreDbClusterFromSnapshotRequest,
  StartDbInstanceResponse,
  DeleteGlobalClusterRequest,
  StopActivityStreamResponse,
  DeleteDbSnapshotResponse,
  ReservedDBInstance,
  RestoreDbInstanceToPointInTimeResponse,
  DescribeValidDbInstanceModificationsResponse,
  DBClusterSnapshot,
  DescribeDbClusterBacktracksRequest,
  DescribeEngineDefaultParametersResponse,
  DescribeDbClusterSnapshotAttributesResponse,
  ModifyDbClusterSnapshotAttributeResponse,
  OrderableDBInstanceOption,
  CopyDbClusterSnapshotRequest,
  ResetDbClusterParameterGroupResponse,
  CreateOptionGroupResponse,
  ModifyEventSubscriptionResponse,
  AddSourceIdentifierToSubscriptionResponse,
  DescribeDbClusterParametersResponse,
  CopyDbSnapshotRequest,
  ModifyDbProxyResponse,
  DBEngineVersion,
  DBParameterGroup,
  DeleteDbClusterSnapshotRequest,
  CreateDbClusterParameterGroupResponse,
  ModifyGlobalClusterResponse,
  RestoreDbInstanceFromS3Response,
  ModifyDbParameterGroupRequest,
  DescribeSourceRegionsResponse,
  DescribeDbInstanceAutomatedBackupsResponse,
  DescribeDbProxyTargetsRequest,
  DescribeDBLogFilesDetails,
  DescribeEventsRequest,
  FailoverGlobalClusterRequest,
  CreateDbParameterGroupRequest,
  StartDbInstanceRequest,
  DescribeOptionGroupsResponse,
  DownloadDbLogFilePortionResponse,
  StopDbInstanceAutomatedBackupsReplicationRequest,
  DescribePendingMaintenanceActionsResponse,
  DeleteCustomDbEngineVersionRequest,
  DescribeDbInstancesRequest,
  DeleteDbClusterSnapshotResponse,
  DeleteCustomDbEngineVersionResponse,
  GlobalCluster,
  ApplyPendingMaintenanceActionRequest,
  DescribeDbProxiesResponse,
  DescribeDbEngineVersionsRequest,
  ModifyCustomDbEngineVersionResponse,
  CopyDbClusterSnapshotResponse,
  RestoreDbClusterFromSnapshotResponse,
  ListTagsForResourceRequest,
  RemoveRoleFromDbInstanceResponse,
  DeleteEventSubscriptionRequest,
  DeleteBlueGreenDeploymentRequest,
  ModifyDbClusterParameterGroupRequest,
  CopyOptionGroupResponse,
  DescribeDbSecurityGroupsRequest,
  DescribeDbClusterSnapshotAttributesRequest,
  DescribeReservedDbInstancesOfferingsRequest,
  StartDbClusterRequest,
  RestoreDbClusterFromS3Response,
  RebootDbInstanceResponse,
  RestoreDbInstanceFromS3Request,
  ModifyDbSnapshotAttributeResponse,
  CancelExportTaskResponse,
  DescribeReservedDbInstancesOfferingsResponse,
  DescribeDbClustersRequest,
  CreateDbSnapshotResponse,
  ModifyDbClusterParameterGroupResponse,
  DeleteOptionGroupRequest,
  CreateGlobalClusterRequest,
  CreateDbProxyEndpointResponse,
  CreateDbSubnetGroupRequest,
  CreateDbInstanceResponse,
  FailoverDbClusterRequest,
  CreateDbClusterResponse,
  DeleteGlobalClusterResponse,
  ModifyDbProxyRequest,
  CreateDbProxyResponse,
  CreateDbClusterRequest,
  ModifyDbInstanceResponse,
  CreateDbClusterEndpointResponse,
  PromoteReadReplicaResponse,
  RebootDbClusterRequest,
  ApplyPendingMaintenanceActionResponse,
  ResourcePendingMaintenanceActions,
  ListTagsForResourceResponse,
  DescribeCertificatesResponse,
  CreateDbInstanceReadReplicaRequest,
  CreateDbProxyRequest,
  ModifyDbClusterRequest,
  DescribeDbProxyTargetGroupsResponse,
  CreateDbSecurityGroupRequest,
  StopDbInstanceAutomatedBackupsReplicationResponse,
  DescribeOptionGroupOptionsResponse,
  DescribeDbSnapshotsResponse,
  DeregisterDbProxyTargetsResponse,
  DeleteDbSnapshotRequest,
  DescribeBlueGreenDeploymentsRequest,
  DescribeEventSubscriptionsResponse,
  SwitchoverBlueGreenDeploymentRequest,
  PurchaseReservedDbInstancesOfferingResponse,
  DescribeOrderableDbInstanceOptionsResponse,
  SwitchoverReadReplicaResponse,
  CopyDbParameterGroupRequest,
  RemoveFromGlobalClusterRequest,
  DeleteDbSecurityGroupRequest,
  CreateBlueGreenDeploymentResponse,
  DescribeBlueGreenDeploymentsResponse,
  DeleteDbClusterParameterGroupResponse,
  CreateEventSubscriptionResponse,
  ModifyDbInstanceRequest,
  DescribeDbClusterParametersRequest,
  RemoveTagsFromResourceRequest,
  DescribeSourceRegionsRequest,
  RemoveRoleFromDbClusterResponse,
  RemoveRoleFromDbInstanceRequest,
  StopDbInstanceRequest,
  DescribeDbClusterBacktracksResponse,
  PurchaseReservedDbInstancesOfferingRequest,
  ModifyDbClusterEndpointRequest,
  ModifyDbProxyTargetGroupResponse,
  ModifyOptionGroupResponse,
  StartExportTaskResponse,
  DescribeCertificatesRequest,
  RemoveSourceIdentifierFromSubscriptionResponse,
  DescribePendingMaintenanceActionsRequest,
  ModifyDbSubnetGroupRequest,
  DescribeDbInstanceAutomatedBackupsRequest,
  RestoreDbInstanceFromDbSnapshotRequest,
  DescribeExportTasksResponse,
  FailoverDbClusterResponse,
  DescribeDbClusterParameterGroupsRequest,
  DeleteDbClusterResponse,
  DescribeDbClusterParameterGroupsResponse,
  CreateDbClusterSnapshotResponse,
  DeleteBlueGreenDeploymentResponse,
  ModifyDbSnapshotRequest,
  DeleteDbClusterEndpointRequest,
  ModifyActivityStreamResponse,
  DeleteDbClusterEndpointResponse,
  ModifyDbParameterGroupResponse,
  CopyDbClusterParameterGroupRequest,
  DBSnapshot,
  DescribeDbProxiesRequest,
  CreateGlobalClusterResponse,
  OptionGroupOption,
  StopDbClusterRequest,
  DeleteDbClusterParameterGroupRequest,
  CopyOptionGroupRequest,
  RestoreDbInstanceToPointInTimeRequest,
  DBClusterEndpoint,
  RemoveSourceIdentifierFromSubscriptionRequest,
  RestoreDbClusterToPointInTimeRequest,
  DeleteDbProxyEndpointRequest,
  DeleteDbInstanceRequest,
  DeleteDbProxyEndpointResponse,
  DescribeAccountAttributesRequest,
  AuthorizeDbSecurityGroupIngressResponse,
  DBSubnetGroup,
  DeleteDbProxyResponse,
  DeleteOptionGroupResponse,
  AddTagsToResourceResponse,
  ModifyDbClusterResponse,
  DescribeDbProxyEndpointsRequest,
  AddRoleToDbClusterResponse,
  DBSecurityGroup,
  ModifyActivityStreamRequest,
  CreateDbInstanceRequest,
  SwitchoverBlueGreenDeploymentResponse,
  CopyDbParameterGroupResponse,
  DescribeDbSubnetGroupsRequest,
  DescribeEngineDefaultClusterParametersRequest,
  CreateCustomDbEngineVersionResponse,
  CancelExportTaskRequest,
  ResetDbClusterParameterGroupRequest,
  DescribeReservedDbInstancesRequest,
  StartDbClusterResponse,
  ModifyCurrentDbClusterCapacityResponse,
  Event,
  ModifyCurrentDbClusterCapacityRequest,
  BacktrackDbClusterRequest,
  CopyDbClusterParameterGroupResponse,
  ModifyDbSubnetGroupResponse,
  ModifyCustomDbEngineVersionRequest,
  RegisterDbProxyTargetsResponse,
  RestoreDbClusterFromS3Request,
  RestoreDbClusterToPointInTimeResponse,
  DBProxy,
  RebootDbInstanceRequest,
  DeleteDbSecurityGroupResponse,
  ModifyDbSnapshotAttributeRequest,
  ModifyDbProxyEndpointResponse,
  DescribeOrderableDbInstanceOptionsRequest,
  CreateDbSnapshotRequest,
  DBInstanceAutomatedBackup,
  ModifyDbProxyEndpointRequest,
  BacktrackDbClusterResponse,
  DescribeDbSecurityGroupsResponse,
  StartActivityStreamResponse,
  ResetDbParameterGroupResponse,
  AddRoleToDbInstanceRequest,
  Parameter,
  RestoreDbInstanceFromDbSnapshotResponse,
  DeleteDbSubnetGroupResponse,
  DeleteEventSubscriptionResponse,
  DescribeGlobalClustersResponse,
  ExportTask,
  DescribeAccountAttributesResponse,
  DescribeGlobalClustersRequest,
  AddRoleToDbInstanceResponse,
  DescribeDbParameterGroupsRequest,
  DescribeEventSubscriptionsRequest,
  ModifyOptionGroupRequest,
  RevokeDbSecurityGroupIngressRequest,
  DeleteDbParameterGroupRequest,
  DownloadDbLogFilePortionRequest,
  DBInstance,
  CreateDbSecurityGroupResponse,
  AddSourceIdentifierToSubscriptionRequest,
  DescribeDbSnapshotsRequest,
  DeleteDbInstanceAutomatedBackupRequest,
  StopActivityStreamRequest,
  DescribeDbEngineVersionsResponse,
  DescribeDbSubnetGroupsResponse,
  SourceRegion,
  ModifyDbClusterEndpointResponse,
  DeregisterDbProxyTargetsRequest,
  RemoveRoleFromDbClusterRequest,
  CreateDbClusterParameterGroupRequest,
  SwitchoverReadReplicaRequest,
  RevokeDbSecurityGroupIngressResponse,
  CreateDbClusterSnapshotRequest,
  DescribeDbParametersRequest,
  StopDbInstanceResponse,
  CreateDbProxyEndpointRequest
}
import software.amazon.awssdk.services.rds.{
  RdsAsyncClientBuilder,
  RdsAsyncClient
}
import software.amazon.awssdk.services.rds.paginators.{
  DescribeDBParameterGroupsPublisher,
  DescribeOptionGroupOptionsPublisher,
  DescribeDBInstanceAutomatedBackupsPublisher,
  DescribeDBProxyTargetGroupsPublisher,
  DescribeCertificatesPublisher,
  DescribeDBClusterEndpointsPublisher,
  DescribePendingMaintenanceActionsPublisher,
  DescribeDBParametersPublisher,
  DescribeBlueGreenDeploymentsPublisher,
  DescribeOrderableDBInstanceOptionsPublisher,
  DescribeDBClusterSnapshotsPublisher,
  DescribeDBInstancesPublisher,
  DescribeDBClusterBacktracksPublisher,
  DescribeOptionGroupsPublisher,
  DescribeExportTasksPublisher,
  DescribeEventSubscriptionsPublisher,
  DescribeDBProxyEndpointsPublisher,
  DescribeDBLogFilesPublisher,
  DescribeSourceRegionsPublisher,
  DescribeDBProxiesPublisher,
  DescribeDBSecurityGroupsPublisher,
  DescribeDBProxyTargetsPublisher,
  DescribeDBClusterParametersPublisher,
  DescribeDBClustersPublisher,
  DescribeDBSnapshotsPublisher,
  DescribeReservedDBInstancesOfferingsPublisher,
  DescribeDBSubnetGroupsPublisher,
  DescribeDBEngineVersionsPublisher,
  DescribeGlobalClustersPublisher,
  DescribeReservedDBInstancesPublisher,
  DescribeEventsPublisher,
  DescribeDBClusterParameterGroupsPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Rds extends AspectSupport[Rds] {
  val api: RdsAsyncClient
  def downloadDBLogFilePortion(
      request: zio.aws.rds.model.DownloadDbLogFilePortionRequest
  ): IO[AwsError, zio.aws.rds.model.DownloadDbLogFilePortionResponse.ReadOnly]
  def copyDBClusterSnapshot(
      request: zio.aws.rds.model.CopyDbClusterSnapshotRequest
  ): IO[AwsError, zio.aws.rds.model.CopyDbClusterSnapshotResponse.ReadOnly]
  def describeEngineDefaultParameters(
      request: zio.aws.rds.model.DescribeEngineDefaultParametersRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeEngineDefaultParametersResponse.ReadOnly
  ]
  def modifyDBInstance(
      request: zio.aws.rds.model.ModifyDbInstanceRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbInstanceResponse.ReadOnly]
  def deleteDBProxy(
      request: zio.aws.rds.model.DeleteDbProxyRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteDbProxyResponse.ReadOnly]
  def describeDBClusterEndpoints(
      request: zio.aws.rds.model.DescribeDbClusterEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBClusterEndpoint.ReadOnly]
  def describeDBClusterEndpointsPaginated(
      request: zio.aws.rds.model.DescribeDbClusterEndpointsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbClusterEndpointsResponse.ReadOnly]
  def deleteBlueGreenDeployment(
      request: zio.aws.rds.model.DeleteBlueGreenDeploymentRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteBlueGreenDeploymentResponse.ReadOnly]
  def stopActivityStream(
      request: zio.aws.rds.model.StopActivityStreamRequest
  ): IO[AwsError, zio.aws.rds.model.StopActivityStreamResponse.ReadOnly]
  def failoverGlobalCluster(
      request: zio.aws.rds.model.FailoverGlobalClusterRequest
  ): IO[AwsError, zio.aws.rds.model.FailoverGlobalClusterResponse.ReadOnly]
  def describeDBLogFiles(
      request: zio.aws.rds.model.DescribeDbLogFilesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly
  ]
  def describeDBLogFilesPaginated(
      request: zio.aws.rds.model.DescribeDbLogFilesRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbLogFilesResponse.ReadOnly]
  def describeDBSnapshots(
      request: zio.aws.rds.model.DescribeDbSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBSnapshot.ReadOnly]
  def describeDBSnapshotsPaginated(
      request: zio.aws.rds.model.DescribeDbSnapshotsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbSnapshotsResponse.ReadOnly]
  def describeDBParameters(
      request: zio.aws.rds.model.DescribeDbParametersRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.Parameter.ReadOnly]
  def describeDBParametersPaginated(
      request: zio.aws.rds.model.DescribeDbParametersRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly]
  def addTagsToResource(
      request: zio.aws.rds.model.AddTagsToResourceRequest
  ): IO[AwsError, Unit]
  def describeDBProxies(
      request: zio.aws.rds.model.DescribeDbProxiesRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxy.ReadOnly]
  def describeDBProxiesPaginated(
      request: zio.aws.rds.model.DescribeDbProxiesRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly]
  def describeDBClusterSnapshots(
      request: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBClusterSnapshot.ReadOnly]
  def describeDBClusterSnapshotsPaginated(
      request: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.ReadOnly]
  def resetDBClusterParameterGroup(
      request: zio.aws.rds.model.ResetDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.ResetDbClusterParameterGroupResponse.ReadOnly
  ]
  def describeDBProxyEndpoints(
      request: zio.aws.rds.model.DescribeDbProxyEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxyEndpoint.ReadOnly]
  def describeDBProxyEndpointsPaginated(
      request: zio.aws.rds.model.DescribeDbProxyEndpointsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly]
  def removeSourceIdentifierFromSubscription(
      request: zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
  ]
  def describeEngineDefaultClusterParameters(
      request: zio.aws.rds.model.DescribeEngineDefaultClusterParametersRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
  ]
  def createDBSubnetGroup(
      request: zio.aws.rds.model.CreateDbSubnetGroupRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly]
  def createDBClusterEndpoint(
      request: zio.aws.rds.model.CreateDbClusterEndpointRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbClusterEndpointResponse.ReadOnly]
  def addRoleToDBCluster(
      request: zio.aws.rds.model.AddRoleToDbClusterRequest
  ): IO[AwsError, Unit]
  def modifyCustomDBEngineVersion(
      request: zio.aws.rds.model.ModifyCustomDbEngineVersionRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.ModifyCustomDbEngineVersionResponse.ReadOnly
  ]
  def copyDBClusterParameterGroup(
      request: zio.aws.rds.model.CopyDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.CopyDbClusterParameterGroupResponse.ReadOnly
  ]
  def describePendingMaintenanceActions(
      request: zio.aws.rds.model.DescribePendingMaintenanceActionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
  ]
  def describePendingMaintenanceActionsPaginated(
      request: zio.aws.rds.model.DescribePendingMaintenanceActionsRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ]
  def deleteDBClusterEndpoint(
      request: zio.aws.rds.model.DeleteDbClusterEndpointRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteDbClusterEndpointResponse.ReadOnly]
  def addRoleToDBInstance(
      request: zio.aws.rds.model.AddRoleToDbInstanceRequest
  ): IO[AwsError, Unit]
  def startActivityStream(
      request: zio.aws.rds.model.StartActivityStreamRequest
  ): IO[AwsError, zio.aws.rds.model.StartActivityStreamResponse.ReadOnly]
  def deleteDBClusterParameterGroup(
      request: zio.aws.rds.model.DeleteDbClusterParameterGroupRequest
  ): IO[AwsError, Unit]
  def createDBSecurityGroup(
      request: zio.aws.rds.model.CreateDbSecurityGroupRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbSecurityGroupResponse.ReadOnly]
  def describeSourceRegions(
      request: zio.aws.rds.model.DescribeSourceRegionsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.SourceRegion.ReadOnly]
  def describeSourceRegionsPaginated(
      request: zio.aws.rds.model.DescribeSourceRegionsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeSourceRegionsResponse.ReadOnly]
  def backtrackDBCluster(
      request: zio.aws.rds.model.BacktrackDbClusterRequest
  ): IO[AwsError, zio.aws.rds.model.BacktrackDbClusterResponse.ReadOnly]
  def removeFromGlobalCluster(
      request: zio.aws.rds.model.RemoveFromGlobalClusterRequest
  ): IO[AwsError, zio.aws.rds.model.RemoveFromGlobalClusterResponse.ReadOnly]
  def modifyDBClusterParameterGroup(
      request: zio.aws.rds.model.ModifyDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.ReadOnly
  ]
  def rebootDBCluster(
      request: zio.aws.rds.model.RebootDbClusterRequest
  ): IO[AwsError, zio.aws.rds.model.RebootDbClusterResponse.ReadOnly]
  def cancelExportTask(
      request: zio.aws.rds.model.CancelExportTaskRequest
  ): IO[AwsError, zio.aws.rds.model.CancelExportTaskResponse.ReadOnly]
  def createDBSnapshot(
      request: zio.aws.rds.model.CreateDbSnapshotRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbSnapshotResponse.ReadOnly]
  def deleteDBInstanceAutomatedBackup(
      request: zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.ReadOnly
  ]
  def deleteDBSnapshot(
      request: zio.aws.rds.model.DeleteDbSnapshotRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteDbSnapshotResponse.ReadOnly]
  def stopDBCluster(
      request: zio.aws.rds.model.StopDbClusterRequest
  ): IO[AwsError, zio.aws.rds.model.StopDbClusterResponse.ReadOnly]
  def createDBCluster(
      request: zio.aws.rds.model.CreateDbClusterRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbClusterResponse.ReadOnly]
  def describeCertificates(
      request: zio.aws.rds.model.DescribeCertificatesRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.Certificate.ReadOnly]
  def describeCertificatesPaginated(
      request: zio.aws.rds.model.DescribeCertificatesRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly]
  def modifyDBSnapshot(
      request: zio.aws.rds.model.ModifyDbSnapshotRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbSnapshotResponse.ReadOnly]
  def deleteEventSubscription(
      request: zio.aws.rds.model.DeleteEventSubscriptionRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteEventSubscriptionResponse.ReadOnly]
  def deleteDBSecurityGroup(
      request: zio.aws.rds.model.DeleteDbSecurityGroupRequest
  ): IO[AwsError, Unit]
  def deleteDBParameterGroup(
      request: zio.aws.rds.model.DeleteDbParameterGroupRequest
  ): IO[AwsError, Unit]
  def describeDBSecurityGroups(
      request: zio.aws.rds.model.DescribeDbSecurityGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBSecurityGroup.ReadOnly]
  def describeDBSecurityGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbSecurityGroupsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbSecurityGroupsResponse.ReadOnly]
  def purchaseReservedDBInstancesOffering(
      request: zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.ReadOnly
  ]
  def describeDBSubnetGroups(
      request: zio.aws.rds.model.DescribeDbSubnetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBSubnetGroup.ReadOnly]
  def describeDBSubnetGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbSubnetGroupsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbSubnetGroupsResponse.ReadOnly]
  def removeRoleFromDBCluster(
      request: zio.aws.rds.model.RemoveRoleFromDbClusterRequest
  ): IO[AwsError, Unit]
  def createDBClusterParameterGroup(
      request: zio.aws.rds.model.CreateDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.CreateDbClusterParameterGroupResponse.ReadOnly
  ]
  def modifyDBCluster(
      request: zio.aws.rds.model.ModifyDbClusterRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbClusterResponse.ReadOnly]
  def restoreDBClusterFromS3(
      request: zio.aws.rds.model.RestoreDbClusterFromS3Request
  ): IO[AwsError, zio.aws.rds.model.RestoreDbClusterFromS3Response.ReadOnly]
  def describeValidDBInstanceModifications(
      request: zio.aws.rds.model.DescribeValidDbInstanceModificationsRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.ReadOnly
  ]
  def createDBProxyEndpoint(
      request: zio.aws.rds.model.CreateDbProxyEndpointRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbProxyEndpointResponse.ReadOnly]
  def resetDBParameterGroup(
      request: zio.aws.rds.model.ResetDbParameterGroupRequest
  ): IO[AwsError, zio.aws.rds.model.ResetDbParameterGroupResponse.ReadOnly]
  def createBlueGreenDeployment(
      request: zio.aws.rds.model.CreateBlueGreenDeploymentRequest
  ): IO[AwsError, zio.aws.rds.model.CreateBlueGreenDeploymentResponse.ReadOnly]
  def deleteDBProxyEndpoint(
      request: zio.aws.rds.model.DeleteDbProxyEndpointRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteDbProxyEndpointResponse.ReadOnly]
  def removeTagsFromResource(
      request: zio.aws.rds.model.RemoveTagsFromResourceRequest
  ): IO[AwsError, Unit]
  def promoteReadReplica(
      request: zio.aws.rds.model.PromoteReadReplicaRequest
  ): IO[AwsError, zio.aws.rds.model.PromoteReadReplicaResponse.ReadOnly]
  def describeBlueGreenDeployments(
      request: zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.BlueGreenDeployment.ReadOnly]
  def describeBlueGreenDeploymentsPaginated(
      request: zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse.ReadOnly
  ]
  def describeReservedDBInstancesOfferings(
      request: zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
  ]
  def describeReservedDBInstancesOfferingsPaginated(
      request: zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly
  ]
  def createDBParameterGroup(
      request: zio.aws.rds.model.CreateDbParameterGroupRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbParameterGroupResponse.ReadOnly]
  def startExportTask(
      request: zio.aws.rds.model.StartExportTaskRequest
  ): IO[AwsError, zio.aws.rds.model.StartExportTaskResponse.ReadOnly]
  def applyPendingMaintenanceAction(
      request: zio.aws.rds.model.ApplyPendingMaintenanceActionRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ]
  def modifyDBSubnetGroup(
      request: zio.aws.rds.model.ModifyDbSubnetGroupRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbSubnetGroupResponse.ReadOnly]
  def modifyGlobalCluster(
      request: zio.aws.rds.model.ModifyGlobalClusterRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyGlobalClusterResponse.ReadOnly]
  def copyDBSnapshot(
      request: zio.aws.rds.model.CopyDbSnapshotRequest
  ): IO[AwsError, zio.aws.rds.model.CopyDbSnapshotResponse.ReadOnly]
  def modifyActivityStream(
      request: zio.aws.rds.model.ModifyActivityStreamRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyActivityStreamResponse.ReadOnly]
  def restoreDBClusterFromSnapshot(
      request: zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
  ]
  def copyOptionGroup(
      request: zio.aws.rds.model.CopyOptionGroupRequest
  ): IO[AwsError, zio.aws.rds.model.CopyOptionGroupResponse.ReadOnly]
  def restoreDBInstanceFromS3(
      request: zio.aws.rds.model.RestoreDbInstanceFromS3Request
  ): IO[AwsError, ReadOnly]
  def removeRoleFromDBInstance(
      request: zio.aws.rds.model.RemoveRoleFromDbInstanceRequest
  ): IO[AwsError, Unit]
  def describeGlobalClusters(
      request: zio.aws.rds.model.DescribeGlobalClustersRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.GlobalCluster.ReadOnly]
  def describeGlobalClustersPaginated(
      request: zio.aws.rds.model.DescribeGlobalClustersRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly]
  def describeDBProxyTargetGroups(
      request: zio.aws.rds.model.DescribeDbProxyTargetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxyTargetGroup.ReadOnly]
  def describeDBProxyTargetGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbProxyTargetGroupsRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.ReadOnly
  ]
  def describeDBInstanceAutomatedBackups(
      request: zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly
  ]
  def describeDBInstanceAutomatedBackupsPaginated(
      request: zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.ReadOnly
  ]
  def describeDBClusterParameters(
      request: zio.aws.rds.model.DescribeDbClusterParametersRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.Parameter.ReadOnly]
  def describeDBClusterParametersPaginated(
      request: zio.aws.rds.model.DescribeDbClusterParametersRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeDbClusterParametersResponse.ReadOnly
  ]
  def copyDBParameterGroup(
      request: zio.aws.rds.model.CopyDbParameterGroupRequest
  ): IO[AwsError, zio.aws.rds.model.CopyDbParameterGroupResponse.ReadOnly]
  def modifyDBSnapshotAttribute(
      request: zio.aws.rds.model.ModifyDbSnapshotAttributeRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.ReadOnly]
  def authorizeDBSecurityGroupIngress(
      request: zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.AuthorizeDbSecurityGroupIngressResponse.ReadOnly
  ]
  def modifyEventSubscription(
      request: zio.aws.rds.model.ModifyEventSubscriptionRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyEventSubscriptionResponse.ReadOnly]
  def describeDBClusterBacktracks(
      request: zio.aws.rds.model.DescribeDbClusterBacktracksRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBClusterBacktrack.ReadOnly]
  def describeDBClusterBacktracksPaginated(
      request: zio.aws.rds.model.DescribeDbClusterBacktracksRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeDbClusterBacktracksResponse.ReadOnly
  ]
  def modifyDBParameterGroup(
      request: zio.aws.rds.model.ModifyDbParameterGroupRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbParameterGroupResponse.ReadOnly]
  def modifyCertificates(
      request: zio.aws.rds.model.ModifyCertificatesRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyCertificatesResponse.ReadOnly]
  def createDBInstance(
      request: zio.aws.rds.model.CreateDbInstanceRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbInstanceResponse.ReadOnly]
  def deleteDBClusterSnapshot(
      request: zio.aws.rds.model.DeleteDbClusterSnapshotRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteDbClusterSnapshotResponse.ReadOnly]
  def describeExportTasks(
      request: zio.aws.rds.model.DescribeExportTasksRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.ExportTask.ReadOnly]
  def describeExportTasksPaginated(
      request: zio.aws.rds.model.DescribeExportTasksRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeExportTasksResponse.ReadOnly]
  def startDBCluster(
      request: zio.aws.rds.model.StartDbClusterRequest
  ): IO[AwsError, zio.aws.rds.model.StartDbClusterResponse.ReadOnly]
  def modifyDBClusterSnapshotAttribute(
      request: zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
  ]
  def createDBProxy(
      request: zio.aws.rds.model.CreateDbProxyRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbProxyResponse.ReadOnly]
  def describeDBSnapshotAttributes(
      request: zio.aws.rds.model.DescribeDbSnapshotAttributesRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.ReadOnly
  ]
  def describeEventCategories(
      request: zio.aws.rds.model.DescribeEventCategoriesRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeEventCategoriesResponse.ReadOnly]
  def deleteDBSubnetGroup(
      request: zio.aws.rds.model.DeleteDbSubnetGroupRequest
  ): IO[AwsError, Unit]
  def modifyDBClusterEndpoint(
      request: zio.aws.rds.model.ModifyDbClusterEndpointRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbClusterEndpointResponse.ReadOnly]
  def startDBInstance(
      request: zio.aws.rds.model.StartDbInstanceRequest
  ): IO[AwsError, zio.aws.rds.model.StartDbInstanceResponse.ReadOnly]
  def promoteReadReplicaDBCluster(
      request: zio.aws.rds.model.PromoteReadReplicaDbClusterRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.ReadOnly
  ]
  def switchoverBlueGreenDeployment(
      request: zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.SwitchoverBlueGreenDeploymentResponse.ReadOnly
  ]
  def registerDBProxyTargets(
      request: zio.aws.rds.model.RegisterDbProxyTargetsRequest
  ): IO[AwsError, zio.aws.rds.model.RegisterDbProxyTargetsResponse.ReadOnly]
  def stopDBInstance(
      request: zio.aws.rds.model.StopDbInstanceRequest
  ): IO[AwsError, zio.aws.rds.model.StopDbInstanceResponse.ReadOnly]
  def modifyDBProxyTargetGroup(
      request: zio.aws.rds.model.ModifyDbProxyTargetGroupRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbProxyTargetGroupResponse.ReadOnly]
  def restoreDBInstanceFromDBSnapshot(
      request: zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.ReadOnly
  ]
  def rebootDBInstance(
      request: zio.aws.rds.model.RebootDbInstanceRequest
  ): IO[AwsError, zio.aws.rds.model.RebootDbInstanceResponse.ReadOnly]
  def describeOptionGroupOptions(
      request: zio.aws.rds.model.DescribeOptionGroupOptionsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.OptionGroupOption.ReadOnly]
  def describeOptionGroupOptionsPaginated(
      request: zio.aws.rds.model.DescribeOptionGroupOptionsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly]
  def startDBInstanceAutomatedBackupsReplication(
      request: zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
  ]
  def describeDBClusterParameterGroups(
      request: zio.aws.rds.model.DescribeDbClusterParameterGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBClusterParameterGroup.ReadOnly]
  def describeDBClusterParameterGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbClusterParameterGroupsRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
  ]
  def restoreDBInstanceToPointInTime(
      request: zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.ReadOnly
  ]
  def createEventSubscription(
      request: zio.aws.rds.model.CreateEventSubscriptionRequest
  ): IO[AwsError, zio.aws.rds.model.CreateEventSubscriptionResponse.ReadOnly]
  def createCustomDBEngineVersion(
      request: zio.aws.rds.model.CreateCustomDbEngineVersionRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.CreateCustomDbEngineVersionResponse.ReadOnly
  ]
  def describeOptionGroups(
      request: zio.aws.rds.model.DescribeOptionGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.OptionGroup.ReadOnly]
  def describeOptionGroupsPaginated(
      request: zio.aws.rds.model.DescribeOptionGroupsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.rds.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.rds.model.ListTagsForResourceResponse.ReadOnly]
  def restoreDBClusterToPointInTime(
      request: zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
  ]
  def describeDBProxyTargets(
      request: zio.aws.rds.model.DescribeDbProxyTargetsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxyTarget.ReadOnly]
  def describeDBProxyTargetsPaginated(
      request: zio.aws.rds.model.DescribeDbProxyTargetsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbProxyTargetsResponse.ReadOnly]
  def describeDBClusters(
      request: zio.aws.rds.model.DescribeDbClustersRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly]
  def describeDBClustersPaginated(
      request: zio.aws.rds.model.DescribeDbClustersRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbClustersResponse.ReadOnly]
  def failoverDBCluster(
      request: zio.aws.rds.model.FailoverDbClusterRequest
  ): IO[AwsError, zio.aws.rds.model.FailoverDbClusterResponse.ReadOnly]
  def deleteOptionGroup(
      request: zio.aws.rds.model.DeleteOptionGroupRequest
  ): IO[AwsError, Unit]
  def describeEventSubscriptions(
      request: zio.aws.rds.model.DescribeEventSubscriptionsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.EventSubscription.ReadOnly]
  def describeEventSubscriptionsPaginated(
      request: zio.aws.rds.model.DescribeEventSubscriptionsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeEventSubscriptionsResponse.ReadOnly]
  def describeDBInstances(
      request: zio.aws.rds.model.DescribeDbInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly]
  def describeDBInstancesPaginated(
      request: zio.aws.rds.model.DescribeDbInstancesRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbInstancesResponse.ReadOnly]
  def createDBClusterSnapshot(
      request: zio.aws.rds.model.CreateDbClusterSnapshotRequest
  ): IO[AwsError, zio.aws.rds.model.CreateDbClusterSnapshotResponse.ReadOnly]
  def modifyCurrentDBClusterCapacity(
      request: zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly
  ]
  def switchoverReadReplica(
      request: zio.aws.rds.model.SwitchoverReadReplicaRequest
  ): IO[AwsError, zio.aws.rds.model.SwitchoverReadReplicaResponse.ReadOnly]
  def deleteDBCluster(
      request: zio.aws.rds.model.DeleteDbClusterRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteDbClusterResponse.ReadOnly]
  def deleteGlobalCluster(
      request: zio.aws.rds.model.DeleteGlobalClusterRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteGlobalClusterResponse.ReadOnly]
  def describeReservedDBInstances(
      request: zio.aws.rds.model.DescribeReservedDbInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.ReservedDBInstance.ReadOnly]
  def describeReservedDBInstancesPaginated(
      request: zio.aws.rds.model.DescribeReservedDbInstancesRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly
  ]
  def createDBInstanceReadReplica(
      request: zio.aws.rds.model.CreateDbInstanceReadReplicaRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.CreateDbInstanceReadReplicaResponse.ReadOnly
  ]
  def deleteDBInstance(
      request: zio.aws.rds.model.DeleteDbInstanceRequest
  ): IO[AwsError, zio.aws.rds.model.DeleteDbInstanceResponse.ReadOnly]
  def createOptionGroup(
      request: zio.aws.rds.model.CreateOptionGroupRequest
  ): IO[AwsError, zio.aws.rds.model.CreateOptionGroupResponse.ReadOnly]
  def deregisterDBProxyTargets(
      request: zio.aws.rds.model.DeregisterDbProxyTargetsRequest
  ): IO[AwsError, zio.aws.rds.model.DeregisterDbProxyTargetsResponse.ReadOnly]
  def modifyDBProxyEndpoint(
      request: zio.aws.rds.model.ModifyDbProxyEndpointRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbProxyEndpointResponse.ReadOnly]
  def addSourceIdentifierToSubscription(
      request: zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
  ]
  def modifyDBProxy(
      request: zio.aws.rds.model.ModifyDbProxyRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyDbProxyResponse.ReadOnly]
  def modifyOptionGroup(
      request: zio.aws.rds.model.ModifyOptionGroupRequest
  ): IO[AwsError, zio.aws.rds.model.ModifyOptionGroupResponse.ReadOnly]
  def describeDBEngineVersions(
      request: zio.aws.rds.model.DescribeDbEngineVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBEngineVersion.ReadOnly]
  def describeDBEngineVersionsPaginated(
      request: zio.aws.rds.model.DescribeDbEngineVersionsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbEngineVersionsResponse.ReadOnly]
  def describeAccountAttributes(
      request: zio.aws.rds.model.DescribeAccountAttributesRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeAccountAttributesResponse.ReadOnly]
  def createGlobalCluster(
      request: zio.aws.rds.model.CreateGlobalClusterRequest
  ): IO[AwsError, zio.aws.rds.model.CreateGlobalClusterResponse.ReadOnly]
  def describeOrderableDBInstanceOptions(
      request: zio.aws.rds.model.DescribeOrderableDbInstanceOptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly
  ]
  def describeOrderableDBInstanceOptionsPaginated(
      request: zio.aws.rds.model.DescribeOrderableDbInstanceOptionsRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
  ]
  def revokeDBSecurityGroupIngress(
      request: zio.aws.rds.model.RevokeDbSecurityGroupIngressRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.ReadOnly
  ]
  def describeDBClusterSnapshotAttributes(
      request: zio.aws.rds.model.DescribeDbClusterSnapshotAttributesRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
  ]
  def stopDBInstanceAutomatedBackupsReplication(
      request: zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
  ]
  def describeEvents(
      request: zio.aws.rds.model.DescribeEventsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.Event.ReadOnly]
  def describeEventsPaginated(
      request: zio.aws.rds.model.DescribeEventsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeEventsResponse.ReadOnly]
  def deleteCustomDBEngineVersion(
      request: zio.aws.rds.model.DeleteCustomDbEngineVersionRequest
  ): IO[
    AwsError,
    zio.aws.rds.model.DeleteCustomDbEngineVersionResponse.ReadOnly
  ]
  def describeDBParameterGroups(
      request: zio.aws.rds.model.DescribeDbParameterGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.rds.model.DBParameterGroup.ReadOnly]
  def describeDBParameterGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbParameterGroupsRequest
  ): IO[AwsError, zio.aws.rds.model.DescribeDbParameterGroupsResponse.ReadOnly]
}
object Rds {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Rds] = customized(identity)
  def customized(
      customization: RdsAsyncClientBuilder => RdsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Rds] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: RdsAsyncClientBuilder => RdsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Rds] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = RdsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[RdsAsyncClient, RdsAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[RdsAsyncClient, RdsAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new RdsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class RdsImpl[R](
      override val api: RdsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Rds
      with AwsServiceBase[R] {
    override val serviceName: String = "Rds"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RdsImpl[R1] = new RdsImpl(api, newAspect, r)
    def downloadDBLogFilePortion(
        request: zio.aws.rds.model.DownloadDbLogFilePortionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DownloadDbLogFilePortionResponse.ReadOnly
    ] = asyncRequestResponse[
      DownloadDbLogFilePortionRequest,
      DownloadDbLogFilePortionResponse
    ]("downloadDBLogFilePortion", api.downloadDBLogFilePortion)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DownloadDbLogFilePortionResponse.wrap)
      .provideEnvironment(r)
    def copyDBClusterSnapshot(
        request: zio.aws.rds.model.CopyDbClusterSnapshotRequest
    ): IO[AwsError, zio.aws.rds.model.CopyDbClusterSnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        CopyDbClusterSnapshotRequest,
        CopyDbClusterSnapshotResponse
      ]("copyDBClusterSnapshot", api.copyDBClusterSnapshot)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.CopyDbClusterSnapshotResponse.wrap)
        .provideEnvironment(r)
    def describeEngineDefaultParameters(
        request: zio.aws.rds.model.DescribeEngineDefaultParametersRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeEngineDefaultParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEngineDefaultParametersRequest,
      DescribeEngineDefaultParametersResponse
    ]("describeEngineDefaultParameters", api.describeEngineDefaultParameters)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeEngineDefaultParametersResponse.wrap)
      .provideEnvironment(r)
    def modifyDBInstance(
        request: zio.aws.rds.model.ModifyDbInstanceRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[ModifyDbInstanceRequest, ModifyDbInstanceResponse](
        "modifyDBInstance",
        api.modifyDBInstance
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.ModifyDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def deleteDBProxy(
        request: zio.aws.rds.model.DeleteDbProxyRequest
    ): IO[AwsError, zio.aws.rds.model.DeleteDbProxyResponse.ReadOnly] =
      asyncRequestResponse[DeleteDbProxyRequest, DeleteDbProxyResponse](
        "deleteDBProxy",
        api.deleteDBProxy
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.DeleteDbProxyResponse.wrap)
        .provideEnvironment(r)
    def describeDBClusterEndpoints(
        request: zio.aws.rds.model.DescribeDbClusterEndpointsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBClusterEndpoint.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbClusterEndpointsRequest,
        DBClusterEndpoint,
        DescribeDBClusterEndpointsPublisher
      ](
        "describeDBClusterEndpoints",
        api.describeDBClusterEndpointsPaginator,
        _.dbClusterEndpoints()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBClusterEndpoint.wrap(item))
        .provideEnvironment(r)
    def describeDBClusterEndpointsPaginated(
        request: zio.aws.rds.model.DescribeDbClusterEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbClusterEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbClusterEndpointsRequest,
      DescribeDbClusterEndpointsResponse
    ]("describeDBClusterEndpoints", api.describeDBClusterEndpoints)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbClusterEndpointsResponse.wrap)
      .provideEnvironment(r)
    def deleteBlueGreenDeployment(
        request: zio.aws.rds.model.DeleteBlueGreenDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DeleteBlueGreenDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteBlueGreenDeploymentRequest,
      DeleteBlueGreenDeploymentResponse
    ]("deleteBlueGreenDeployment", api.deleteBlueGreenDeployment)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DeleteBlueGreenDeploymentResponse.wrap)
      .provideEnvironment(r)
    def stopActivityStream(
        request: zio.aws.rds.model.StopActivityStreamRequest
    ): IO[AwsError, zio.aws.rds.model.StopActivityStreamResponse.ReadOnly] =
      asyncRequestResponse[
        StopActivityStreamRequest,
        StopActivityStreamResponse
      ]("stopActivityStream", api.stopActivityStream)(request.buildAwsValue())
        .map(zio.aws.rds.model.StopActivityStreamResponse.wrap)
        .provideEnvironment(r)
    def failoverGlobalCluster(
        request: zio.aws.rds.model.FailoverGlobalClusterRequest
    ): IO[AwsError, zio.aws.rds.model.FailoverGlobalClusterResponse.ReadOnly] =
      asyncRequestResponse[
        FailoverGlobalClusterRequest,
        FailoverGlobalClusterResponse
      ]("failoverGlobalCluster", api.failoverGlobalCluster)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.FailoverGlobalClusterResponse.wrap)
        .provideEnvironment(r)
    def describeDBLogFiles(
        request: zio.aws.rds.model.DescribeDbLogFilesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeDbLogFilesRequest,
      DescribeDBLogFilesDetails,
      DescribeDBLogFilesPublisher
    ](
      "describeDBLogFiles",
      api.describeDBLogFilesPaginator,
      _.describeDBLogFiles()
    )(request.buildAwsValue())
      .map(item => zio.aws.rds.model.DescribeDBLogFilesDetails.wrap(item))
      .provideEnvironment(r)
    def describeDBLogFilesPaginated(
        request: zio.aws.rds.model.DescribeDbLogFilesRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeDbLogFilesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDbLogFilesRequest,
        DescribeDbLogFilesResponse
      ]("describeDBLogFiles", api.describeDBLogFiles)(request.buildAwsValue())
        .map(zio.aws.rds.model.DescribeDbLogFilesResponse.wrap)
        .provideEnvironment(r)
    def describeDBSnapshots(
        request: zio.aws.rds.model.DescribeDbSnapshotsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBSnapshot.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbSnapshotsRequest,
        DBSnapshot,
        DescribeDBSnapshotsPublisher
      ](
        "describeDBSnapshots",
        api.describeDBSnapshotsPaginator,
        _.dbSnapshots()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBSnapshot.wrap(item))
        .provideEnvironment(r)
    def describeDBSnapshotsPaginated(
        request: zio.aws.rds.model.DescribeDbSnapshotsRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeDbSnapshotsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDbSnapshotsRequest,
        DescribeDbSnapshotsResponse
      ]("describeDBSnapshots", api.describeDBSnapshots)(request.buildAwsValue())
        .map(zio.aws.rds.model.DescribeDbSnapshotsResponse.wrap)
        .provideEnvironment(r)
    def describeDBParameters(
        request: zio.aws.rds.model.DescribeDbParametersRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.Parameter.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbParametersRequest,
        Parameter,
        DescribeDBParametersPublisher
      ](
        "describeDBParameters",
        api.describeDBParametersPaginator,
        _.parameters()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeDBParametersPaginated(
        request: zio.aws.rds.model.DescribeDbParametersRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDbParametersRequest,
        DescribeDbParametersResponse
      ]("describeDBParameters", api.describeDBParameters)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.DescribeDbParametersResponse.wrap)
        .provideEnvironment(r)
    def addTagsToResource(
        request: zio.aws.rds.model.AddTagsToResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AddTagsToResourceRequest, AddTagsToResourceResponse](
        "addTagsToResource",
        api.addTagsToResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeDBProxies(
        request: zio.aws.rds.model.DescribeDbProxiesRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxy.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbProxiesRequest,
        DBProxy,
        DescribeDBProxiesPublisher
      ]("describeDBProxies", api.describeDBProxiesPaginator, _.dbProxies())(
        request.buildAwsValue()
      ).map(item => zio.aws.rds.model.DBProxy.wrap(item)).provideEnvironment(r)
    def describeDBProxiesPaginated(
        request: zio.aws.rds.model.DescribeDbProxiesRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly] =
      asyncRequestResponse[DescribeDbProxiesRequest, DescribeDbProxiesResponse](
        "describeDBProxies",
        api.describeDBProxies
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.DescribeDbProxiesResponse.wrap)
        .provideEnvironment(r)
    def describeDBClusterSnapshots(
        request: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBClusterSnapshot.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbClusterSnapshotsRequest,
        DBClusterSnapshot,
        DescribeDBClusterSnapshotsPublisher
      ](
        "describeDBClusterSnapshots",
        api.describeDBClusterSnapshotsPaginator,
        _.dbClusterSnapshots()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBClusterSnapshot.wrap(item))
        .provideEnvironment(r)
    def describeDBClusterSnapshotsPaginated(
        request: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbClusterSnapshotsRequest,
      DescribeDbClusterSnapshotsResponse
    ]("describeDBClusterSnapshots", api.describeDBClusterSnapshots)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def resetDBClusterParameterGroup(
        request: zio.aws.rds.model.ResetDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ResetDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      ResetDbClusterParameterGroupRequest,
      ResetDbClusterParameterGroupResponse
    ]("resetDBClusterParameterGroup", api.resetDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ResetDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def describeDBProxyEndpoints(
        request: zio.aws.rds.model.DescribeDbProxyEndpointsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxyEndpoint.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbProxyEndpointsRequest,
        DBProxyEndpoint,
        DescribeDBProxyEndpointsPublisher
      ](
        "describeDBProxyEndpoints",
        api.describeDBProxyEndpointsPaginator,
        _.dbProxyEndpoints()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBProxyEndpoint.wrap(item))
        .provideEnvironment(r)
    def describeDBProxyEndpointsPaginated(
        request: zio.aws.rds.model.DescribeDbProxyEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbProxyEndpointsRequest,
      DescribeDbProxyEndpointsResponse
    ]("describeDBProxyEndpoints", api.describeDBProxyEndpoints)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbProxyEndpointsResponse.wrap)
      .provideEnvironment(r)
    def removeSourceIdentifierFromSubscription(
        request: zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveSourceIdentifierFromSubscriptionRequest,
      RemoveSourceIdentifierFromSubscriptionResponse
    ](
      "removeSourceIdentifierFromSubscription",
      api.removeSourceIdentifierFromSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def describeEngineDefaultClusterParameters(
        request: zio.aws.rds.model.DescribeEngineDefaultClusterParametersRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEngineDefaultClusterParametersRequest,
      DescribeEngineDefaultClusterParametersResponse
    ](
      "describeEngineDefaultClusterParameters",
      api.describeEngineDefaultClusterParameters
    )(request.buildAwsValue())
      .map(
        zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.wrap
      )
      .provideEnvironment(r)
    def createDBSubnetGroup(
        request: zio.aws.rds.model.CreateDbSubnetGroupRequest
    ): IO[AwsError, zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[
        CreateDbSubnetGroupRequest,
        CreateDbSubnetGroupResponse
      ]("createDBSubnetGroup", api.createDBSubnetGroup)(request.buildAwsValue())
        .map(zio.aws.rds.model.CreateDbSubnetGroupResponse.wrap)
        .provideEnvironment(r)
    def createDBClusterEndpoint(
        request: zio.aws.rds.model.CreateDbClusterEndpointRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.CreateDbClusterEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDbClusterEndpointRequest,
      CreateDbClusterEndpointResponse
    ]("createDBClusterEndpoint", api.createDBClusterEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.CreateDbClusterEndpointResponse.wrap)
      .provideEnvironment(r)
    def addRoleToDBCluster(
        request: zio.aws.rds.model.AddRoleToDbClusterRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AddRoleToDbClusterRequest,
      AddRoleToDbClusterResponse
    ]("addRoleToDBCluster", api.addRoleToDBCluster)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyCustomDBEngineVersion(
        request: zio.aws.rds.model.ModifyCustomDbEngineVersionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ModifyCustomDbEngineVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyCustomDbEngineVersionRequest,
      ModifyCustomDbEngineVersionResponse
    ]("modifyCustomDBEngineVersion", api.modifyCustomDBEngineVersion)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ModifyCustomDbEngineVersionResponse.wrap)
      .provideEnvironment(r)
    def copyDBClusterParameterGroup(
        request: zio.aws.rds.model.CopyDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.CopyDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CopyDbClusterParameterGroupRequest,
      CopyDbClusterParameterGroupResponse
    ]("copyDBClusterParameterGroup", api.copyDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.CopyDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def describePendingMaintenanceActions(
        request: zio.aws.rds.model.DescribePendingMaintenanceActionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribePendingMaintenanceActionsRequest,
      ResourcePendingMaintenanceActions,
      DescribePendingMaintenanceActionsPublisher
    ](
      "describePendingMaintenanceActions",
      api.describePendingMaintenanceActionsPaginator,
      _.pendingMaintenanceActions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.rds.model.ResourcePendingMaintenanceActions.wrap(item)
      )
      .provideEnvironment(r)
    def describePendingMaintenanceActionsPaginated(
        request: zio.aws.rds.model.DescribePendingMaintenanceActionsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePendingMaintenanceActionsRequest,
      DescribePendingMaintenanceActionsResponse
    ](
      "describePendingMaintenanceActions",
      api.describePendingMaintenanceActions
    )(request.buildAwsValue())
      .map(zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.wrap)
      .provideEnvironment(r)
    def deleteDBClusterEndpoint(
        request: zio.aws.rds.model.DeleteDbClusterEndpointRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DeleteDbClusterEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDbClusterEndpointRequest,
      DeleteDbClusterEndpointResponse
    ]("deleteDBClusterEndpoint", api.deleteDBClusterEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DeleteDbClusterEndpointResponse.wrap)
      .provideEnvironment(r)
    def addRoleToDBInstance(
        request: zio.aws.rds.model.AddRoleToDbInstanceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AddRoleToDbInstanceRequest,
      AddRoleToDbInstanceResponse
    ]("addRoleToDBInstance", api.addRoleToDBInstance)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def startActivityStream(
        request: zio.aws.rds.model.StartActivityStreamRequest
    ): IO[AwsError, zio.aws.rds.model.StartActivityStreamResponse.ReadOnly] =
      asyncRequestResponse[
        StartActivityStreamRequest,
        StartActivityStreamResponse
      ]("startActivityStream", api.startActivityStream)(request.buildAwsValue())
        .map(zio.aws.rds.model.StartActivityStreamResponse.wrap)
        .provideEnvironment(r)
    def deleteDBClusterParameterGroup(
        request: zio.aws.rds.model.DeleteDbClusterParameterGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDbClusterParameterGroupRequest,
      DeleteDbClusterParameterGroupResponse
    ]("deleteDBClusterParameterGroup", api.deleteDBClusterParameterGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createDBSecurityGroup(
        request: zio.aws.rds.model.CreateDbSecurityGroupRequest
    ): IO[AwsError, zio.aws.rds.model.CreateDbSecurityGroupResponse.ReadOnly] =
      asyncRequestResponse[
        CreateDbSecurityGroupRequest,
        CreateDbSecurityGroupResponse
      ]("createDBSecurityGroup", api.createDBSecurityGroup)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.CreateDbSecurityGroupResponse.wrap)
        .provideEnvironment(r)
    def describeSourceRegions(
        request: zio.aws.rds.model.DescribeSourceRegionsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.SourceRegion.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeSourceRegionsRequest,
        SourceRegion,
        DescribeSourceRegionsPublisher
      ](
        "describeSourceRegions",
        api.describeSourceRegionsPaginator,
        _.sourceRegions()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.SourceRegion.wrap(item))
        .provideEnvironment(r)
    def describeSourceRegionsPaginated(
        request: zio.aws.rds.model.DescribeSourceRegionsRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeSourceRegionsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeSourceRegionsRequest,
        DescribeSourceRegionsResponse
      ]("describeSourceRegions", api.describeSourceRegions)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.DescribeSourceRegionsResponse.wrap)
        .provideEnvironment(r)
    def backtrackDBCluster(
        request: zio.aws.rds.model.BacktrackDbClusterRequest
    ): IO[AwsError, zio.aws.rds.model.BacktrackDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        BacktrackDbClusterRequest,
        BacktrackDbClusterResponse
      ]("backtrackDBCluster", api.backtrackDBCluster)(request.buildAwsValue())
        .map(zio.aws.rds.model.BacktrackDbClusterResponse.wrap)
        .provideEnvironment(r)
    def removeFromGlobalCluster(
        request: zio.aws.rds.model.RemoveFromGlobalClusterRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.RemoveFromGlobalClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveFromGlobalClusterRequest,
      RemoveFromGlobalClusterResponse
    ]("removeFromGlobalCluster", api.removeFromGlobalCluster)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.RemoveFromGlobalClusterResponse.wrap)
      .provideEnvironment(r)
    def modifyDBClusterParameterGroup(
        request: zio.aws.rds.model.ModifyDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDbClusterParameterGroupRequest,
      ModifyDbClusterParameterGroupResponse
    ]("modifyDBClusterParameterGroup", api.modifyDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def rebootDBCluster(
        request: zio.aws.rds.model.RebootDbClusterRequest
    ): IO[AwsError, zio.aws.rds.model.RebootDbClusterResponse.ReadOnly] =
      asyncRequestResponse[RebootDbClusterRequest, RebootDbClusterResponse](
        "rebootDBCluster",
        api.rebootDBCluster
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.RebootDbClusterResponse.wrap)
        .provideEnvironment(r)
    def cancelExportTask(
        request: zio.aws.rds.model.CancelExportTaskRequest
    ): IO[AwsError, zio.aws.rds.model.CancelExportTaskResponse.ReadOnly] =
      asyncRequestResponse[CancelExportTaskRequest, CancelExportTaskResponse](
        "cancelExportTask",
        api.cancelExportTask
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.CancelExportTaskResponse.wrap)
        .provideEnvironment(r)
    def createDBSnapshot(
        request: zio.aws.rds.model.CreateDbSnapshotRequest
    ): IO[AwsError, zio.aws.rds.model.CreateDbSnapshotResponse.ReadOnly] =
      asyncRequestResponse[CreateDbSnapshotRequest, CreateDbSnapshotResponse](
        "createDBSnapshot",
        api.createDBSnapshot
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.CreateDbSnapshotResponse.wrap)
        .provideEnvironment(r)
    def deleteDBInstanceAutomatedBackup(
        request: zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDbInstanceAutomatedBackupRequest,
      DeleteDbInstanceAutomatedBackupResponse
    ]("deleteDBInstanceAutomatedBackup", api.deleteDBInstanceAutomatedBackup)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.wrap)
      .provideEnvironment(r)
    def deleteDBSnapshot(
        request: zio.aws.rds.model.DeleteDbSnapshotRequest
    ): IO[AwsError, zio.aws.rds.model.DeleteDbSnapshotResponse.ReadOnly] =
      asyncRequestResponse[DeleteDbSnapshotRequest, DeleteDbSnapshotResponse](
        "deleteDBSnapshot",
        api.deleteDBSnapshot
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.DeleteDbSnapshotResponse.wrap)
        .provideEnvironment(r)
    def stopDBCluster(
        request: zio.aws.rds.model.StopDbClusterRequest
    ): IO[AwsError, zio.aws.rds.model.StopDbClusterResponse.ReadOnly] =
      asyncRequestResponse[StopDbClusterRequest, StopDbClusterResponse](
        "stopDBCluster",
        api.stopDBCluster
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.StopDbClusterResponse.wrap)
        .provideEnvironment(r)
    def createDBCluster(
        request: zio.aws.rds.model.CreateDbClusterRequest
    ): IO[AwsError, zio.aws.rds.model.CreateDbClusterResponse.ReadOnly] =
      asyncRequestResponse[CreateDbClusterRequest, CreateDbClusterResponse](
        "createDBCluster",
        api.createDBCluster
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.CreateDbClusterResponse.wrap)
        .provideEnvironment(r)
    def describeCertificates(
        request: zio.aws.rds.model.DescribeCertificatesRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.Certificate.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeCertificatesRequest,
        Certificate,
        DescribeCertificatesPublisher
      ](
        "describeCertificates",
        api.describeCertificatesPaginator,
        _.certificates()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.Certificate.wrap(item))
        .provideEnvironment(r)
    def describeCertificatesPaginated(
        request: zio.aws.rds.model.DescribeCertificatesRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeCertificatesRequest,
        DescribeCertificatesResponse
      ]("describeCertificates", api.describeCertificates)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.DescribeCertificatesResponse.wrap)
        .provideEnvironment(r)
    def modifyDBSnapshot(
        request: zio.aws.rds.model.ModifyDbSnapshotRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyDbSnapshotResponse.ReadOnly] =
      asyncRequestResponse[ModifyDbSnapshotRequest, ModifyDbSnapshotResponse](
        "modifyDBSnapshot",
        api.modifyDBSnapshot
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.ModifyDbSnapshotResponse.wrap)
        .provideEnvironment(r)
    def deleteEventSubscription(
        request: zio.aws.rds.model.DeleteEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DeleteEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEventSubscriptionRequest,
      DeleteEventSubscriptionResponse
    ]("deleteEventSubscription", api.deleteEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DeleteEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def deleteDBSecurityGroup(
        request: zio.aws.rds.model.DeleteDbSecurityGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDbSecurityGroupRequest,
      DeleteDbSecurityGroupResponse
    ]("deleteDBSecurityGroup", api.deleteDBSecurityGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteDBParameterGroup(
        request: zio.aws.rds.model.DeleteDbParameterGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDbParameterGroupRequest,
      DeleteDbParameterGroupResponse
    ]("deleteDBParameterGroup", api.deleteDBParameterGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeDBSecurityGroups(
        request: zio.aws.rds.model.DescribeDbSecurityGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBSecurityGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbSecurityGroupsRequest,
        DBSecurityGroup,
        DescribeDBSecurityGroupsPublisher
      ](
        "describeDBSecurityGroups",
        api.describeDBSecurityGroupsPaginator,
        _.dbSecurityGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBSecurityGroup.wrap(item))
        .provideEnvironment(r)
    def describeDBSecurityGroupsPaginated(
        request: zio.aws.rds.model.DescribeDbSecurityGroupsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbSecurityGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbSecurityGroupsRequest,
      DescribeDbSecurityGroupsResponse
    ]("describeDBSecurityGroups", api.describeDBSecurityGroups)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbSecurityGroupsResponse.wrap)
      .provideEnvironment(r)
    def purchaseReservedDBInstancesOffering(
        request: zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.ReadOnly
    ] = asyncRequestResponse[
      PurchaseReservedDbInstancesOfferingRequest,
      PurchaseReservedDbInstancesOfferingResponse
    ](
      "purchaseReservedDBInstancesOffering",
      api.purchaseReservedDBInstancesOffering
    )(request.buildAwsValue())
      .map(zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.wrap)
      .provideEnvironment(r)
    def describeDBSubnetGroups(
        request: zio.aws.rds.model.DescribeDbSubnetGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbSubnetGroupsRequest,
        DBSubnetGroup,
        DescribeDBSubnetGroupsPublisher
      ](
        "describeDBSubnetGroups",
        api.describeDBSubnetGroupsPaginator,
        _.dbSubnetGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBSubnetGroup.wrap(item))
        .provideEnvironment(r)
    def describeDBSubnetGroupsPaginated(
        request: zio.aws.rds.model.DescribeDbSubnetGroupsRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeDbSubnetGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDbSubnetGroupsRequest,
        DescribeDbSubnetGroupsResponse
      ]("describeDBSubnetGroups", api.describeDBSubnetGroups)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.DescribeDbSubnetGroupsResponse.wrap)
        .provideEnvironment(r)
    def removeRoleFromDBCluster(
        request: zio.aws.rds.model.RemoveRoleFromDbClusterRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveRoleFromDbClusterRequest,
      RemoveRoleFromDbClusterResponse
    ]("removeRoleFromDBCluster", api.removeRoleFromDBCluster)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createDBClusterParameterGroup(
        request: zio.aws.rds.model.CreateDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.CreateDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDbClusterParameterGroupRequest,
      CreateDbClusterParameterGroupResponse
    ]("createDBClusterParameterGroup", api.createDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.CreateDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def modifyDBCluster(
        request: zio.aws.rds.model.ModifyDbClusterRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyDbClusterResponse.ReadOnly] =
      asyncRequestResponse[ModifyDbClusterRequest, ModifyDbClusterResponse](
        "modifyDBCluster",
        api.modifyDBCluster
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.ModifyDbClusterResponse.wrap)
        .provideEnvironment(r)
    def restoreDBClusterFromS3(
        request: zio.aws.rds.model.RestoreDbClusterFromS3Request
    ): IO[AwsError, zio.aws.rds.model.RestoreDbClusterFromS3Response.ReadOnly] =
      asyncRequestResponse[
        RestoreDbClusterFromS3Request,
        RestoreDbClusterFromS3Response
      ]("restoreDBClusterFromS3", api.restoreDBClusterFromS3)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.RestoreDbClusterFromS3Response.wrap)
        .provideEnvironment(r)
    def describeValidDBInstanceModifications(
        request: zio.aws.rds.model.DescribeValidDbInstanceModificationsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeValidDbInstanceModificationsRequest,
      DescribeValidDbInstanceModificationsResponse
    ](
      "describeValidDBInstanceModifications",
      api.describeValidDBInstanceModifications
    )(request.buildAwsValue())
      .map(zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.wrap)
      .provideEnvironment(r)
    def createDBProxyEndpoint(
        request: zio.aws.rds.model.CreateDbProxyEndpointRequest
    ): IO[AwsError, zio.aws.rds.model.CreateDbProxyEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        CreateDbProxyEndpointRequest,
        CreateDbProxyEndpointResponse
      ]("createDBProxyEndpoint", api.createDBProxyEndpoint)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.CreateDbProxyEndpointResponse.wrap)
        .provideEnvironment(r)
    def resetDBParameterGroup(
        request: zio.aws.rds.model.ResetDbParameterGroupRequest
    ): IO[AwsError, zio.aws.rds.model.ResetDbParameterGroupResponse.ReadOnly] =
      asyncRequestResponse[
        ResetDbParameterGroupRequest,
        ResetDbParameterGroupResponse
      ]("resetDBParameterGroup", api.resetDBParameterGroup)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.ResetDbParameterGroupResponse.wrap)
        .provideEnvironment(r)
    def createBlueGreenDeployment(
        request: zio.aws.rds.model.CreateBlueGreenDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.CreateBlueGreenDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateBlueGreenDeploymentRequest,
      CreateBlueGreenDeploymentResponse
    ]("createBlueGreenDeployment", api.createBlueGreenDeployment)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.CreateBlueGreenDeploymentResponse.wrap)
      .provideEnvironment(r)
    def deleteDBProxyEndpoint(
        request: zio.aws.rds.model.DeleteDbProxyEndpointRequest
    ): IO[AwsError, zio.aws.rds.model.DeleteDbProxyEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteDbProxyEndpointRequest,
        DeleteDbProxyEndpointResponse
      ]("deleteDBProxyEndpoint", api.deleteDBProxyEndpoint)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.DeleteDbProxyEndpointResponse.wrap)
        .provideEnvironment(r)
    def removeTagsFromResource(
        request: zio.aws.rds.model.RemoveTagsFromResourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveTagsFromResourceRequest,
      RemoveTagsFromResourceResponse
    ]("removeTagsFromResource", api.removeTagsFromResource)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def promoteReadReplica(
        request: zio.aws.rds.model.PromoteReadReplicaRequest
    ): IO[AwsError, zio.aws.rds.model.PromoteReadReplicaResponse.ReadOnly] =
      asyncRequestResponse[
        PromoteReadReplicaRequest,
        PromoteReadReplicaResponse
      ]("promoteReadReplica", api.promoteReadReplica)(request.buildAwsValue())
        .map(zio.aws.rds.model.PromoteReadReplicaResponse.wrap)
        .provideEnvironment(r)
    def describeBlueGreenDeployments(
        request: zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.BlueGreenDeployment.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeBlueGreenDeploymentsRequest,
        BlueGreenDeployment,
        DescribeBlueGreenDeploymentsPublisher
      ](
        "describeBlueGreenDeployments",
        api.describeBlueGreenDeploymentsPaginator,
        _.blueGreenDeployments()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.BlueGreenDeployment.wrap(item))
        .provideEnvironment(r)
    def describeBlueGreenDeploymentsPaginated(
        request: zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeBlueGreenDeploymentsRequest,
      DescribeBlueGreenDeploymentsResponse
    ]("describeBlueGreenDeployments", api.describeBlueGreenDeployments)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse.wrap)
      .provideEnvironment(r)
    def describeReservedDBInstancesOfferings(
        request: zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeReservedDbInstancesOfferingsRequest,
      ReservedDBInstancesOffering,
      DescribeReservedDBInstancesOfferingsPublisher
    ](
      "describeReservedDBInstancesOfferings",
      api.describeReservedDBInstancesOfferingsPaginator,
      _.reservedDBInstancesOfferings()
    )(request.buildAwsValue())
      .map(item => zio.aws.rds.model.ReservedDBInstancesOffering.wrap(item))
      .provideEnvironment(r)
    def describeReservedDBInstancesOfferingsPaginated(
        request: zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReservedDbInstancesOfferingsRequest,
      DescribeReservedDbInstancesOfferingsResponse
    ](
      "describeReservedDBInstancesOfferings",
      api.describeReservedDBInstancesOfferings
    )(request.buildAwsValue())
      .map(zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.wrap)
      .provideEnvironment(r)
    def createDBParameterGroup(
        request: zio.aws.rds.model.CreateDbParameterGroupRequest
    ): IO[AwsError, zio.aws.rds.model.CreateDbParameterGroupResponse.ReadOnly] =
      asyncRequestResponse[
        CreateDbParameterGroupRequest,
        CreateDbParameterGroupResponse
      ]("createDBParameterGroup", api.createDBParameterGroup)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.CreateDbParameterGroupResponse.wrap)
        .provideEnvironment(r)
    def startExportTask(
        request: zio.aws.rds.model.StartExportTaskRequest
    ): IO[AwsError, zio.aws.rds.model.StartExportTaskResponse.ReadOnly] =
      asyncRequestResponse[StartExportTaskRequest, StartExportTaskResponse](
        "startExportTask",
        api.startExportTask
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.StartExportTaskResponse.wrap)
        .provideEnvironment(r)
    def applyPendingMaintenanceAction(
        request: zio.aws.rds.model.ApplyPendingMaintenanceActionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      ApplyPendingMaintenanceActionRequest,
      ApplyPendingMaintenanceActionResponse
    ]("applyPendingMaintenanceAction", api.applyPendingMaintenanceAction)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.wrap)
      .provideEnvironment(r)
    def modifyDBSubnetGroup(
        request: zio.aws.rds.model.ModifyDbSubnetGroupRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyDbSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyDbSubnetGroupRequest,
        ModifyDbSubnetGroupResponse
      ]("modifyDBSubnetGroup", api.modifyDBSubnetGroup)(request.buildAwsValue())
        .map(zio.aws.rds.model.ModifyDbSubnetGroupResponse.wrap)
        .provideEnvironment(r)
    def modifyGlobalCluster(
        request: zio.aws.rds.model.ModifyGlobalClusterRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyGlobalClusterResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyGlobalClusterRequest,
        ModifyGlobalClusterResponse
      ]("modifyGlobalCluster", api.modifyGlobalCluster)(request.buildAwsValue())
        .map(zio.aws.rds.model.ModifyGlobalClusterResponse.wrap)
        .provideEnvironment(r)
    def copyDBSnapshot(
        request: zio.aws.rds.model.CopyDbSnapshotRequest
    ): IO[AwsError, zio.aws.rds.model.CopyDbSnapshotResponse.ReadOnly] =
      asyncRequestResponse[CopyDbSnapshotRequest, CopyDbSnapshotResponse](
        "copyDBSnapshot",
        api.copyDBSnapshot
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.CopyDbSnapshotResponse.wrap)
        .provideEnvironment(r)
    def modifyActivityStream(
        request: zio.aws.rds.model.ModifyActivityStreamRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyActivityStreamResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyActivityStreamRequest,
        ModifyActivityStreamResponse
      ]("modifyActivityStream", api.modifyActivityStream)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.ModifyActivityStreamResponse.wrap)
        .provideEnvironment(r)
    def restoreDBClusterFromSnapshot(
        request: zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreDbClusterFromSnapshotRequest,
      RestoreDbClusterFromSnapshotResponse
    ]("restoreDBClusterFromSnapshot", api.restoreDBClusterFromSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.wrap)
      .provideEnvironment(r)
    def copyOptionGroup(
        request: zio.aws.rds.model.CopyOptionGroupRequest
    ): IO[AwsError, zio.aws.rds.model.CopyOptionGroupResponse.ReadOnly] =
      asyncRequestResponse[CopyOptionGroupRequest, CopyOptionGroupResponse](
        "copyOptionGroup",
        api.copyOptionGroup
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.CopyOptionGroupResponse.wrap)
        .provideEnvironment(r)
    def restoreDBInstanceFromS3(
        request: zio.aws.rds.model.RestoreDbInstanceFromS3Request
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      RestoreDbInstanceFromS3Request,
      RestoreDbInstanceFromS3Response
    ]("restoreDBInstanceFromS3", api.restoreDBInstanceFromS3)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.RestoreDbInstanceFromS3Response.wrap)
      .provideEnvironment(r)
    def removeRoleFromDBInstance(
        request: zio.aws.rds.model.RemoveRoleFromDbInstanceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveRoleFromDbInstanceRequest,
      RemoveRoleFromDbInstanceResponse
    ]("removeRoleFromDBInstance", api.removeRoleFromDBInstance)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeGlobalClusters(
        request: zio.aws.rds.model.DescribeGlobalClustersRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.GlobalCluster.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeGlobalClustersRequest,
        GlobalCluster,
        DescribeGlobalClustersPublisher
      ](
        "describeGlobalClusters",
        api.describeGlobalClustersPaginator,
        _.globalClusters()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.GlobalCluster.wrap(item))
        .provideEnvironment(r)
    def describeGlobalClustersPaginated(
        request: zio.aws.rds.model.DescribeGlobalClustersRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeGlobalClustersRequest,
        DescribeGlobalClustersResponse
      ]("describeGlobalClusters", api.describeGlobalClusters)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.DescribeGlobalClustersResponse.wrap)
        .provideEnvironment(r)
    def describeDBProxyTargetGroups(
        request: zio.aws.rds.model.DescribeDbProxyTargetGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxyTargetGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbProxyTargetGroupsRequest,
        DBProxyTargetGroup,
        DescribeDBProxyTargetGroupsPublisher
      ](
        "describeDBProxyTargetGroups",
        api.describeDBProxyTargetGroupsPaginator,
        _.targetGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBProxyTargetGroup.wrap(item))
        .provideEnvironment(r)
    def describeDBProxyTargetGroupsPaginated(
        request: zio.aws.rds.model.DescribeDbProxyTargetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbProxyTargetGroupsRequest,
      DescribeDbProxyTargetGroupsResponse
    ]("describeDBProxyTargetGroups", api.describeDBProxyTargetGroups)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.wrap)
      .provideEnvironment(r)
    def describeDBInstanceAutomatedBackups(
        request: zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeDbInstanceAutomatedBackupsRequest,
      DBInstanceAutomatedBackup,
      DescribeDBInstanceAutomatedBackupsPublisher
    ](
      "describeDBInstanceAutomatedBackups",
      api.describeDBInstanceAutomatedBackupsPaginator,
      _.dbInstanceAutomatedBackups()
    )(request.buildAwsValue())
      .map(item => zio.aws.rds.model.DBInstanceAutomatedBackup.wrap(item))
      .provideEnvironment(r)
    def describeDBInstanceAutomatedBackupsPaginated(
        request: zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbInstanceAutomatedBackupsRequest,
      DescribeDbInstanceAutomatedBackupsResponse
    ](
      "describeDBInstanceAutomatedBackups",
      api.describeDBInstanceAutomatedBackups
    )(request.buildAwsValue())
      .map(zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.wrap)
      .provideEnvironment(r)
    def describeDBClusterParameters(
        request: zio.aws.rds.model.DescribeDbClusterParametersRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.Parameter.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbClusterParametersRequest,
        Parameter,
        DescribeDBClusterParametersPublisher
      ](
        "describeDBClusterParameters",
        api.describeDBClusterParametersPaginator,
        _.parameters()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeDBClusterParametersPaginated(
        request: zio.aws.rds.model.DescribeDbClusterParametersRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbClusterParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbClusterParametersRequest,
      DescribeDbClusterParametersResponse
    ]("describeDBClusterParameters", api.describeDBClusterParameters)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbClusterParametersResponse.wrap)
      .provideEnvironment(r)
    def copyDBParameterGroup(
        request: zio.aws.rds.model.CopyDbParameterGroupRequest
    ): IO[AwsError, zio.aws.rds.model.CopyDbParameterGroupResponse.ReadOnly] =
      asyncRequestResponse[
        CopyDbParameterGroupRequest,
        CopyDbParameterGroupResponse
      ]("copyDBParameterGroup", api.copyDBParameterGroup)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.CopyDbParameterGroupResponse.wrap)
        .provideEnvironment(r)
    def modifyDBSnapshotAttribute(
        request: zio.aws.rds.model.ModifyDbSnapshotAttributeRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDbSnapshotAttributeRequest,
      ModifyDbSnapshotAttributeResponse
    ]("modifyDBSnapshotAttribute", api.modifyDBSnapshotAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.wrap)
      .provideEnvironment(r)
    def authorizeDBSecurityGroupIngress(
        request: zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.AuthorizeDbSecurityGroupIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      AuthorizeDbSecurityGroupIngressRequest,
      AuthorizeDbSecurityGroupIngressResponse
    ]("authorizeDBSecurityGroupIngress", api.authorizeDBSecurityGroupIngress)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.AuthorizeDbSecurityGroupIngressResponse.wrap)
      .provideEnvironment(r)
    def modifyEventSubscription(
        request: zio.aws.rds.model.ModifyEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ModifyEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyEventSubscriptionRequest,
      ModifyEventSubscriptionResponse
    ]("modifyEventSubscription", api.modifyEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ModifyEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def describeDBClusterBacktracks(
        request: zio.aws.rds.model.DescribeDbClusterBacktracksRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBClusterBacktrack.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbClusterBacktracksRequest,
        DBClusterBacktrack,
        DescribeDBClusterBacktracksPublisher
      ](
        "describeDBClusterBacktracks",
        api.describeDBClusterBacktracksPaginator,
        _.dbClusterBacktracks()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBClusterBacktrack.wrap(item))
        .provideEnvironment(r)
    def describeDBClusterBacktracksPaginated(
        request: zio.aws.rds.model.DescribeDbClusterBacktracksRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbClusterBacktracksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbClusterBacktracksRequest,
      DescribeDbClusterBacktracksResponse
    ]("describeDBClusterBacktracks", api.describeDBClusterBacktracks)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbClusterBacktracksResponse.wrap)
      .provideEnvironment(r)
    def modifyDBParameterGroup(
        request: zio.aws.rds.model.ModifyDbParameterGroupRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyDbParameterGroupResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyDbParameterGroupRequest,
        ModifyDbParameterGroupResponse
      ]("modifyDBParameterGroup", api.modifyDBParameterGroup)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.ModifyDbParameterGroupResponse.wrap)
        .provideEnvironment(r)
    def modifyCertificates(
        request: zio.aws.rds.model.ModifyCertificatesRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyCertificatesResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyCertificatesRequest,
        ModifyCertificatesResponse
      ]("modifyCertificates", api.modifyCertificates)(request.buildAwsValue())
        .map(zio.aws.rds.model.ModifyCertificatesResponse.wrap)
        .provideEnvironment(r)
    def createDBInstance(
        request: zio.aws.rds.model.CreateDbInstanceRequest
    ): IO[AwsError, zio.aws.rds.model.CreateDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[CreateDbInstanceRequest, CreateDbInstanceResponse](
        "createDBInstance",
        api.createDBInstance
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.CreateDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def deleteDBClusterSnapshot(
        request: zio.aws.rds.model.DeleteDbClusterSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DeleteDbClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDbClusterSnapshotRequest,
      DeleteDbClusterSnapshotResponse
    ]("deleteDBClusterSnapshot", api.deleteDBClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DeleteDbClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def describeExportTasks(
        request: zio.aws.rds.model.DescribeExportTasksRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.ExportTask.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeExportTasksRequest,
        ExportTask,
        DescribeExportTasksPublisher
      ](
        "describeExportTasks",
        api.describeExportTasksPaginator,
        _.exportTasks()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.ExportTask.wrap(item))
        .provideEnvironment(r)
    def describeExportTasksPaginated(
        request: zio.aws.rds.model.DescribeExportTasksRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeExportTasksResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeExportTasksRequest,
        DescribeExportTasksResponse
      ]("describeExportTasks", api.describeExportTasks)(request.buildAwsValue())
        .map(zio.aws.rds.model.DescribeExportTasksResponse.wrap)
        .provideEnvironment(r)
    def startDBCluster(
        request: zio.aws.rds.model.StartDbClusterRequest
    ): IO[AwsError, zio.aws.rds.model.StartDbClusterResponse.ReadOnly] =
      asyncRequestResponse[StartDbClusterRequest, StartDbClusterResponse](
        "startDBCluster",
        api.startDBCluster
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.StartDbClusterResponse.wrap)
        .provideEnvironment(r)
    def modifyDBClusterSnapshotAttribute(
        request: zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDbClusterSnapshotAttributeRequest,
      ModifyDbClusterSnapshotAttributeResponse
    ]("modifyDBClusterSnapshotAttribute", api.modifyDBClusterSnapshotAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ModifyDbClusterSnapshotAttributeResponse.wrap)
      .provideEnvironment(r)
    def createDBProxy(
        request: zio.aws.rds.model.CreateDbProxyRequest
    ): IO[AwsError, zio.aws.rds.model.CreateDbProxyResponse.ReadOnly] =
      asyncRequestResponse[CreateDbProxyRequest, CreateDbProxyResponse](
        "createDBProxy",
        api.createDBProxy
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.CreateDbProxyResponse.wrap)
        .provideEnvironment(r)
    def describeDBSnapshotAttributes(
        request: zio.aws.rds.model.DescribeDbSnapshotAttributesRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbSnapshotAttributesRequest,
      DescribeDbSnapshotAttributesResponse
    ]("describeDBSnapshotAttributes", api.describeDBSnapshotAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.wrap)
      .provideEnvironment(r)
    def describeEventCategories(
        request: zio.aws.rds.model.DescribeEventCategoriesRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeEventCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEventCategoriesRequest,
      DescribeEventCategoriesResponse
    ]("describeEventCategories", api.describeEventCategories)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeEventCategoriesResponse.wrap)
      .provideEnvironment(r)
    def deleteDBSubnetGroup(
        request: zio.aws.rds.model.DeleteDbSubnetGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDbSubnetGroupRequest,
      DeleteDbSubnetGroupResponse
    ]("deleteDBSubnetGroup", api.deleteDBSubnetGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyDBClusterEndpoint(
        request: zio.aws.rds.model.ModifyDbClusterEndpointRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ModifyDbClusterEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDbClusterEndpointRequest,
      ModifyDbClusterEndpointResponse
    ]("modifyDBClusterEndpoint", api.modifyDBClusterEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ModifyDbClusterEndpointResponse.wrap)
      .provideEnvironment(r)
    def startDBInstance(
        request: zio.aws.rds.model.StartDbInstanceRequest
    ): IO[AwsError, zio.aws.rds.model.StartDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[StartDbInstanceRequest, StartDbInstanceResponse](
        "startDBInstance",
        api.startDBInstance
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.StartDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def promoteReadReplicaDBCluster(
        request: zio.aws.rds.model.PromoteReadReplicaDbClusterRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      PromoteReadReplicaDbClusterRequest,
      PromoteReadReplicaDbClusterResponse
    ]("promoteReadReplicaDBCluster", api.promoteReadReplicaDBCluster)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.wrap)
      .provideEnvironment(r)
    def switchoverBlueGreenDeployment(
        request: zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.SwitchoverBlueGreenDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      SwitchoverBlueGreenDeploymentRequest,
      SwitchoverBlueGreenDeploymentResponse
    ]("switchoverBlueGreenDeployment", api.switchoverBlueGreenDeployment)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.SwitchoverBlueGreenDeploymentResponse.wrap)
      .provideEnvironment(r)
    def registerDBProxyTargets(
        request: zio.aws.rds.model.RegisterDbProxyTargetsRequest
    ): IO[AwsError, zio.aws.rds.model.RegisterDbProxyTargetsResponse.ReadOnly] =
      asyncRequestResponse[
        RegisterDbProxyTargetsRequest,
        RegisterDbProxyTargetsResponse
      ]("registerDBProxyTargets", api.registerDBProxyTargets)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.RegisterDbProxyTargetsResponse.wrap)
        .provideEnvironment(r)
    def stopDBInstance(
        request: zio.aws.rds.model.StopDbInstanceRequest
    ): IO[AwsError, zio.aws.rds.model.StopDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[StopDbInstanceRequest, StopDbInstanceResponse](
        "stopDBInstance",
        api.stopDBInstance
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.StopDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def modifyDBProxyTargetGroup(
        request: zio.aws.rds.model.ModifyDbProxyTargetGroupRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ModifyDbProxyTargetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDbProxyTargetGroupRequest,
      ModifyDbProxyTargetGroupResponse
    ]("modifyDBProxyTargetGroup", api.modifyDBProxyTargetGroup)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ModifyDbProxyTargetGroupResponse.wrap)
      .provideEnvironment(r)
    def restoreDBInstanceFromDBSnapshot(
        request: zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreDbInstanceFromDbSnapshotRequest,
      RestoreDbInstanceFromDbSnapshotResponse
    ]("restoreDBInstanceFromDBSnapshot", api.restoreDBInstanceFromDBSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.wrap)
      .provideEnvironment(r)
    def rebootDBInstance(
        request: zio.aws.rds.model.RebootDbInstanceRequest
    ): IO[AwsError, zio.aws.rds.model.RebootDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[RebootDbInstanceRequest, RebootDbInstanceResponse](
        "rebootDBInstance",
        api.rebootDBInstance
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.RebootDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def describeOptionGroupOptions(
        request: zio.aws.rds.model.DescribeOptionGroupOptionsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.OptionGroupOption.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeOptionGroupOptionsRequest,
        OptionGroupOption,
        DescribeOptionGroupOptionsPublisher
      ](
        "describeOptionGroupOptions",
        api.describeOptionGroupOptionsPaginator,
        _.optionGroupOptions()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.OptionGroupOption.wrap(item))
        .provideEnvironment(r)
    def describeOptionGroupOptionsPaginated(
        request: zio.aws.rds.model.DescribeOptionGroupOptionsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOptionGroupOptionsRequest,
      DescribeOptionGroupOptionsResponse
    ]("describeOptionGroupOptions", api.describeOptionGroupOptions)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeOptionGroupOptionsResponse.wrap)
      .provideEnvironment(r)
    def startDBInstanceAutomatedBackupsReplication(
        request: zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDbInstanceAutomatedBackupsReplicationRequest,
      StartDbInstanceAutomatedBackupsReplicationResponse
    ](
      "startDBInstanceAutomatedBackupsReplication",
      api.startDBInstanceAutomatedBackupsReplication
    )(request.buildAwsValue())
      .map(
        zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.wrap
      )
      .provideEnvironment(r)
    def describeDBClusterParameterGroups(
        request: zio.aws.rds.model.DescribeDbClusterParameterGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeDbClusterParameterGroupsRequest,
      DBClusterParameterGroup,
      DescribeDBClusterParameterGroupsPublisher
    ](
      "describeDBClusterParameterGroups",
      api.describeDBClusterParameterGroupsPaginator,
      _.dbClusterParameterGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.rds.model.DBClusterParameterGroup.wrap(item))
      .provideEnvironment(r)
    def describeDBClusterParameterGroupsPaginated(
        request: zio.aws.rds.model.DescribeDbClusterParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbClusterParameterGroupsRequest,
      DescribeDbClusterParameterGroupsResponse
    ]("describeDBClusterParameterGroups", api.describeDBClusterParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.wrap)
      .provideEnvironment(r)
    def restoreDBInstanceToPointInTime(
        request: zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreDbInstanceToPointInTimeRequest,
      RestoreDbInstanceToPointInTimeResponse
    ]("restoreDBInstanceToPointInTime", api.restoreDBInstanceToPointInTime)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.wrap)
      .provideEnvironment(r)
    def createEventSubscription(
        request: zio.aws.rds.model.CreateEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.CreateEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEventSubscriptionRequest,
      CreateEventSubscriptionResponse
    ]("createEventSubscription", api.createEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.CreateEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def createCustomDBEngineVersion(
        request: zio.aws.rds.model.CreateCustomDbEngineVersionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.CreateCustomDbEngineVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCustomDbEngineVersionRequest,
      CreateCustomDbEngineVersionResponse
    ]("createCustomDBEngineVersion", api.createCustomDBEngineVersion)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.CreateCustomDbEngineVersionResponse.wrap)
      .provideEnvironment(r)
    def describeOptionGroups(
        request: zio.aws.rds.model.DescribeOptionGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.OptionGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeOptionGroupsRequest,
        OptionGroup,
        DescribeOptionGroupsPublisher
      ](
        "describeOptionGroups",
        api.describeOptionGroupsPaginator,
        _.optionGroupsList()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.OptionGroup.wrap(item))
        .provideEnvironment(r)
    def describeOptionGroupsPaginated(
        request: zio.aws.rds.model.DescribeOptionGroupsRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeOptionGroupsRequest,
        DescribeOptionGroupsResponse
      ]("describeOptionGroups", api.describeOptionGroups)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.DescribeOptionGroupsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.rds.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.rds.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.rds.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def restoreDBClusterToPointInTime(
        request: zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreDbClusterToPointInTimeRequest,
      RestoreDbClusterToPointInTimeResponse
    ]("restoreDBClusterToPointInTime", api.restoreDBClusterToPointInTime)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.wrap)
      .provideEnvironment(r)
    def describeDBProxyTargets(
        request: zio.aws.rds.model.DescribeDbProxyTargetsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBProxyTarget.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbProxyTargetsRequest,
        DBProxyTarget,
        DescribeDBProxyTargetsPublisher
      ](
        "describeDBProxyTargets",
        api.describeDBProxyTargetsPaginator,
        _.targets()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBProxyTarget.wrap(item))
        .provideEnvironment(r)
    def describeDBProxyTargetsPaginated(
        request: zio.aws.rds.model.DescribeDbProxyTargetsRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeDbProxyTargetsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDbProxyTargetsRequest,
        DescribeDbProxyTargetsResponse
      ]("describeDBProxyTargets", api.describeDBProxyTargets)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.DescribeDbProxyTargetsResponse.wrap)
        .provideEnvironment(r)
    def describeDBClusters(
        request: zio.aws.rds.model.DescribeDbClustersRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbClustersRequest,
        DBCluster,
        DescribeDBClustersPublisher
      ]("describeDBClusters", api.describeDBClustersPaginator, _.dbClusters())(
        request.buildAwsValue()
      ).map(item => zio.aws.rds.model.DBCluster.wrap(item))
        .provideEnvironment(r)
    def describeDBClustersPaginated(
        request: zio.aws.rds.model.DescribeDbClustersRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeDbClustersResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDbClustersRequest,
        DescribeDbClustersResponse
      ]("describeDBClusters", api.describeDBClusters)(request.buildAwsValue())
        .map(zio.aws.rds.model.DescribeDbClustersResponse.wrap)
        .provideEnvironment(r)
    def failoverDBCluster(
        request: zio.aws.rds.model.FailoverDbClusterRequest
    ): IO[AwsError, zio.aws.rds.model.FailoverDbClusterResponse.ReadOnly] =
      asyncRequestResponse[FailoverDbClusterRequest, FailoverDbClusterResponse](
        "failoverDBCluster",
        api.failoverDBCluster
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.FailoverDbClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteOptionGroup(
        request: zio.aws.rds.model.DeleteOptionGroupRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteOptionGroupRequest, DeleteOptionGroupResponse](
        "deleteOptionGroup",
        api.deleteOptionGroup
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeEventSubscriptions(
        request: zio.aws.rds.model.DescribeEventSubscriptionsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.EventSubscription.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeEventSubscriptionsRequest,
        EventSubscription,
        DescribeEventSubscriptionsPublisher
      ](
        "describeEventSubscriptions",
        api.describeEventSubscriptionsPaginator,
        _.eventSubscriptionsList()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.EventSubscription.wrap(item))
        .provideEnvironment(r)
    def describeEventSubscriptionsPaginated(
        request: zio.aws.rds.model.DescribeEventSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeEventSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEventSubscriptionsRequest,
      DescribeEventSubscriptionsResponse
    ]("describeEventSubscriptions", api.describeEventSubscriptions)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeEventSubscriptionsResponse.wrap)
      .provideEnvironment(r)
    def describeDBInstances(
        request: zio.aws.rds.model.DescribeDbInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbInstancesRequest,
        DBInstance,
        DescribeDBInstancesPublisher
      ](
        "describeDBInstances",
        api.describeDBInstancesPaginator,
        _.dbInstances()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBInstance.wrap(item))
        .provideEnvironment(r)
    def describeDBInstancesPaginated(
        request: zio.aws.rds.model.DescribeDbInstancesRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeDbInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDbInstancesRequest,
        DescribeDbInstancesResponse
      ]("describeDBInstances", api.describeDBInstances)(request.buildAwsValue())
        .map(zio.aws.rds.model.DescribeDbInstancesResponse.wrap)
        .provideEnvironment(r)
    def createDBClusterSnapshot(
        request: zio.aws.rds.model.CreateDbClusterSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.CreateDbClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDbClusterSnapshotRequest,
      CreateDbClusterSnapshotResponse
    ]("createDBClusterSnapshot", api.createDBClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.CreateDbClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def modifyCurrentDBClusterCapacity(
        request: zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyCurrentDbClusterCapacityRequest,
      ModifyCurrentDbClusterCapacityResponse
    ]("modifyCurrentDBClusterCapacity", api.modifyCurrentDBClusterCapacity)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.wrap)
      .provideEnvironment(r)
    def switchoverReadReplica(
        request: zio.aws.rds.model.SwitchoverReadReplicaRequest
    ): IO[AwsError, zio.aws.rds.model.SwitchoverReadReplicaResponse.ReadOnly] =
      asyncRequestResponse[
        SwitchoverReadReplicaRequest,
        SwitchoverReadReplicaResponse
      ]("switchoverReadReplica", api.switchoverReadReplica)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.SwitchoverReadReplicaResponse.wrap)
        .provideEnvironment(r)
    def deleteDBCluster(
        request: zio.aws.rds.model.DeleteDbClusterRequest
    ): IO[AwsError, zio.aws.rds.model.DeleteDbClusterResponse.ReadOnly] =
      asyncRequestResponse[DeleteDbClusterRequest, DeleteDbClusterResponse](
        "deleteDBCluster",
        api.deleteDBCluster
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.DeleteDbClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteGlobalCluster(
        request: zio.aws.rds.model.DeleteGlobalClusterRequest
    ): IO[AwsError, zio.aws.rds.model.DeleteGlobalClusterResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteGlobalClusterRequest,
        DeleteGlobalClusterResponse
      ]("deleteGlobalCluster", api.deleteGlobalCluster)(request.buildAwsValue())
        .map(zio.aws.rds.model.DeleteGlobalClusterResponse.wrap)
        .provideEnvironment(r)
    def describeReservedDBInstances(
        request: zio.aws.rds.model.DescribeReservedDbInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.ReservedDBInstance.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeReservedDbInstancesRequest,
        ReservedDBInstance,
        DescribeReservedDBInstancesPublisher
      ](
        "describeReservedDBInstances",
        api.describeReservedDBInstancesPaginator,
        _.reservedDBInstances()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.ReservedDBInstance.wrap(item))
        .provideEnvironment(r)
    def describeReservedDBInstancesPaginated(
        request: zio.aws.rds.model.DescribeReservedDbInstancesRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReservedDbInstancesRequest,
      DescribeReservedDbInstancesResponse
    ]("describeReservedDBInstances", api.describeReservedDBInstances)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeReservedDbInstancesResponse.wrap)
      .provideEnvironment(r)
    def createDBInstanceReadReplica(
        request: zio.aws.rds.model.CreateDbInstanceReadReplicaRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.CreateDbInstanceReadReplicaResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDbInstanceReadReplicaRequest,
      CreateDbInstanceReadReplicaResponse
    ]("createDBInstanceReadReplica", api.createDBInstanceReadReplica)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.CreateDbInstanceReadReplicaResponse.wrap)
      .provideEnvironment(r)
    def deleteDBInstance(
        request: zio.aws.rds.model.DeleteDbInstanceRequest
    ): IO[AwsError, zio.aws.rds.model.DeleteDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[DeleteDbInstanceRequest, DeleteDbInstanceResponse](
        "deleteDBInstance",
        api.deleteDBInstance
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.DeleteDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def createOptionGroup(
        request: zio.aws.rds.model.CreateOptionGroupRequest
    ): IO[AwsError, zio.aws.rds.model.CreateOptionGroupResponse.ReadOnly] =
      asyncRequestResponse[CreateOptionGroupRequest, CreateOptionGroupResponse](
        "createOptionGroup",
        api.createOptionGroup
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.CreateOptionGroupResponse.wrap)
        .provideEnvironment(r)
    def deregisterDBProxyTargets(
        request: zio.aws.rds.model.DeregisterDbProxyTargetsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DeregisterDbProxyTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterDbProxyTargetsRequest,
      DeregisterDbProxyTargetsResponse
    ]("deregisterDBProxyTargets", api.deregisterDBProxyTargets)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DeregisterDbProxyTargetsResponse.wrap)
      .provideEnvironment(r)
    def modifyDBProxyEndpoint(
        request: zio.aws.rds.model.ModifyDbProxyEndpointRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyDbProxyEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyDbProxyEndpointRequest,
        ModifyDbProxyEndpointResponse
      ]("modifyDBProxyEndpoint", api.modifyDBProxyEndpoint)(
        request.buildAwsValue()
      ).map(zio.aws.rds.model.ModifyDbProxyEndpointResponse.wrap)
        .provideEnvironment(r)
    def addSourceIdentifierToSubscription(
        request: zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      AddSourceIdentifierToSubscriptionRequest,
      AddSourceIdentifierToSubscriptionResponse
    ](
      "addSourceIdentifierToSubscription",
      api.addSourceIdentifierToSubscription
    )(request.buildAwsValue())
      .map(zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def modifyDBProxy(
        request: zio.aws.rds.model.ModifyDbProxyRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyDbProxyResponse.ReadOnly] =
      asyncRequestResponse[ModifyDbProxyRequest, ModifyDbProxyResponse](
        "modifyDBProxy",
        api.modifyDBProxy
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.ModifyDbProxyResponse.wrap)
        .provideEnvironment(r)
    def modifyOptionGroup(
        request: zio.aws.rds.model.ModifyOptionGroupRequest
    ): IO[AwsError, zio.aws.rds.model.ModifyOptionGroupResponse.ReadOnly] =
      asyncRequestResponse[ModifyOptionGroupRequest, ModifyOptionGroupResponse](
        "modifyOptionGroup",
        api.modifyOptionGroup
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.ModifyOptionGroupResponse.wrap)
        .provideEnvironment(r)
    def describeDBEngineVersions(
        request: zio.aws.rds.model.DescribeDbEngineVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBEngineVersion.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbEngineVersionsRequest,
        DBEngineVersion,
        DescribeDBEngineVersionsPublisher
      ](
        "describeDBEngineVersions",
        api.describeDBEngineVersionsPaginator,
        _.dbEngineVersions()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBEngineVersion.wrap(item))
        .provideEnvironment(r)
    def describeDBEngineVersionsPaginated(
        request: zio.aws.rds.model.DescribeDbEngineVersionsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbEngineVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbEngineVersionsRequest,
      DescribeDbEngineVersionsResponse
    ]("describeDBEngineVersions", api.describeDBEngineVersions)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbEngineVersionsResponse.wrap)
      .provideEnvironment(r)
    def describeAccountAttributes(
        request: zio.aws.rds.model.DescribeAccountAttributesRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeAccountAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse
    ]("describeAccountAttributes", api.describeAccountAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeAccountAttributesResponse.wrap)
      .provideEnvironment(r)
    def createGlobalCluster(
        request: zio.aws.rds.model.CreateGlobalClusterRequest
    ): IO[AwsError, zio.aws.rds.model.CreateGlobalClusterResponse.ReadOnly] =
      asyncRequestResponse[
        CreateGlobalClusterRequest,
        CreateGlobalClusterResponse
      ]("createGlobalCluster", api.createGlobalCluster)(request.buildAwsValue())
        .map(zio.aws.rds.model.CreateGlobalClusterResponse.wrap)
        .provideEnvironment(r)
    def describeOrderableDBInstanceOptions(
        request: zio.aws.rds.model.DescribeOrderableDbInstanceOptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly
    ] = asyncJavaPaginatedRequest[
      DescribeOrderableDbInstanceOptionsRequest,
      OrderableDBInstanceOption,
      DescribeOrderableDBInstanceOptionsPublisher
    ](
      "describeOrderableDBInstanceOptions",
      api.describeOrderableDBInstanceOptionsPaginator,
      _.orderableDBInstanceOptions()
    )(request.buildAwsValue())
      .map(item => zio.aws.rds.model.OrderableDBInstanceOption.wrap(item))
      .provideEnvironment(r)
    def describeOrderableDBInstanceOptionsPaginated(
        request: zio.aws.rds.model.DescribeOrderableDbInstanceOptionsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrderableDbInstanceOptionsRequest,
      DescribeOrderableDbInstanceOptionsResponse
    ](
      "describeOrderableDBInstanceOptions",
      api.describeOrderableDBInstanceOptions
    )(request.buildAwsValue())
      .map(zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.wrap)
      .provideEnvironment(r)
    def revokeDBSecurityGroupIngress(
        request: zio.aws.rds.model.RevokeDbSecurityGroupIngressRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      RevokeDbSecurityGroupIngressRequest,
      RevokeDbSecurityGroupIngressResponse
    ]("revokeDBSecurityGroupIngress", api.revokeDBSecurityGroupIngress)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.wrap)
      .provideEnvironment(r)
    def describeDBClusterSnapshotAttributes(
        request: zio.aws.rds.model.DescribeDbClusterSnapshotAttributesRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbClusterSnapshotAttributesRequest,
      DescribeDbClusterSnapshotAttributesResponse
    ](
      "describeDBClusterSnapshotAttributes",
      api.describeDBClusterSnapshotAttributes
    )(request.buildAwsValue())
      .map(zio.aws.rds.model.DescribeDbClusterSnapshotAttributesResponse.wrap)
      .provideEnvironment(r)
    def stopDBInstanceAutomatedBackupsReplication(
        request: zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      StopDbInstanceAutomatedBackupsReplicationRequest,
      StopDbInstanceAutomatedBackupsReplicationResponse
    ](
      "stopDBInstanceAutomatedBackupsReplication",
      api.stopDBInstanceAutomatedBackupsReplication
    )(request.buildAwsValue())
      .map(
        zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse.wrap
      )
      .provideEnvironment(r)
    def describeEvents(
        request: zio.aws.rds.model.DescribeEventsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.Event.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeEventsRequest,
        Event,
        DescribeEventsPublisher
      ]("describeEvents", api.describeEventsPaginator, _.events())(
        request.buildAwsValue()
      ).map(item => zio.aws.rds.model.Event.wrap(item)).provideEnvironment(r)
    def describeEventsPaginated(
        request: zio.aws.rds.model.DescribeEventsRequest
    ): IO[AwsError, zio.aws.rds.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[DescribeEventsRequest, DescribeEventsResponse](
        "describeEvents",
        api.describeEvents
      )(request.buildAwsValue())
        .map(zio.aws.rds.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
    def deleteCustomDBEngineVersion(
        request: zio.aws.rds.model.DeleteCustomDbEngineVersionRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DeleteCustomDbEngineVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteCustomDbEngineVersionRequest,
      DeleteCustomDbEngineVersionResponse
    ]("deleteCustomDBEngineVersion", api.deleteCustomDBEngineVersion)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DeleteCustomDbEngineVersionResponse.wrap)
      .provideEnvironment(r)
    def describeDBParameterGroups(
        request: zio.aws.rds.model.DescribeDbParameterGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.rds.model.DBParameterGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        DescribeDbParameterGroupsRequest,
        DBParameterGroup,
        DescribeDBParameterGroupsPublisher
      ](
        "describeDBParameterGroups",
        api.describeDBParameterGroupsPaginator,
        _.dbParameterGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.rds.model.DBParameterGroup.wrap(item))
        .provideEnvironment(r)
    def describeDBParameterGroupsPaginated(
        request: zio.aws.rds.model.DescribeDbParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.rds.model.DescribeDbParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDbParameterGroupsRequest,
      DescribeDbParameterGroupsResponse
    ]("describeDBParameterGroups", api.describeDBParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.rds.model.DescribeDbParameterGroupsResponse.wrap)
      .provideEnvironment(r)
  }
  def downloadDBLogFilePortion(
      request: zio.aws.rds.model.DownloadDbLogFilePortionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DownloadDbLogFilePortionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.downloadDBLogFilePortion(request))
  def copyDBClusterSnapshot(
      request: zio.aws.rds.model.CopyDbClusterSnapshotRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CopyDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBClusterSnapshot(request))
  def describeEngineDefaultParameters(
      request: zio.aws.rds.model.DescribeEngineDefaultParametersRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeEngineDefaultParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngineDefaultParameters(request))
  def modifyDBInstance(request: zio.aws.rds.model.ModifyDbInstanceRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBInstance(request))
  def deleteDBProxy(request: zio.aws.rds.model.DeleteDbProxyRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteDbProxyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBProxy(request))
  def describeDBClusterEndpoints(
      request: zio.aws.rds.model.DescribeDbClusterEndpointsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBClusterEndpoint.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterEndpoints(request))
  def describeDBClusterEndpointsPaginated(
      request: zio.aws.rds.model.DescribeDbClusterEndpointsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbClusterEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterEndpointsPaginated(request))
  def deleteBlueGreenDeployment(
      request: zio.aws.rds.model.DeleteBlueGreenDeploymentRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteBlueGreenDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBlueGreenDeployment(request))
  def stopActivityStream(
      request: zio.aws.rds.model.StopActivityStreamRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StopActivityStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopActivityStream(request))
  def failoverGlobalCluster(
      request: zio.aws.rds.model.FailoverGlobalClusterRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.FailoverGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.failoverGlobalCluster(request))
  def describeDBLogFiles(
      request: zio.aws.rds.model.DescribeDbLogFilesRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBLogFiles(request))
  def describeDBLogFilesPaginated(
      request: zio.aws.rds.model.DescribeDbLogFilesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbLogFilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBLogFilesPaginated(request))
  def describeDBSnapshots(
      request: zio.aws.rds.model.DescribeDbSnapshotsRequest
  ): ZStream[zio.aws.rds.Rds, AwsError, zio.aws.rds.model.DBSnapshot.ReadOnly] =
    ZStream.serviceWithStream(_.describeDBSnapshots(request))
  def describeDBSnapshotsPaginated(
      request: zio.aws.rds.model.DescribeDbSnapshotsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBSnapshotsPaginated(request))
  def describeDBParameters(
      request: zio.aws.rds.model.DescribeDbParametersRequest
  ): ZStream[zio.aws.rds.Rds, AwsError, zio.aws.rds.model.Parameter.ReadOnly] =
    ZStream.serviceWithStream(_.describeDBParameters(request))
  def describeDBParametersPaginated(
      request: zio.aws.rds.model.DescribeDbParametersRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBParametersPaginated(request))
  def addTagsToResource(
      request: zio.aws.rds.model.AddTagsToResourceRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTagsToResource(request))
  def describeDBProxies(
      request: zio.aws.rds.model.DescribeDbProxiesRequest
  ): ZStream[zio.aws.rds.Rds, AwsError, zio.aws.rds.model.DBProxy.ReadOnly] =
    ZStream.serviceWithStream(_.describeDBProxies(request))
  def describeDBProxiesPaginated(
      request: zio.aws.rds.model.DescribeDbProxiesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbProxiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBProxiesPaginated(request))
  def describeDBClusterSnapshots(
      request: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBClusterSnapshot.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterSnapshots(request))
  def describeDBClusterSnapshotsPaginated(
      request: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbClusterSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterSnapshotsPaginated(request))
  def resetDBClusterParameterGroup(
      request: zio.aws.rds.model.ResetDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ResetDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetDBClusterParameterGroup(request))
  def describeDBProxyEndpoints(
      request: zio.aws.rds.model.DescribeDbProxyEndpointsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBProxyEndpoint.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBProxyEndpoints(request))
  def describeDBProxyEndpointsPaginated(
      request: zio.aws.rds.model.DescribeDbProxyEndpointsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbProxyEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBProxyEndpointsPaginated(request))
  def removeSourceIdentifierFromSubscription(
      request: zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeSourceIdentifierFromSubscription(request))
  def describeEngineDefaultClusterParameters(
      request: zio.aws.rds.model.DescribeEngineDefaultClusterParametersRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngineDefaultClusterParameters(request))
  def createDBSubnetGroup(
      request: zio.aws.rds.model.CreateDbSubnetGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBSubnetGroup(request))
  def createDBClusterEndpoint(
      request: zio.aws.rds.model.CreateDbClusterEndpointRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbClusterEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBClusterEndpoint(request))
  def addRoleToDBCluster(
      request: zio.aws.rds.model.AddRoleToDbClusterRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addRoleToDBCluster(request))
  def modifyCustomDBEngineVersion(
      request: zio.aws.rds.model.ModifyCustomDbEngineVersionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyCustomDbEngineVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCustomDBEngineVersion(request))
  def copyDBClusterParameterGroup(
      request: zio.aws.rds.model.CopyDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CopyDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBClusterParameterGroup(request))
  def describePendingMaintenanceActions(
      request: zio.aws.rds.model.DescribePendingMaintenanceActionsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly
  ] = ZStream.serviceWithStream(_.describePendingMaintenanceActions(request))
  def describePendingMaintenanceActionsPaginated(
      request: zio.aws.rds.model.DescribePendingMaintenanceActionsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePendingMaintenanceActionsPaginated(request))
  def deleteDBClusterEndpoint(
      request: zio.aws.rds.model.DeleteDbClusterEndpointRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteDbClusterEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBClusterEndpoint(request))
  def addRoleToDBInstance(
      request: zio.aws.rds.model.AddRoleToDbInstanceRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addRoleToDBInstance(request))
  def startActivityStream(
      request: zio.aws.rds.model.StartActivityStreamRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StartActivityStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startActivityStream(request))
  def deleteDBClusterParameterGroup(
      request: zio.aws.rds.model.DeleteDbClusterParameterGroupRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBClusterParameterGroup(request))
  def createDBSecurityGroup(
      request: zio.aws.rds.model.CreateDbSecurityGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbSecurityGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBSecurityGroup(request))
  def describeSourceRegions(
      request: zio.aws.rds.model.DescribeSourceRegionsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.SourceRegion.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSourceRegions(request))
  def describeSourceRegionsPaginated(
      request: zio.aws.rds.model.DescribeSourceRegionsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeSourceRegionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSourceRegionsPaginated(request))
  def backtrackDBCluster(
      request: zio.aws.rds.model.BacktrackDbClusterRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.BacktrackDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.backtrackDBCluster(request))
  def removeFromGlobalCluster(
      request: zio.aws.rds.model.RemoveFromGlobalClusterRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RemoveFromGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeFromGlobalCluster(request))
  def modifyDBClusterParameterGroup(
      request: zio.aws.rds.model.ModifyDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBClusterParameterGroup(request))
  def rebootDBCluster(request: zio.aws.rds.model.RebootDbClusterRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RebootDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootDBCluster(request))
  def cancelExportTask(request: zio.aws.rds.model.CancelExportTaskRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CancelExportTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelExportTask(request))
  def createDBSnapshot(request: zio.aws.rds.model.CreateDbSnapshotRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBSnapshot(request))
  def deleteDBInstanceAutomatedBackup(
      request: zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteDbInstanceAutomatedBackupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBInstanceAutomatedBackup(request))
  def deleteDBSnapshot(request: zio.aws.rds.model.DeleteDbSnapshotRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteDbSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBSnapshot(request))
  def stopDBCluster(request: zio.aws.rds.model.StopDbClusterRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StopDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDBCluster(request))
  def createDBCluster(request: zio.aws.rds.model.CreateDbClusterRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBCluster(request))
  def describeCertificates(
      request: zio.aws.rds.model.DescribeCertificatesRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.Certificate.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCertificates(request))
  def describeCertificatesPaginated(
      request: zio.aws.rds.model.DescribeCertificatesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificatesPaginated(request))
  def modifyDBSnapshot(request: zio.aws.rds.model.ModifyDbSnapshotRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBSnapshot(request))
  def deleteEventSubscription(
      request: zio.aws.rds.model.DeleteEventSubscriptionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventSubscription(request))
  def deleteDBSecurityGroup(
      request: zio.aws.rds.model.DeleteDbSecurityGroupRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBSecurityGroup(request))
  def deleteDBParameterGroup(
      request: zio.aws.rds.model.DeleteDbParameterGroupRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBParameterGroup(request))
  def describeDBSecurityGroups(
      request: zio.aws.rds.model.DescribeDbSecurityGroupsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBSecurityGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBSecurityGroups(request))
  def describeDBSecurityGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbSecurityGroupsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbSecurityGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBSecurityGroupsPaginated(request))
  def purchaseReservedDBInstancesOffering(
      request: zio.aws.rds.model.PurchaseReservedDbInstancesOfferingRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseReservedDBInstancesOffering(request))
  def describeDBSubnetGroups(
      request: zio.aws.rds.model.DescribeDbSubnetGroupsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBSubnetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBSubnetGroups(request))
  def describeDBSubnetGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbSubnetGroupsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBSubnetGroupsPaginated(request))
  def removeRoleFromDBCluster(
      request: zio.aws.rds.model.RemoveRoleFromDbClusterRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeRoleFromDBCluster(request))
  def createDBClusterParameterGroup(
      request: zio.aws.rds.model.CreateDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBClusterParameterGroup(request))
  def modifyDBCluster(request: zio.aws.rds.model.ModifyDbClusterRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBCluster(request))
  def restoreDBClusterFromS3(
      request: zio.aws.rds.model.RestoreDbClusterFromS3Request
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RestoreDbClusterFromS3Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBClusterFromS3(request))
  def describeValidDBInstanceModifications(
      request: zio.aws.rds.model.DescribeValidDbInstanceModificationsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeValidDBInstanceModifications(request))
  def createDBProxyEndpoint(
      request: zio.aws.rds.model.CreateDbProxyEndpointRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbProxyEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBProxyEndpoint(request))
  def resetDBParameterGroup(
      request: zio.aws.rds.model.ResetDbParameterGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ResetDbParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetDBParameterGroup(request))
  def createBlueGreenDeployment(
      request: zio.aws.rds.model.CreateBlueGreenDeploymentRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateBlueGreenDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBlueGreenDeployment(request))
  def deleteDBProxyEndpoint(
      request: zio.aws.rds.model.DeleteDbProxyEndpointRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteDbProxyEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBProxyEndpoint(request))
  def removeTagsFromResource(
      request: zio.aws.rds.model.RemoveTagsFromResourceRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def promoteReadReplica(
      request: zio.aws.rds.model.PromoteReadReplicaRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.PromoteReadReplicaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.promoteReadReplica(request))
  def describeBlueGreenDeployments(
      request: zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.BlueGreenDeployment.ReadOnly
  ] = ZStream.serviceWithStream(_.describeBlueGreenDeployments(request))
  def describeBlueGreenDeploymentsPaginated(
      request: zio.aws.rds.model.DescribeBlueGreenDeploymentsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeBlueGreenDeploymentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBlueGreenDeploymentsPaginated(request))
  def describeReservedDBInstancesOfferings(
      request: zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedDBInstancesOfferings(request))
  def describeReservedDBInstancesOfferingsPaginated(
      request: zio.aws.rds.model.DescribeReservedDbInstancesOfferingsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeReservedDBInstancesOfferingsPaginated(request))
  def createDBParameterGroup(
      request: zio.aws.rds.model.CreateDbParameterGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBParameterGroup(request))
  def startExportTask(request: zio.aws.rds.model.StartExportTaskRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StartExportTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startExportTask(request))
  def applyPendingMaintenanceAction(
      request: zio.aws.rds.model.ApplyPendingMaintenanceActionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applyPendingMaintenanceAction(request))
  def modifyDBSubnetGroup(
      request: zio.aws.rds.model.ModifyDbSubnetGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBSubnetGroup(request))
  def modifyGlobalCluster(
      request: zio.aws.rds.model.ModifyGlobalClusterRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyGlobalCluster(request))
  def copyDBSnapshot(request: zio.aws.rds.model.CopyDbSnapshotRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CopyDbSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBSnapshot(request))
  def modifyActivityStream(
      request: zio.aws.rds.model.ModifyActivityStreamRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyActivityStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyActivityStream(request))
  def restoreDBClusterFromSnapshot(
      request: zio.aws.rds.model.RestoreDbClusterFromSnapshotRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBClusterFromSnapshot(request))
  def copyOptionGroup(request: zio.aws.rds.model.CopyOptionGroupRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CopyOptionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyOptionGroup(request))
  def restoreDBInstanceFromS3(
      request: zio.aws.rds.model.RestoreDbInstanceFromS3Request
  ): ZIO[zio.aws.rds.Rds, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.restoreDBInstanceFromS3(request))
  def removeRoleFromDBInstance(
      request: zio.aws.rds.model.RemoveRoleFromDbInstanceRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeRoleFromDBInstance(request))
  def describeGlobalClusters(
      request: zio.aws.rds.model.DescribeGlobalClustersRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.GlobalCluster.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGlobalClusters(request))
  def describeGlobalClustersPaginated(
      request: zio.aws.rds.model.DescribeGlobalClustersRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGlobalClustersPaginated(request))
  def describeDBProxyTargetGroups(
      request: zio.aws.rds.model.DescribeDbProxyTargetGroupsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBProxyTargetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBProxyTargetGroups(request))
  def describeDBProxyTargetGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbProxyTargetGroupsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbProxyTargetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBProxyTargetGroupsPaginated(request))
  def describeDBInstanceAutomatedBackups(
      request: zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBInstanceAutomatedBackups(request))
  def describeDBInstanceAutomatedBackupsPaginated(
      request: zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbInstanceAutomatedBackupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBInstanceAutomatedBackupsPaginated(request))
  def describeDBClusterParameters(
      request: zio.aws.rds.model.DescribeDbClusterParametersRequest
  ): ZStream[zio.aws.rds.Rds, AwsError, zio.aws.rds.model.Parameter.ReadOnly] =
    ZStream.serviceWithStream(_.describeDBClusterParameters(request))
  def describeDBClusterParametersPaginated(
      request: zio.aws.rds.model.DescribeDbClusterParametersRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbClusterParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterParametersPaginated(request))
  def copyDBParameterGroup(
      request: zio.aws.rds.model.CopyDbParameterGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CopyDbParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBParameterGroup(request))
  def modifyDBSnapshotAttribute(
      request: zio.aws.rds.model.ModifyDbSnapshotAttributeRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbSnapshotAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBSnapshotAttribute(request))
  def authorizeDBSecurityGroupIngress(
      request: zio.aws.rds.model.AuthorizeDbSecurityGroupIngressRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.AuthorizeDbSecurityGroupIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeDBSecurityGroupIngress(request))
  def modifyEventSubscription(
      request: zio.aws.rds.model.ModifyEventSubscriptionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEventSubscription(request))
  def describeDBClusterBacktracks(
      request: zio.aws.rds.model.DescribeDbClusterBacktracksRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBClusterBacktrack.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterBacktracks(request))
  def describeDBClusterBacktracksPaginated(
      request: zio.aws.rds.model.DescribeDbClusterBacktracksRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbClusterBacktracksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterBacktracksPaginated(request))
  def modifyDBParameterGroup(
      request: zio.aws.rds.model.ModifyDbParameterGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBParameterGroup(request))
  def modifyCertificates(
      request: zio.aws.rds.model.ModifyCertificatesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCertificates(request))
  def createDBInstance(request: zio.aws.rds.model.CreateDbInstanceRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBInstance(request))
  def deleteDBClusterSnapshot(
      request: zio.aws.rds.model.DeleteDbClusterSnapshotRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBClusterSnapshot(request))
  def describeExportTasks(
      request: zio.aws.rds.model.DescribeExportTasksRequest
  ): ZStream[zio.aws.rds.Rds, AwsError, zio.aws.rds.model.ExportTask.ReadOnly] =
    ZStream.serviceWithStream(_.describeExportTasks(request))
  def describeExportTasksPaginated(
      request: zio.aws.rds.model.DescribeExportTasksRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeExportTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExportTasksPaginated(request))
  def startDBCluster(request: zio.aws.rds.model.StartDbClusterRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StartDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDBCluster(request))
  def modifyDBClusterSnapshotAttribute(
      request: zio.aws.rds.model.ModifyDbClusterSnapshotAttributeRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBClusterSnapshotAttribute(request))
  def createDBProxy(request: zio.aws.rds.model.CreateDbProxyRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbProxyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBProxy(request))
  def describeDBSnapshotAttributes(
      request: zio.aws.rds.model.DescribeDbSnapshotAttributesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBSnapshotAttributes(request))
  def describeEventCategories(
      request: zio.aws.rds.model.DescribeEventCategoriesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeEventCategoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventCategories(request))
  def deleteDBSubnetGroup(
      request: zio.aws.rds.model.DeleteDbSubnetGroupRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBSubnetGroup(request))
  def modifyDBClusterEndpoint(
      request: zio.aws.rds.model.ModifyDbClusterEndpointRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbClusterEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBClusterEndpoint(request))
  def startDBInstance(request: zio.aws.rds.model.StartDbInstanceRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StartDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDBInstance(request))
  def promoteReadReplicaDBCluster(
      request: zio.aws.rds.model.PromoteReadReplicaDbClusterRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.PromoteReadReplicaDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.promoteReadReplicaDBCluster(request))
  def switchoverBlueGreenDeployment(
      request: zio.aws.rds.model.SwitchoverBlueGreenDeploymentRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.SwitchoverBlueGreenDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.switchoverBlueGreenDeployment(request))
  def registerDBProxyTargets(
      request: zio.aws.rds.model.RegisterDbProxyTargetsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RegisterDbProxyTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerDBProxyTargets(request))
  def stopDBInstance(request: zio.aws.rds.model.StopDbInstanceRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StopDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDBInstance(request))
  def modifyDBProxyTargetGroup(
      request: zio.aws.rds.model.ModifyDbProxyTargetGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbProxyTargetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBProxyTargetGroup(request))
  def restoreDBInstanceFromDBSnapshot(
      request: zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RestoreDbInstanceFromDbSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBInstanceFromDBSnapshot(request))
  def rebootDBInstance(request: zio.aws.rds.model.RebootDbInstanceRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RebootDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootDBInstance(request))
  def describeOptionGroupOptions(
      request: zio.aws.rds.model.DescribeOptionGroupOptionsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.OptionGroupOption.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOptionGroupOptions(request))
  def describeOptionGroupOptionsPaginated(
      request: zio.aws.rds.model.DescribeOptionGroupOptionsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeOptionGroupOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOptionGroupOptionsPaginated(request))
  def startDBInstanceAutomatedBackupsReplication(
      request: zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDBInstanceAutomatedBackupsReplication(request))
  def describeDBClusterParameterGroups(
      request: zio.aws.rds.model.DescribeDbClusterParameterGroupsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterParameterGroups(request))
  def describeDBClusterParameterGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbClusterParameterGroupsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterParameterGroupsPaginated(request))
  def restoreDBInstanceToPointInTime(
      request: zio.aws.rds.model.RestoreDbInstanceToPointInTimeRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RestoreDbInstanceToPointInTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBInstanceToPointInTime(request))
  def createEventSubscription(
      request: zio.aws.rds.model.CreateEventSubscriptionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventSubscription(request))
  def createCustomDBEngineVersion(
      request: zio.aws.rds.model.CreateCustomDbEngineVersionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateCustomDbEngineVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomDBEngineVersion(request))
  def describeOptionGroups(
      request: zio.aws.rds.model.DescribeOptionGroupsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.OptionGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOptionGroups(request))
  def describeOptionGroupsPaginated(
      request: zio.aws.rds.model.DescribeOptionGroupsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeOptionGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOptionGroupsPaginated(request))
  def listTagsForResource(
      request: zio.aws.rds.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def restoreDBClusterToPointInTime(
      request: zio.aws.rds.model.RestoreDbClusterToPointInTimeRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBClusterToPointInTime(request))
  def describeDBProxyTargets(
      request: zio.aws.rds.model.DescribeDbProxyTargetsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBProxyTarget.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBProxyTargets(request))
  def describeDBProxyTargetsPaginated(
      request: zio.aws.rds.model.DescribeDbProxyTargetsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbProxyTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBProxyTargetsPaginated(request))
  def describeDBClusters(
      request: zio.aws.rds.model.DescribeDbClustersRequest
  ): ZStream[zio.aws.rds.Rds, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
    ZStream.serviceWithStream(_.describeDBClusters(request))
  def describeDBClustersPaginated(
      request: zio.aws.rds.model.DescribeDbClustersRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClustersPaginated(request))
  def failoverDBCluster(
      request: zio.aws.rds.model.FailoverDbClusterRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.FailoverDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.failoverDBCluster(request))
  def deleteOptionGroup(
      request: zio.aws.rds.model.DeleteOptionGroupRequest
  ): ZIO[zio.aws.rds.Rds, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteOptionGroup(request))
  def describeEventSubscriptions(
      request: zio.aws.rds.model.DescribeEventSubscriptionsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.EventSubscription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEventSubscriptions(request))
  def describeEventSubscriptionsPaginated(
      request: zio.aws.rds.model.DescribeEventSubscriptionsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeEventSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventSubscriptionsPaginated(request))
  def describeDBInstances(
      request: zio.aws.rds.model.DescribeDbInstancesRequest
  ): ZStream[zio.aws.rds.Rds, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
    ZStream.serviceWithStream(_.describeDBInstances(request))
  def describeDBInstancesPaginated(
      request: zio.aws.rds.model.DescribeDbInstancesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBInstancesPaginated(request))
  def createDBClusterSnapshot(
      request: zio.aws.rds.model.CreateDbClusterSnapshotRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBClusterSnapshot(request))
  def modifyCurrentDBClusterCapacity(
      request: zio.aws.rds.model.ModifyCurrentDbClusterCapacityRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyCurrentDbClusterCapacityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCurrentDBClusterCapacity(request))
  def switchoverReadReplica(
      request: zio.aws.rds.model.SwitchoverReadReplicaRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.SwitchoverReadReplicaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.switchoverReadReplica(request))
  def deleteDBCluster(request: zio.aws.rds.model.DeleteDbClusterRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBCluster(request))
  def deleteGlobalCluster(
      request: zio.aws.rds.model.DeleteGlobalClusterRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGlobalCluster(request))
  def describeReservedDBInstances(
      request: zio.aws.rds.model.DescribeReservedDbInstancesRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ReservedDBInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedDBInstances(request))
  def describeReservedDBInstancesPaginated(
      request: zio.aws.rds.model.DescribeReservedDbInstancesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeReservedDbInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedDBInstancesPaginated(request))
  def createDBInstanceReadReplica(
      request: zio.aws.rds.model.CreateDbInstanceReadReplicaRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateDbInstanceReadReplicaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBInstanceReadReplica(request))
  def deleteDBInstance(request: zio.aws.rds.model.DeleteDbInstanceRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBInstance(request))
  def createOptionGroup(
      request: zio.aws.rds.model.CreateOptionGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateOptionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOptionGroup(request))
  def deregisterDBProxyTargets(
      request: zio.aws.rds.model.DeregisterDbProxyTargetsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeregisterDbProxyTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterDBProxyTargets(request))
  def modifyDBProxyEndpoint(
      request: zio.aws.rds.model.ModifyDbProxyEndpointRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbProxyEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBProxyEndpoint(request))
  def addSourceIdentifierToSubscription(
      request: zio.aws.rds.model.AddSourceIdentifierToSubscriptionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addSourceIdentifierToSubscription(request))
  def modifyDBProxy(request: zio.aws.rds.model.ModifyDbProxyRequest): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyDbProxyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBProxy(request))
  def modifyOptionGroup(
      request: zio.aws.rds.model.ModifyOptionGroupRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.ModifyOptionGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyOptionGroup(request))
  def describeDBEngineVersions(
      request: zio.aws.rds.model.DescribeDbEngineVersionsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBEngineVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBEngineVersions(request))
  def describeDBEngineVersionsPaginated(
      request: zio.aws.rds.model.DescribeDbEngineVersionsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBEngineVersionsPaginated(request))
  def describeAccountAttributes(
      request: zio.aws.rds.model.DescribeAccountAttributesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeAccountAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAttributes(request))
  def createGlobalCluster(
      request: zio.aws.rds.model.CreateGlobalClusterRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.CreateGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGlobalCluster(request))
  def describeOrderableDBInstanceOptions(
      request: zio.aws.rds.model.DescribeOrderableDbInstanceOptionsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.OrderableDBInstanceOption.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOrderableDBInstanceOptions(request))
  def describeOrderableDBInstanceOptionsPaginated(
      request: zio.aws.rds.model.DescribeOrderableDbInstanceOptionsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrderableDBInstanceOptionsPaginated(request))
  def revokeDBSecurityGroupIngress(
      request: zio.aws.rds.model.RevokeDbSecurityGroupIngressRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.RevokeDbSecurityGroupIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeDBSecurityGroupIngress(request))
  def describeDBClusterSnapshotAttributes(
      request: zio.aws.rds.model.DescribeDbClusterSnapshotAttributesRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterSnapshotAttributes(request))
  def stopDBInstanceAutomatedBackupsReplication(
      request: zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDBInstanceAutomatedBackupsReplication(request))
  def describeEvents(
      request: zio.aws.rds.model.DescribeEventsRequest
  ): ZStream[zio.aws.rds.Rds, AwsError, zio.aws.rds.model.Event.ReadOnly] =
    ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(
      request: zio.aws.rds.model.DescribeEventsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
  def deleteCustomDBEngineVersion(
      request: zio.aws.rds.model.DeleteCustomDbEngineVersionRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DeleteCustomDbEngineVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomDBEngineVersion(request))
  def describeDBParameterGroups(
      request: zio.aws.rds.model.DescribeDbParameterGroupsRequest
  ): ZStream[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DBParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBParameterGroups(request))
  def describeDBParameterGroupsPaginated(
      request: zio.aws.rds.model.DescribeDbParameterGroupsRequest
  ): ZIO[
    zio.aws.rds.Rds,
    AwsError,
    zio.aws.rds.model.DescribeDbParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBParameterGroupsPaginated(request))
}
