package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourcePendingMaintenanceActions(
    resourceIdentifier: Optional[String] = Optional.Absent,
    pendingMaintenanceActionDetails: Optional[
      Iterable[zio.aws.rds.model.PendingMaintenanceAction]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions = {
    import ResourcePendingMaintenanceActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions
      .builder()
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActionDetails)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly =
    zio.aws.rds.model.ResourcePendingMaintenanceActions.wrap(buildAwsValue())
}
object ResourcePendingMaintenanceActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ResourcePendingMaintenanceActions =
      zio.aws.rds.model.ResourcePendingMaintenanceActions(
        resourceIdentifier.map(value => value),
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceIdentifier: Optional[String]
    def pendingMaintenanceActionDetails
        : Optional[List[zio.aws.rds.model.PendingMaintenanceAction.ReadOnly]]
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getPendingMaintenanceActionDetails: ZIO[Any, AwsError, List[
      zio.aws.rds.model.PendingMaintenanceAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActionDetails",
      pendingMaintenanceActionDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions
  ) extends zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly {
    override val resourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIdentifier())
      .map(value => value: String)
    override val pendingMaintenanceActionDetails
        : Optional[List[zio.aws.rds.model.PendingMaintenanceAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingMaintenanceActionDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.PendingMaintenanceAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions
  ): zio.aws.rds.model.ResourcePendingMaintenanceActions.ReadOnly = new Wrapper(
    impl
  )
}
