package zio.aws.rds.model
import scala.jdk.CollectionConverters.*
sealed trait IAMAuthMode {
  def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode
}
object IAMAuthMode {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.IAMAuthMode
  ): zio.aws.rds.model.IAMAuthMode = value match {
    case software.amazon.awssdk.services.rds.model.IAMAuthMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.IAMAuthMode.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.rds.model.IAMAuthMode.REQUIRED =>
      val r = REQUIRED
      r
    case software.amazon.awssdk.services.rds.model.IAMAuthMode.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.IAMAuthMode {
    override def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode =
      software.amazon.awssdk.services.rds.model.IAMAuthMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.rds.model.IAMAuthMode {
    override def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode =
      software.amazon.awssdk.services.rds.model.IAMAuthMode.DISABLED
  }
  case object REQUIRED extends zio.aws.rds.model.IAMAuthMode {
    override def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode =
      software.amazon.awssdk.services.rds.model.IAMAuthMode.REQUIRED
  }
  case object ENABLED extends zio.aws.rds.model.IAMAuthMode {
    override def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode =
      software.amazon.awssdk.services.rds.model.IAMAuthMode.ENABLED
  }
}
