package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CopyDbSnapshotResponse(
    dbSnapshot: Optional[zio.aws.rds.model.DBSnapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse = {
    import CopyDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse
      .builder()
      .optionallyWith(dbSnapshot.map(value => value.buildAwsValue()))(
        _.dbSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyDbSnapshotResponse.ReadOnly =
    zio.aws.rds.model.CopyDbSnapshotResponse.wrap(buildAwsValue())
}
object CopyDbSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyDbSnapshotResponse = zio.aws.rds.model
      .CopyDbSnapshotResponse(dbSnapshot.map(value => value.asEditable))
    def dbSnapshot: Optional[zio.aws.rds.model.DBSnapshot.ReadOnly]
    def getDbSnapshot
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbSnapshot", dbSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse
  ) extends zio.aws.rds.model.CopyDbSnapshotResponse.ReadOnly {
    override val dbSnapshot: Optional[zio.aws.rds.model.DBSnapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSnapshot())
        .map(value => zio.aws.rds.model.DBSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse
  ): zio.aws.rds.model.CopyDbSnapshotResponse.ReadOnly = new Wrapper(impl)
}
