package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SwitchoverReadReplicaRequest(dbInstanceIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest = {
    import SwitchoverReadReplicaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.SwitchoverReadReplicaRequest.ReadOnly =
    zio.aws.rds.model.SwitchoverReadReplicaRequest.wrap(buildAwsValue())
}
object SwitchoverReadReplicaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.SwitchoverReadReplicaRequest =
      zio.aws.rds.model.SwitchoverReadReplicaRequest(dbInstanceIdentifier)
    def dbInstanceIdentifier: String
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest
  ) extends zio.aws.rds.model.SwitchoverReadReplicaRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest
  ): zio.aws.rds.model.SwitchoverReadReplicaRequest.ReadOnly = new Wrapper(impl)
}
