package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OptionVersion(
    version: Optional[String] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionVersion = {
    import OptionVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionVersion
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionVersion.ReadOnly =
    zio.aws.rds.model.OptionVersion.wrap(buildAwsValue())
}
object OptionVersion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.OptionVersion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionVersion = zio.aws.rds.model
      .OptionVersion(version.map(value => value), isDefault.map(value => value))
    def version: Optional[String]
    def isDefault: Optional[Boolean]
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionVersion
  ) extends zio.aws.rds.model.OptionVersion.ReadOnly {
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionVersion
  ): zio.aws.rds.model.OptionVersion.ReadOnly = new Wrapper(impl)
}
