package zio.aws.rds.model
import zio.aws.rds.model.primitives.{
  DBClusterIdentifier,
  GlobalClusterIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FailoverGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    targetDbClusterIdentifier: DBClusterIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest = {
    import FailoverGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .targetDbClusterIdentifier(
        DBClusterIdentifier.unwrap(targetDbClusterIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.FailoverGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.FailoverGlobalClusterRequest.wrap(buildAwsValue())
}
object FailoverGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.FailoverGlobalClusterRequest =
      zio.aws.rds.model.FailoverGlobalClusterRequest(
        globalClusterIdentifier,
        targetDbClusterIdentifier
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def targetDbClusterIdentifier: DBClusterIdentifier
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getTargetDbClusterIdentifier: ZIO[Any, Nothing, DBClusterIdentifier] =
      ZIO.succeed(targetDbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest
  ) extends zio.aws.rds.model.FailoverGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.rds.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val targetDbClusterIdentifier: DBClusterIdentifier =
      zio.aws.rds.model.primitives
        .DBClusterIdentifier(impl.targetDbClusterIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest
  ): zio.aws.rds.model.FailoverGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
