package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGlobalClusterRequest(globalClusterIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest = {
    import DeleteGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(globalClusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.DeleteGlobalClusterRequest.wrap(buildAwsValue())
}
object DeleteGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteGlobalClusterRequest =
      zio.aws.rds.model.DeleteGlobalClusterRequest(globalClusterIdentifier)
    def globalClusterIdentifier: String
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest
  ) extends zio.aws.rds.model.DeleteGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: String =
      impl.globalClusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest
  ): zio.aws.rds.model.DeleteGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
