package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDbInstanceResponse(
    dbInstance: Optional[zio.aws.rds.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse = {
    import DeleteDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbInstanceResponse.ReadOnly =
    zio.aws.rds.model.DeleteDbInstanceResponse.wrap(buildAwsValue())
}
object DeleteDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbInstanceResponse =
      zio.aws.rds.model
        .DeleteDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse
  ) extends zio.aws.rds.model.DeleteDbInstanceResponse.ReadOnly {
    override val dbInstance: Optional[zio.aws.rds.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.rds.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse
  ): zio.aws.rds.model.DeleteDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
