package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterPendingModifiedValues(
    pendingCloudwatchLogsExports: Optional[
      zio.aws.rds.model.PendingCloudwatchLogsExports
    ] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues = {
    import ClusterPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues
      .builder()
      .optionallyWith(
        pendingCloudwatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudwatchLogsExports)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly =
    zio.aws.rds.model.ClusterPendingModifiedValues.wrap(buildAwsValue())
}
object ClusterPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ClusterPendingModifiedValues =
      zio.aws.rds.model.ClusterPendingModifiedValues(
        pendingCloudwatchLogsExports.map(value => value.asEditable),
        dbClusterIdentifier.map(value => value),
        masterUserPassword.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        engineVersion.map(value => value)
      )
    def pendingCloudwatchLogsExports
        : Optional[zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly]
    def dbClusterIdentifier: Optional[String]
    def masterUserPassword: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def getPendingCloudwatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudwatchLogsExports",
      pendingCloudwatchLogsExports
    )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getIamDatabaseAuthenticationEnabled
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "iamDatabaseAuthenticationEnabled",
      iamDatabaseAuthenticationEnabled
    )
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues
  ) extends zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly {
    override val pendingCloudwatchLogsExports
        : Optional[zio.aws.rds.model.PendingCloudwatchLogsExports.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingCloudwatchLogsExports())
        .map(value =>
          zio.aws.rds.model.PendingCloudwatchLogsExports.wrap(value)
        )
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues
  ): zio.aws.rds.model.ClusterPendingModifiedValues.ReadOnly = new Wrapper(impl)
}
