package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class PendingMaintenanceAction(
    action: Optional[String] = Optional.Absent,
    autoAppliedAfterDate: Optional[TStamp] = Optional.Absent,
    forcedApplyDate: Optional[TStamp] = Optional.Absent,
    optInStatus: Optional[String] = Optional.Absent,
    currentApplyDate: Optional[TStamp] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PendingMaintenanceAction = {
    import PendingMaintenanceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PendingMaintenanceAction
      .builder()
      .optionallyWith(action.map(value => value: java.lang.String))(_.action)
      .optionallyWith(
        autoAppliedAfterDate.map(value => TStamp.unwrap(value): Instant)
      )(_.autoAppliedAfterDate)
      .optionallyWith(
        forcedApplyDate.map(value => TStamp.unwrap(value): Instant)
      )(_.forcedApplyDate)
      .optionallyWith(optInStatus.map(value => value: java.lang.String))(
        _.optInStatus
      )
      .optionallyWith(
        currentApplyDate.map(value => TStamp.unwrap(value): Instant)
      )(_.currentApplyDate)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.PendingMaintenanceAction.ReadOnly =
    zio.aws.rds.model.PendingMaintenanceAction.wrap(buildAwsValue())
}
object PendingMaintenanceAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PendingMaintenanceAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.PendingMaintenanceAction =
      zio.aws.rds.model.PendingMaintenanceAction(
        action.map(value => value),
        autoAppliedAfterDate.map(value => value),
        forcedApplyDate.map(value => value),
        optInStatus.map(value => value),
        currentApplyDate.map(value => value),
        description.map(value => value)
      )
    def action: Optional[String]
    def autoAppliedAfterDate: Optional[TStamp]
    def forcedApplyDate: Optional[TStamp]
    def optInStatus: Optional[String]
    def currentApplyDate: Optional[TStamp]
    def description: Optional[String]
    def getAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("action", action)
    def getAutoAppliedAfterDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("autoAppliedAfterDate", autoAppliedAfterDate)
    def getForcedApplyDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("forcedApplyDate", forcedApplyDate)
    def getOptInStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
    def getCurrentApplyDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("currentApplyDate", currentApplyDate)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PendingMaintenanceAction
  ) extends zio.aws.rds.model.PendingMaintenanceAction.ReadOnly {
    override val action: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => value: String)
    override val autoAppliedAfterDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.autoAppliedAfterDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val forcedApplyDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.forcedApplyDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val optInStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optInStatus())
      .map(value => value: String)
    override val currentApplyDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.currentApplyDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PendingMaintenanceAction
  ): zio.aws.rds.model.PendingMaintenanceAction.ReadOnly = new Wrapper(impl)
}
