package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyDbSnapshotResponse(
    dbSnapshot: Optional[zio.aws.rds.model.DBSnapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse = {
    import ModifyDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse
      .builder()
      .optionallyWith(dbSnapshot.map(value => value.buildAwsValue()))(
        _.dbSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbSnapshotResponse.ReadOnly =
    zio.aws.rds.model.ModifyDbSnapshotResponse.wrap(buildAwsValue())
}
object ModifyDbSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbSnapshotResponse =
      zio.aws.rds.model
        .ModifyDbSnapshotResponse(dbSnapshot.map(value => value.asEditable))
    def dbSnapshot: Optional[zio.aws.rds.model.DBSnapshot.ReadOnly]
    def getDbSnapshot
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbSnapshot", dbSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse
  ) extends zio.aws.rds.model.ModifyDbSnapshotResponse.ReadOnly {
    override val dbSnapshot: Optional[zio.aws.rds.model.DBSnapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSnapshot())
        .map(value => zio.aws.rds.model.DBSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse
  ): zio.aws.rds.model.ModifyDbSnapshotResponse.ReadOnly = new Wrapper(impl)
}
