package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGlobalClusterRequest(
    globalClusterIdentifier: Optional[String] = Optional.Absent,
    sourceDBClusterIdentifier: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest = {
    import CreateGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        sourceDBClusterIdentifier.map(value => value: java.lang.String)
      )(_.sourceDBClusterIdentifier)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateGlobalClusterRequest.ReadOnly =
    zio.aws.rds.model.CreateGlobalClusterRequest.wrap(buildAwsValue())
}
object CreateGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateGlobalClusterRequest =
      zio.aws.rds.model.CreateGlobalClusterRequest(
        globalClusterIdentifier.map(value => value),
        sourceDBClusterIdentifier.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        deletionProtection.map(value => value),
        databaseName.map(value => value),
        storageEncrypted.map(value => value)
      )
    def globalClusterIdentifier: Optional[String]
    def sourceDBClusterIdentifier: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def deletionProtection: Optional[BooleanOptional]
    def databaseName: Optional[String]
    def storageEncrypted: Optional[BooleanOptional]
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getSourceDBClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceDBClusterIdentifier", sourceDBClusterIdentifier)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest
  ) extends zio.aws.rds.model.CreateGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterIdentifier())
        .map(value => value: String)
    override val sourceDBClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDBClusterIdentifier())
        .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val storageEncrypted: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEncrypted())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest
  ): zio.aws.rds.model.CreateGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
