package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDbProxyRequest(
    dbProxyName: String,
    engineFamily: zio.aws.rds.model.EngineFamily,
    auth: Iterable[zio.aws.rds.model.UserAuthConfig],
    roleArn: String,
    vpcSubnetIds: Iterable[String],
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    requireTLS: Optional[Boolean] = Optional.Absent,
    idleClientTimeout: Optional[IntegerOptional] = Optional.Absent,
    debugLogging: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbProxyRequest = {
    import CreateDbProxyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbProxyRequest
      .builder()
      .dbProxyName(dbProxyName: java.lang.String)
      .engineFamily(engineFamily.unwrap)
      .auth(auth.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(roleArn: java.lang.String)
      .vpcSubnetIds(vpcSubnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(requireTLS.map(value => value: java.lang.Boolean))(
        _.requireTLS
      )
      .optionallyWith(idleClientTimeout.map(value => value: Integer))(
        _.idleClientTimeout
      )
      .optionallyWith(debugLogging.map(value => value: java.lang.Boolean))(
        _.debugLogging
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbProxyRequest.ReadOnly =
    zio.aws.rds.model.CreateDbProxyRequest.wrap(buildAwsValue())
}
object CreateDbProxyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbProxyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbProxyRequest =
      zio.aws.rds.model.CreateDbProxyRequest(
        dbProxyName,
        engineFamily,
        auth.map { item =>
          item.asEditable
        },
        roleArn,
        vpcSubnetIds,
        vpcSecurityGroupIds.map(value => value),
        requireTLS.map(value => value),
        idleClientTimeout.map(value => value),
        debugLogging.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbProxyName: String
    def engineFamily: zio.aws.rds.model.EngineFamily
    def auth: List[zio.aws.rds.model.UserAuthConfig.ReadOnly]
    def roleArn: String
    def vpcSubnetIds: List[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def requireTLS: Optional[Boolean]
    def idleClientTimeout: Optional[IntegerOptional]
    def debugLogging: Optional[Boolean]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyName)
    def getEngineFamily: ZIO[Any, Nothing, zio.aws.rds.model.EngineFamily] =
      ZIO.succeed(engineFamily)
    def getAuth
        : ZIO[Any, Nothing, List[zio.aws.rds.model.UserAuthConfig.ReadOnly]] =
      ZIO.succeed(auth)
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getVpcSubnetIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(vpcSubnetIds)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getRequireTLS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requireTLS", requireTLS)
    def getIdleClientTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeout)
    def getDebugLogging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("debugLogging", debugLogging)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbProxyRequest
  ) extends zio.aws.rds.model.CreateDbProxyRequest.ReadOnly {
    override val dbProxyName: String = impl.dbProxyName(): String
    override val engineFamily: zio.aws.rds.model.EngineFamily =
      zio.aws.rds.model.EngineFamily.wrap(impl.engineFamily())
    override val auth: List[zio.aws.rds.model.UserAuthConfig.ReadOnly] = impl
      .auth()
      .asScala
      .map { item =>
        zio.aws.rds.model.UserAuthConfig.wrap(item)
      }
      .toList
    override val roleArn: String = impl.roleArn(): String
    override val vpcSubnetIds: List[String] = impl
      .vpcSubnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val requireTLS: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requireTLS())
      .map(value => value: Boolean)
    override val idleClientTimeout: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idleClientTimeout())
        .map(value => value: IntegerOptional)
    override val debugLogging: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.debugLogging())
      .map(value => value: Boolean)
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbProxyRequest
  ): zio.aws.rds.model.CreateDbProxyRequest.ReadOnly = new Wrapper(impl)
}
