package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class CreateCustomDbEngineVersionResponse(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    dbParameterGroupFamily: Optional[String] = Optional.Absent,
    dbEngineDescription: Optional[String] = Optional.Absent,
    dbEngineVersionDescription: Optional[String] = Optional.Absent,
    defaultCharacterSet: Optional[zio.aws.rds.model.CharacterSet] =
      Optional.Absent,
    supportedCharacterSets: Optional[Iterable[zio.aws.rds.model.CharacterSet]] =
      Optional.Absent,
    supportedNcharCharacterSets: Optional[
      Iterable[zio.aws.rds.model.CharacterSet]
    ] = Optional.Absent,
    validUpgradeTarget: Optional[Iterable[zio.aws.rds.model.UpgradeTarget]] =
      Optional.Absent,
    supportedTimezones: Optional[Iterable[zio.aws.rds.model.Timezone]] =
      Optional.Absent,
    exportableLogTypes: Optional[Iterable[String]] = Optional.Absent,
    supportsLogExportsToCloudwatchLogs: Optional[Boolean] = Optional.Absent,
    supportsReadReplica: Optional[Boolean] = Optional.Absent,
    supportedEngineModes: Optional[Iterable[String]] = Optional.Absent,
    supportedFeatureNames: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    supportsParallelQuery: Optional[Boolean] = Optional.Absent,
    supportsGlobalDatabases: Optional[Boolean] = Optional.Absent,
    majorEngineVersion: Optional[String] = Optional.Absent,
    databaseInstallationFilesS3BucketName: Optional[String] = Optional.Absent,
    databaseInstallationFilesS3Prefix: Optional[String] = Optional.Absent,
    dbEngineVersionArn: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    createTime: Optional[TStamp] = Optional.Absent,
    tagList: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    supportsBabelfish: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse = {
    import CreateCustomDbEngineVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(
        dbEngineDescription.map(value => value: java.lang.String)
      )(_.dbEngineDescription)
      .optionallyWith(
        dbEngineVersionDescription.map(value => value: java.lang.String)
      )(_.dbEngineVersionDescription)
      .optionallyWith(defaultCharacterSet.map(value => value.buildAwsValue()))(
        _.defaultCharacterSet
      )
      .optionallyWith(
        supportedCharacterSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedCharacterSets)
      .optionallyWith(
        supportedNcharCharacterSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedNcharCharacterSets)
      .optionallyWith(
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validUpgradeTarget)
      .optionallyWith(
        supportedTimezones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedTimezones)
      .optionallyWith(
        exportableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exportableLogTypes)
      .optionallyWith(
        supportsLogExportsToCloudwatchLogs.map(value =>
          value: java.lang.Boolean
        )
      )(_.supportsLogExportsToCloudwatchLogs)
      .optionallyWith(
        supportsReadReplica.map(value => value: java.lang.Boolean)
      )(_.supportsReadReplica)
      .optionallyWith(
        supportedEngineModes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedEngineModes)
      .optionallyWith(
        supportedFeatureNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.supportedFeatureNames)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        supportsParallelQuery.map(value => value: java.lang.Boolean)
      )(_.supportsParallelQuery)
      .optionallyWith(
        supportsGlobalDatabases.map(value => value: java.lang.Boolean)
      )(_.supportsGlobalDatabases)
      .optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(
        _.majorEngineVersion
      )
      .optionallyWith(
        databaseInstallationFilesS3BucketName.map(value =>
          value: java.lang.String
        )
      )(_.databaseInstallationFilesS3BucketName)
      .optionallyWith(
        databaseInstallationFilesS3Prefix.map(value => value: java.lang.String)
      )(_.databaseInstallationFilesS3Prefix)
      .optionallyWith(dbEngineVersionArn.map(value => value: java.lang.String))(
        _.dbEngineVersionArn
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(createTime.map(value => TStamp.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(supportsBabelfish.map(value => value: java.lang.Boolean))(
        _.supportsBabelfish
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CreateCustomDbEngineVersionResponse.ReadOnly =
    zio.aws.rds.model.CreateCustomDbEngineVersionResponse.wrap(buildAwsValue())
}
object CreateCustomDbEngineVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateCustomDbEngineVersionResponse =
      zio.aws.rds.model.CreateCustomDbEngineVersionResponse(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbParameterGroupFamily.map(value => value),
        dbEngineDescription.map(value => value),
        dbEngineVersionDescription.map(value => value),
        defaultCharacterSet.map(value => value.asEditable),
        supportedCharacterSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedNcharCharacterSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedTimezones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        exportableLogTypes.map(value => value),
        supportsLogExportsToCloudwatchLogs.map(value => value),
        supportsReadReplica.map(value => value),
        supportedEngineModes.map(value => value),
        supportedFeatureNames.map(value => value),
        status.map(value => value),
        supportsParallelQuery.map(value => value),
        supportsGlobalDatabases.map(value => value),
        majorEngineVersion.map(value => value),
        databaseInstallationFilesS3BucketName.map(value => value),
        databaseInstallationFilesS3Prefix.map(value => value),
        dbEngineVersionArn.map(value => value),
        kmsKeyId.map(value => value),
        createTime.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportsBabelfish.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def dbParameterGroupFamily: Optional[String]
    def dbEngineDescription: Optional[String]
    def dbEngineVersionDescription: Optional[String]
    def defaultCharacterSet: Optional[zio.aws.rds.model.CharacterSet.ReadOnly]
    def supportedCharacterSets
        : Optional[List[zio.aws.rds.model.CharacterSet.ReadOnly]]
    def supportedNcharCharacterSets
        : Optional[List[zio.aws.rds.model.CharacterSet.ReadOnly]]
    def validUpgradeTarget
        : Optional[List[zio.aws.rds.model.UpgradeTarget.ReadOnly]]
    def supportedTimezones: Optional[List[zio.aws.rds.model.Timezone.ReadOnly]]
    def exportableLogTypes: Optional[List[String]]
    def supportsLogExportsToCloudwatchLogs: Optional[Boolean]
    def supportsReadReplica: Optional[Boolean]
    def supportedEngineModes: Optional[List[String]]
    def supportedFeatureNames: Optional[List[String]]
    def status: Optional[String]
    def supportsParallelQuery: Optional[Boolean]
    def supportsGlobalDatabases: Optional[Boolean]
    def majorEngineVersion: Optional[String]
    def databaseInstallationFilesS3BucketName: Optional[String]
    def databaseInstallationFilesS3Prefix: Optional[String]
    def dbEngineVersionArn: Optional[String]
    def kmsKeyId: Optional[String]
    def createTime: Optional[TStamp]
    def tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def supportsBabelfish: Optional[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDbEngineDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbEngineDescription", dbEngineDescription)
    def getDbEngineVersionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbEngineVersionDescription",
        dbEngineVersionDescription
      )
    def getDefaultCharacterSet
        : ZIO[Any, AwsError, zio.aws.rds.model.CharacterSet.ReadOnly] =
      AwsError.unwrapOptionField("defaultCharacterSet", defaultCharacterSet)
    def getSupportedCharacterSets
        : ZIO[Any, AwsError, List[zio.aws.rds.model.CharacterSet.ReadOnly]] =
      AwsError.unwrapOptionField(
        "supportedCharacterSets",
        supportedCharacterSets
      )
    def getSupportedNcharCharacterSets
        : ZIO[Any, AwsError, List[zio.aws.rds.model.CharacterSet.ReadOnly]] =
      AwsError.unwrapOptionField(
        "supportedNcharCharacterSets",
        supportedNcharCharacterSets
      )
    def getValidUpgradeTarget
        : ZIO[Any, AwsError, List[zio.aws.rds.model.UpgradeTarget.ReadOnly]] =
      AwsError.unwrapOptionField("validUpgradeTarget", validUpgradeTarget)
    def getSupportedTimezones
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Timezone.ReadOnly]] =
      AwsError.unwrapOptionField("supportedTimezones", supportedTimezones)
    def getExportableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exportableLogTypes", exportableLogTypes)
    def getSupportsLogExportsToCloudwatchLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsLogExportsToCloudwatchLogs",
        supportsLogExportsToCloudwatchLogs
      )
    def getSupportsReadReplica: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsReadReplica", supportsReadReplica)
    def getSupportedEngineModes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedEngineModes", supportedEngineModes)
    def getSupportedFeatureNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("supportedFeatureNames", supportedFeatureNames)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSupportsParallelQuery: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsParallelQuery", supportsParallelQuery)
    def getSupportsGlobalDatabases: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("supportsGlobalDatabases", supportsGlobalDatabases)
    def getMajorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersion)
    def getDatabaseInstallationFilesS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "databaseInstallationFilesS3BucketName",
        databaseInstallationFilesS3BucketName
      )
    def getDatabaseInstallationFilesS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "databaseInstallationFilesS3Prefix",
        databaseInstallationFilesS3Prefix
      )
    def getDbEngineVersionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbEngineVersionArn", dbEngineVersionArn)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getSupportsBabelfish: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsBabelfish", supportsBabelfish)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse
  ) extends zio.aws.rds.model.CreateCustomDbEngineVersionResponse.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val dbParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroupFamily())
        .map(value => value: String)
    override val dbEngineDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbEngineDescription())
      .map(value => value: String)
    override val dbEngineVersionDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbEngineVersionDescription())
        .map(value => value: String)
    override val defaultCharacterSet
        : Optional[zio.aws.rds.model.CharacterSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCharacterSet())
        .map(value => zio.aws.rds.model.CharacterSet.wrap(value))
    override val supportedCharacterSets
        : Optional[List[zio.aws.rds.model.CharacterSet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedCharacterSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.CharacterSet.wrap(item)
          }.toList
        )
    override val supportedNcharCharacterSets
        : Optional[List[zio.aws.rds.model.CharacterSet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedNcharCharacterSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.CharacterSet.wrap(item)
          }.toList
        )
    override val validUpgradeTarget
        : Optional[List[zio.aws.rds.model.UpgradeTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validUpgradeTarget())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.UpgradeTarget.wrap(item)
          }.toList
        )
    override val supportedTimezones
        : Optional[List[zio.aws.rds.model.Timezone.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedTimezones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Timezone.wrap(item)
          }.toList
        )
    override val exportableLogTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportableLogTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val supportsLogExportsToCloudwatchLogs: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsLogExportsToCloudwatchLogs())
        .map(value => value: Boolean)
    override val supportsReadReplica: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.supportsReadReplica())
      .map(value => value: Boolean)
    override val supportedEngineModes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedEngineModes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val supportedFeatureNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedFeatureNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val supportsParallelQuery: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsParallelQuery())
        .map(value => value: Boolean)
    override val supportsGlobalDatabases: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsGlobalDatabases())
        .map(value => value: Boolean)
    override val majorEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.majorEngineVersion())
      .map(value => value: String)
    override val databaseInstallationFilesS3BucketName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseInstallationFilesS3BucketName())
        .map(value => value: String)
    override val databaseInstallationFilesS3Prefix: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseInstallationFilesS3Prefix())
        .map(value => value: String)
    override val dbEngineVersionArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbEngineVersionArn())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val createTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val supportsBabelfish: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.supportsBabelfish())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse
  ): zio.aws.rds.model.CreateCustomDbEngineVersionResponse.ReadOnly =
    new Wrapper(impl)
}
