package zio.aws.rds.model
import scala.jdk.CollectionConverters.*
sealed trait TargetType {
  def unwrap: software.amazon.awssdk.services.rds.model.TargetType
}
object TargetType {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.TargetType
  ): zio.aws.rds.model.TargetType = value match {
    case software.amazon.awssdk.services.rds.model.TargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.TargetType.RDS_INSTANCE =>
      val r = RDS_INSTANCE
      r
    case software.amazon.awssdk.services.rds.model.TargetType.RDS_SERVERLESS_ENDPOINT =>
      val r = RDS_SERVERLESS_ENDPOINT
      r
    case software.amazon.awssdk.services.rds.model.TargetType.TRACKED_CLUSTER =>
      val r = TRACKED_CLUSTER
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetType =
      software.amazon.awssdk.services.rds.model.TargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object RDS_INSTANCE extends zio.aws.rds.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetType =
      software.amazon.awssdk.services.rds.model.TargetType.RDS_INSTANCE
  }
  case object RDS_SERVERLESS_ENDPOINT extends zio.aws.rds.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetType =
      software.amazon.awssdk.services.rds.model.TargetType.RDS_SERVERLESS_ENDPOINT
  }
  case object TRACKED_CLUSTER extends zio.aws.rds.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.rds.model.TargetType =
      software.amazon.awssdk.services.rds.model.TargetType.TRACKED_CLUSTER
  }
}
