package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TargetHealth(
    state: Optional[zio.aws.rds.model.TargetState] = Optional.Absent,
    reason: Optional[zio.aws.rds.model.TargetHealthReason] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.TargetHealth = {
    import TargetHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.TargetHealth
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(reason.map(value => value.unwrap))(_.reason)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.TargetHealth.ReadOnly =
    zio.aws.rds.model.TargetHealth.wrap(buildAwsValue())
}
object TargetHealth {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.TargetHealth] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.TargetHealth =
      zio.aws.rds.model.TargetHealth(
        state.map(value => value),
        reason.map(value => value),
        description.map(value => value)
      )
    def state: Optional[zio.aws.rds.model.TargetState]
    def reason: Optional[zio.aws.rds.model.TargetHealthReason]
    def description: Optional[String]
    def getState: ZIO[Any, AwsError, zio.aws.rds.model.TargetState] =
      AwsError.unwrapOptionField("state", state)
    def getReason: ZIO[Any, AwsError, zio.aws.rds.model.TargetHealthReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.TargetHealth
  ) extends zio.aws.rds.model.TargetHealth.ReadOnly {
    override val state: Optional[zio.aws.rds.model.TargetState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.rds.model.TargetState.wrap(value))
    override val reason: Optional[zio.aws.rds.model.TargetHealthReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reason())
        .map(value => zio.aws.rds.model.TargetHealthReason.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.TargetHealth
  ): zio.aws.rds.model.TargetHealth.ReadOnly = new Wrapper(impl)
}
