package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class OptionConfiguration(
    optionName: String,
    port: Optional[IntegerOptional] = Optional.Absent,
    optionVersion: Optional[String] = Optional.Absent,
    dbSecurityGroupMemberships: Optional[Iterable[String]] = Optional.Absent,
    vpcSecurityGroupMemberships: Optional[Iterable[String]] = Optional.Absent,
    optionSettings: Optional[Iterable[zio.aws.rds.model.OptionSetting]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionConfiguration = {
    import OptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionConfiguration
      .builder()
      .optionName(optionName: java.lang.String)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(optionVersion.map(value => value: java.lang.String))(
        _.optionVersion
      )
      .optionallyWith(
        dbSecurityGroupMemberships.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dbSecurityGroupMemberships)
      .optionallyWith(
        vpcSecurityGroupMemberships.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupMemberships)
      .optionallyWith(
        optionSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionSettings)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionConfiguration.ReadOnly =
    zio.aws.rds.model.OptionConfiguration.wrap(buildAwsValue())
}
object OptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.OptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionConfiguration =
      zio.aws.rds.model.OptionConfiguration(
        optionName,
        port.map(value => value),
        optionVersion.map(value => value),
        dbSecurityGroupMemberships.map(value => value),
        vpcSecurityGroupMemberships.map(value => value),
        optionSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def optionName: String
    def port: Optional[IntegerOptional]
    def optionVersion: Optional[String]
    def dbSecurityGroupMemberships: Optional[List[String]]
    def vpcSecurityGroupMemberships: Optional[List[String]]
    def optionSettings: Optional[List[zio.aws.rds.model.OptionSetting.ReadOnly]]
    def getOptionName: ZIO[Any, Nothing, String] = ZIO.succeed(optionName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getOptionVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionVersion", optionVersion)
    def getDbSecurityGroupMemberships: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "dbSecurityGroupMemberships",
        dbSecurityGroupMemberships
      )
    def getVpcSecurityGroupMemberships: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "vpcSecurityGroupMemberships",
        vpcSecurityGroupMemberships
      )
    def getOptionSettings
        : ZIO[Any, AwsError, List[zio.aws.rds.model.OptionSetting.ReadOnly]] =
      AwsError.unwrapOptionField("optionSettings", optionSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionConfiguration
  ) extends zio.aws.rds.model.OptionConfiguration.ReadOnly {
    override val optionName: String = impl.optionName(): String
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val optionVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionVersion())
      .map(value => value: String)
    override val dbSecurityGroupMemberships: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSecurityGroupMemberships())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcSecurityGroupMemberships: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupMemberships())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val optionSettings
        : Optional[List[zio.aws.rds.model.OptionSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.OptionSetting.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionConfiguration
  ): zio.aws.rds.model.OptionConfiguration.ReadOnly = new Wrapper(impl)
}
