package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyDbSnapshotAttributeRequest(
    dbSnapshotIdentifier: String,
    attributeName: String,
    valuesToAdd: Optional[Iterable[String]] = Optional.Absent,
    valuesToRemove: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest = {
    import ModifyDbSnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest
      .builder()
      .dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String)
      .attributeName(attributeName: java.lang.String)
      .optionallyWith(
        valuesToAdd.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.valuesToAdd)
      .optionallyWith(
        valuesToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.valuesToRemove)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbSnapshotAttributeRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbSnapshotAttributeRequest.wrap(buildAwsValue())
}
object ModifyDbSnapshotAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbSnapshotAttributeRequest =
      zio.aws.rds.model.ModifyDbSnapshotAttributeRequest(
        dbSnapshotIdentifier,
        attributeName,
        valuesToAdd.map(value => value),
        valuesToRemove.map(value => value)
      )
    def dbSnapshotIdentifier: String
    def attributeName: String
    def valuesToAdd: Optional[List[String]]
    def valuesToRemove: Optional[List[String]]
    def getDbSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSnapshotIdentifier)
    def getAttributeName: ZIO[Any, Nothing, String] = ZIO.succeed(attributeName)
    def getValuesToAdd: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("valuesToAdd", valuesToAdd)
    def getValuesToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("valuesToRemove", valuesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest
  ) extends zio.aws.rds.model.ModifyDbSnapshotAttributeRequest.ReadOnly {
    override val dbSnapshotIdentifier: String =
      impl.dbSnapshotIdentifier(): String
    override val attributeName: String = impl.attributeName(): String
    override val valuesToAdd: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.valuesToAdd())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val valuesToRemove: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.valuesToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest
  ): zio.aws.rds.model.ModifyDbSnapshotAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
