package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GlobalCluster(
    globalClusterIdentifier: Optional[String] = Optional.Absent,
    globalClusterResourceId: Optional[String] = Optional.Absent,
    globalClusterArn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[BooleanOptional] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    globalClusterMembers: Optional[
      Iterable[zio.aws.rds.model.GlobalClusterMember]
    ] = Optional.Absent,
    failoverState: Optional[zio.aws.rds.model.FailoverState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.GlobalCluster = {
    import GlobalCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.GlobalCluster
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value => value: java.lang.String)
      )(_.globalClusterIdentifier)
      .optionallyWith(
        globalClusterResourceId.map(value => value: java.lang.String)
      )(_.globalClusterResourceId)
      .optionallyWith(globalClusterArn.map(value => value: java.lang.String))(
        _.globalClusterArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        globalClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalClusterMembers)
      .optionallyWith(failoverState.map(value => value.buildAwsValue()))(
        _.failoverState
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.GlobalCluster.ReadOnly =
    zio.aws.rds.model.GlobalCluster.wrap(buildAwsValue())
}
object GlobalCluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.GlobalCluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.GlobalCluster =
      zio.aws.rds.model.GlobalCluster(
        globalClusterIdentifier.map(value => value),
        globalClusterResourceId.map(value => value),
        globalClusterArn.map(value => value),
        status.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        databaseName.map(value => value),
        storageEncrypted.map(value => value),
        deletionProtection.map(value => value),
        globalClusterMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failoverState.map(value => value.asEditable)
      )
    def globalClusterIdentifier: Optional[String]
    def globalClusterResourceId: Optional[String]
    def globalClusterArn: Optional[String]
    def status: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def databaseName: Optional[String]
    def storageEncrypted: Optional[BooleanOptional]
    def deletionProtection: Optional[BooleanOptional]
    def globalClusterMembers
        : Optional[List[zio.aws.rds.model.GlobalClusterMember.ReadOnly]]
    def failoverState: Optional[zio.aws.rds.model.FailoverState.ReadOnly]
    def getGlobalClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getGlobalClusterResourceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterResourceId", globalClusterResourceId)
    def getGlobalClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("globalClusterArn", globalClusterArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getGlobalClusterMembers: ZIO[Any, AwsError, List[
      zio.aws.rds.model.GlobalClusterMember.ReadOnly
    ]] =
      AwsError.unwrapOptionField("globalClusterMembers", globalClusterMembers)
    def getFailoverState
        : ZIO[Any, AwsError, zio.aws.rds.model.FailoverState.ReadOnly] =
      AwsError.unwrapOptionField("failoverState", failoverState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.GlobalCluster
  ) extends zio.aws.rds.model.GlobalCluster.ReadOnly {
    override val globalClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterIdentifier())
        .map(value => value: String)
    override val globalClusterResourceId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterResourceId())
        .map(value => value: String)
    override val globalClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.globalClusterArn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val storageEncrypted: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEncrypted())
        .map(value => value: BooleanOptional)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val globalClusterMembers
        : Optional[List[zio.aws.rds.model.GlobalClusterMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterMembers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.GlobalClusterMember.wrap(item)
          }.toList
        )
    override val failoverState
        : Optional[zio.aws.rds.model.FailoverState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failoverState())
        .map(value => zio.aws.rds.model.FailoverState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.GlobalCluster
  ): zio.aws.rds.model.GlobalCluster.ReadOnly = new Wrapper(impl)
}
