package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeGlobalClustersResponse(
    marker: Optional[String] = Optional.Absent,
    globalClusters: Optional[Iterable[zio.aws.rds.model.GlobalCluster]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse = {
    import DescribeGlobalClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        globalClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalClusters)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly =
    zio.aws.rds.model.DescribeGlobalClustersResponse.wrap(buildAwsValue())
}
object DescribeGlobalClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeGlobalClustersResponse =
      zio.aws.rds.model.DescribeGlobalClustersResponse(
        marker.map(value => value),
        globalClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def globalClusters: Optional[List[zio.aws.rds.model.GlobalCluster.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getGlobalClusters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.GlobalCluster.ReadOnly]] =
      AwsError.unwrapOptionField("globalClusters", globalClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse
  ) extends zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val globalClusters
        : Optional[List[zio.aws.rds.model.GlobalCluster.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.GlobalCluster.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse
  ): zio.aws.rds.model.DescribeGlobalClustersResponse.ReadOnly = new Wrapper(
    impl
  )
}
