package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDbClusterEndpointRequest(
    dbClusterEndpointIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest = {
    import DeleteDbClusterEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest
      .builder()
      .dbClusterEndpointIdentifier(
        dbClusterEndpointIdentifier: java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbClusterEndpointRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbClusterEndpointRequest.wrap(buildAwsValue())
}
object DeleteDbClusterEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbClusterEndpointRequest =
      zio.aws.rds.model
        .DeleteDbClusterEndpointRequest(dbClusterEndpointIdentifier)
    def dbClusterEndpointIdentifier: String
    def getDbClusterEndpointIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterEndpointIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest
  ) extends zio.aws.rds.model.DeleteDbClusterEndpointRequest.ReadOnly {
    override val dbClusterEndpointIdentifier: String =
      impl.dbClusterEndpointIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest
  ): zio.aws.rds.model.DeleteDbClusterEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
