package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DBInstanceRole(
    roleArn: Optional[String] = Optional.Absent,
    featureName: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBInstanceRole = {
    import DBInstanceRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBInstanceRole
      .builder()
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(featureName.map(value => value: java.lang.String))(
        _.featureName
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBInstanceRole.ReadOnly =
    zio.aws.rds.model.DBInstanceRole.wrap(buildAwsValue())
}
object DBInstanceRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBInstanceRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBInstanceRole =
      zio.aws.rds.model.DBInstanceRole(
        roleArn.map(value => value),
        featureName.map(value => value),
        status.map(value => value)
      )
    def roleArn: Optional[String]
    def featureName: Optional[String]
    def status: Optional[String]
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getFeatureName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featureName", featureName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceRole
  ) extends zio.aws.rds.model.DBInstanceRole.ReadOnly {
    override val roleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: String)
    override val featureName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBInstanceRole
  ): zio.aws.rds.model.DBInstanceRole.ReadOnly = new Wrapper(impl)
}
