package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CopyDbClusterSnapshotResponse(
    dbClusterSnapshot: Optional[zio.aws.rds.model.DBClusterSnapshot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse = {
    import CopyDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse
      .builder()
      .optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.dbClusterSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyDbClusterSnapshotResponse.ReadOnly =
    zio.aws.rds.model.CopyDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object CopyDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyDbClusterSnapshotResponse =
      zio.aws.rds.model.CopyDbClusterSnapshotResponse(
        dbClusterSnapshot.map(value => value.asEditable)
      )
    def dbClusterSnapshot
        : Optional[zio.aws.rds.model.DBClusterSnapshot.ReadOnly]
    def getDbClusterSnapshot
        : ZIO[Any, AwsError, zio.aws.rds.model.DBClusterSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse
  ) extends zio.aws.rds.model.CopyDbClusterSnapshotResponse.ReadOnly {
    override val dbClusterSnapshot
        : Optional[zio.aws.rds.model.DBClusterSnapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshot())
        .map(value => zio.aws.rds.model.DBClusterSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse
  ): zio.aws.rds.model.CopyDbClusterSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
