package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, TStamp}
import scala.jdk.CollectionConverters.*
final case class Certificate(
    certificateIdentifier: Optional[String] = Optional.Absent,
    certificateType: Optional[String] = Optional.Absent,
    thumbprint: Optional[String] = Optional.Absent,
    validFrom: Optional[TStamp] = Optional.Absent,
    validTill: Optional[TStamp] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    customerOverride: Optional[BooleanOptional] = Optional.Absent,
    customerOverrideValidTill: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Certificate
      .builder()
      .optionallyWith(
        certificateIdentifier.map(value => value: java.lang.String)
      )(_.certificateIdentifier)
      .optionallyWith(certificateType.map(value => value: java.lang.String))(
        _.certificateType
      )
      .optionallyWith(thumbprint.map(value => value: java.lang.String))(
        _.thumbprint
      )
      .optionallyWith(validFrom.map(value => TStamp.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validTill.map(value => TStamp.unwrap(value): Instant))(
        _.validTill
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(customerOverride.map(value => value: java.lang.Boolean))(
        _.customerOverride
      )
      .optionallyWith(
        customerOverrideValidTill.map(value => TStamp.unwrap(value): Instant)
      )(_.customerOverrideValidTill)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Certificate.ReadOnly =
    zio.aws.rds.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Certificate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Certificate =
      zio.aws.rds.model.Certificate(
        certificateIdentifier.map(value => value),
        certificateType.map(value => value),
        thumbprint.map(value => value),
        validFrom.map(value => value),
        validTill.map(value => value),
        certificateArn.map(value => value),
        customerOverride.map(value => value),
        customerOverrideValidTill.map(value => value)
      )
    def certificateIdentifier: Optional[String]
    def certificateType: Optional[String]
    def thumbprint: Optional[String]
    def validFrom: Optional[TStamp]
    def validTill: Optional[TStamp]
    def certificateArn: Optional[String]
    def customerOverride: Optional[BooleanOptional]
    def customerOverrideValidTill: Optional[TStamp]
    def getCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifier)
    def getCertificateType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateType", certificateType)
    def getThumbprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("thumbprint", thumbprint)
    def getValidFrom: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidTill: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("validTill", validTill)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCustomerOverride: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("customerOverride", customerOverride)
    def getCustomerOverrideValidTill: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("customerOverrideValidTill", customerOverrideValidTill)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Certificate
  ) extends zio.aws.rds.model.Certificate.ReadOnly {
    override val certificateIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateIdentifier())
      .map(value => value: String)
    override val certificateType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateType())
      .map(value => value: String)
    override val thumbprint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.thumbprint())
      .map(value => value: String)
    override val validFrom: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.validFrom())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val validTill: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.validTill())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val customerOverride: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerOverride())
        .map(value => value: BooleanOptional)
    override val customerOverrideValidTill: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerOverrideValidTill())
        .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Certificate
  ): zio.aws.rds.model.Certificate.ReadOnly = new Wrapper(impl)
}
