package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Subnet(
    subnetIdentifier: Optional[String] = Optional.Absent,
    subnetAvailabilityZone: Optional[zio.aws.rds.model.AvailabilityZone] =
      Optional.Absent,
    subnetOutpost: Optional[zio.aws.rds.model.Outpost] = Optional.Absent,
    subnetStatus: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rds.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.Subnet
      .builder()
      .optionallyWith(subnetIdentifier.map(value => value: java.lang.String))(
        _.subnetIdentifier
      )
      .optionallyWith(
        subnetAvailabilityZone.map(value => value.buildAwsValue())
      )(_.subnetAvailabilityZone)
      .optionallyWith(subnetOutpost.map(value => value.buildAwsValue()))(
        _.subnetOutpost
      )
      .optionallyWith(subnetStatus.map(value => value: java.lang.String))(
        _.subnetStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.Subnet.ReadOnly =
    zio.aws.rds.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.Subnet = zio.aws.rds.model.Subnet(
      subnetIdentifier.map(value => value),
      subnetAvailabilityZone.map(value => value.asEditable),
      subnetOutpost.map(value => value.asEditable),
      subnetStatus.map(value => value)
    )
    def subnetIdentifier: Optional[String]
    def subnetAvailabilityZone
        : Optional[zio.aws.rds.model.AvailabilityZone.ReadOnly]
    def subnetOutpost: Optional[zio.aws.rds.model.Outpost.ReadOnly]
    def subnetStatus: Optional[String]
    def getSubnetIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifier)
    def getSubnetAvailabilityZone
        : ZIO[Any, AwsError, zio.aws.rds.model.AvailabilityZone.ReadOnly] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getSubnetOutpost
        : ZIO[Any, AwsError, zio.aws.rds.model.Outpost.ReadOnly] =
      AwsError.unwrapOptionField("subnetOutpost", subnetOutpost)
    def getSubnetStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetStatus", subnetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.Subnet
  ) extends zio.aws.rds.model.Subnet.ReadOnly {
    override val subnetIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIdentifier())
      .map(value => value: String)
    override val subnetAvailabilityZone
        : Optional[zio.aws.rds.model.AvailabilityZone.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetAvailabilityZone())
        .map(value => zio.aws.rds.model.AvailabilityZone.wrap(value))
    override val subnetOutpost: Optional[zio.aws.rds.model.Outpost.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetOutpost())
        .map(value => zio.aws.rds.model.Outpost.wrap(value))
    override val subnetStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetStatus())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.Subnet
  ): zio.aws.rds.model.Subnet.ReadOnly = new Wrapper(impl)
}
