package zio.aws.rds.model
import zio.aws.rds.model.primitives.DoubleOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServerlessV2ScalingConfiguration(
    minCapacity: Optional[DoubleOptional] = Optional.Absent,
    maxCapacity: Optional[DoubleOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfiguration = {
    import ServerlessV2ScalingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfiguration
      .builder()
      .optionallyWith(minCapacity.map(value => value: java.lang.Double))(
        _.minCapacity
      )
      .optionallyWith(maxCapacity.map(value => value: java.lang.Double))(
        _.maxCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly =
    zio.aws.rds.model.ServerlessV2ScalingConfiguration.wrap(buildAwsValue())
}
object ServerlessV2ScalingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ServerlessV2ScalingConfiguration =
      zio.aws.rds.model.ServerlessV2ScalingConfiguration(
        minCapacity.map(value => value),
        maxCapacity.map(value => value)
      )
    def minCapacity: Optional[DoubleOptional]
    def maxCapacity: Optional[DoubleOptional]
    def getMinCapacity: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfiguration
  ) extends zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly {
    override val minCapacity: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.minCapacity())
      .map(value => value: DoubleOptional)
    override val maxCapacity: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value => value: DoubleOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfiguration
  ): zio.aws.rds.model.ServerlessV2ScalingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
