package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResetDbClusterParameterGroupResponse(
    dbClusterParameterGroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse = {
    import ResetDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ResetDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.rds.model.ResetDbClusterParameterGroupResponse.wrap(buildAwsValue())
}
object ResetDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ResetDbClusterParameterGroupResponse =
      zio.aws.rds.model.ResetDbClusterParameterGroupResponse(
        dbClusterParameterGroupName.map(value => value)
      )
    def dbClusterParameterGroupName: Optional[String]
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse
  ) extends zio.aws.rds.model.ResetDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse
  ): zio.aws.rds.model.ResetDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
